/*
 * Decompiled with CFR 0.152.
 */
package de.wannawork.jcalendar;

import de.wannawork.jcalendar.JCalendarPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JCalendarComboBox
extends JPanel
implements ActionListener,
ChangeListener,
SwingConstants {
    private static final long serialVersionUID = 1L;
    private int _popupLocation = 2;
    private boolean _calendarWindowFocusLost = false;
    private Calendar _selected;
    private JToggleButton _button;
    private JSpinner _spinner;
    private JWindow _calendarWindow;
    private JCalendarPanel _calendarPanel;
    private ArrayList<ChangeListener> _changeListener = new ArrayList();
    private boolean _fireingChangeEvent = false;
    private boolean _changing;
    private JSpinner.DateEditor _editor;
    private SpinnerDateModel _model;
    boolean _unset = false;

    public static void main(String[] args) {
        try {
            JCalendarComboBox cal = new JCalendarComboBox();
            cal.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    System.out.println(JCalendarComboBox.this.getDate());
                }
            });
            cal.setDateFormat(new SimpleDateFormat("dd.mm.yyyy"));
            cal.setSpiningCalendarField(5);
            cal.setDate(null);
            JFrame f = new JFrame();
            f.setDefaultCloseOperation(3);
            f.getContentPane().add(cal);
            f.pack();
            f.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JCalendarComboBox() {
        this._calendarPanel = new JCalendarPanel();
        this.createGUI();
    }

    public JCalendarComboBox(Calendar cal) {
        this._calendarPanel = new JCalendarPanel(cal);
        this.createGUI();
    }

    public JCalendarComboBox(Locale locale) {
        this._calendarPanel = new JCalendarPanel(locale);
        this.createGUI();
    }

    public JCalendarComboBox(Calendar cal, Locale locale) {
        this._calendarPanel = new JCalendarPanel(cal, locale);
        this.createGUI();
    }

    public JCalendarComboBox(Calendar cal, Locale locale, DateFormat dateFormat) {
        this._calendarPanel = new JCalendarPanel(cal, locale, dateFormat);
        this.createGUI();
    }

    public JCalendarComboBox(Calendar cal, Locale locale, DateFormat dateFormat, int location) {
        this._calendarPanel = new JCalendarPanel(cal, locale, dateFormat);
        this._popupLocation = location;
        this.createGUI();
    }

    public JCalendarComboBox(Calendar cal, Locale locale, DateFormat dateFormat, int location, boolean flat) {
        this._calendarPanel = new JCalendarPanel(cal, locale, dateFormat, flat);
        this._popupLocation = location;
        this.createGUI();
    }

    public JCalendarComboBox(Calendar cal, Locale locale, DateFormat dateFormat, int location, boolean flat, int maxYear) {
        this._calendarPanel = new JCalendarPanel(cal, locale, dateFormat, flat, maxYear);
        this._popupLocation = location;
        this.createGUI();
    }

    private void createGUI() {
        this._calendarPanel.setListenerModus(2);
        this._selected = (Calendar)this._calendarPanel.getCalendar().clone();
        this._calendarPanel.addChangeListener(this);
        this._calendarPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setLayout(new BorderLayout());
        this._spinner = new JSpinner(){
            private static final long serialVersionUID = 1L;

            @Override
            public void commitEdit() throws ParseException {
                if (!JCalendarComboBox.this._unset) {
                    super.commitEdit();
                }
            }
        };
        this._model = new SpinnerDateModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getNextValue() {
                if (JCalendarComboBox.this._unset) {
                    return new Date();
                }
                return super.getNextValue();
            }

            @Override
            public Object getPreviousValue() {
                if (JCalendarComboBox.this._unset) {
                    return new Date();
                }
                return super.getPreviousValue();
            }
        };
        this._spinner.setModel(this._model);
        this._editor = new JSpinner.DateEditor(this._spinner, ((SimpleDateFormat)this._calendarPanel.getDateFormat()).toPattern());
        this._spinner.setEditor(this._editor);
        this._spinner.getModel().setValue(this._selected.getTime());
        this._spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JCalendarComboBox.this.notifySpinnerChange();
            }
        });
        this._editor.getTextField().setHorizontalAlignment(0);
        this._button = new JToggleButton(){
            private static final long serialVersionUID = 1L;
            final int maxW = 30;
            Dimension prefSize;

            @Override
            public Dimension getPreferredSize() {
                if (this.prefSize != null && (this.prefSize.width <= 30 && this.getHeight() <= 30 && this.getHeight() != this.prefSize.width || this.getHeight() > 30 && this.prefSize.width != 30)) {
                    this.prefSize = null;
                }
                if (this.prefSize == null) {
                    int d = this.getHeight() > 30 ? 30 : this.getHeight();
                    this.prefSize = new Dimension(d, d);
                }
                return this.prefSize;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this._button.setMargin(new Insets(2, 2, 2, 2));
        this._button.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("de/wannawork/jcalendar/jcalendar-icon.png")));
        this._button.setHorizontalAlignment(0);
        this._button.addActionListener(this);
        this._button.setEnabled(true);
        this._button.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent opposite;
                if (e.getOppositeComponent() != null && e.getOppositeComponent() instanceof JComponent && (opposite = (JComponent)e.getOppositeComponent()).getTopLevelAncestor() != JCalendarComboBox.this._calendarWindow && !JCalendarComboBox.this._calendarWindowFocusLost) {
                    JCalendarComboBox.this._calendarWindowFocusLost = false;
                }
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                JCalendarComboBox.this.hideCalendar();
            }
        });
        this.add((Component)this._spinner, "Center");
        this.add((Component)this._button, "East");
    }

    private Date getSpinnerDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)this._spinner.getModel().getValue());
        int year = cal.get(1);
        if (year < 1900) {
            cal.set(1, 1900);
            this._spinner.getModel().setValue(cal.getTime());
        } else if (year > 2100) {
            cal.set(1, 2100);
            this._spinner.getModel().setValue(cal.getTime());
        }
        return cal.getTime();
    }

    private void notifySpinnerChange() {
        if (this._changing) {
            return;
        }
        if (this._unset) {
            this._unset = false;
            this._editor.getTextField().setForeground(this._editor.getTextField().getForeground().darker().darker().darker());
        }
        Date s = this.getSpinnerDate();
        if (!this._selected.getTime().equals(s)) {
            this._selected.setTime(s);
            this.fireChangeEvent();
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this._spinner != null) {
            this._spinner.setFont(font);
        }
    }

    private void createCalendarWindow() {
        class ComponentL
        implements ComponentListener {
            Point p;

            ComponentL() {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                JCalendarComboBox.this.hideCalendar();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                if (this.p != null && !this.p.equals(e.getComponent().getLocation())) {
                    JCalendarComboBox.this.hideCalendar();
                }
                this.p = e.getComponent().getLocation();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                JCalendarComboBox.this.hideCalendar();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                JCalendarComboBox.this.hideCalendar();
            }
        }
        JInternalFrame internalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, this);
        Window ancestor = (Window)this.getTopLevelAncestor();
        this._calendarWindow = new JWindow(ancestor);
        JPanel contentPanel = (JPanel)this._calendarWindow.getContentPane();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add(this._calendarPanel);
        this._calendarPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\u001b') {
                    JCalendarComboBox.this.hideCalendar();
                    return;
                }
                if (e.getKeyChar() == '\n') {
                    JCalendarComboBox.this.setCalendar(JCalendarComboBox.this._calendarPanel.getCalendar());
                    return;
                }
            }
        });
        ((JComponent)((RootPaneContainer)((Object)ancestor)).getContentPane()).addAncestorListener(new AncestorListener(){
            Point p;

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                JCalendarComboBox.this.hideCalendar();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                if (this.p != null && !this.p.equals(event.getAncestor().getLocation())) {
                    JCalendarComboBox.this.hideCalendar();
                }
                this.p = event.getAncestor().getLocation();
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                JCalendarComboBox.this.hideCalendar();
            }
        });
        ((JComponent)((RootPaneContainer)((Object)ancestor)).getContentPane()).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JCalendarComboBox.this.hideCalendar();
            }
        });
        this._calendarWindow.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (JCalendarComboBox.this._button.isSelected()) {
                    JCalendarComboBox.this._calendarWindowFocusLost = true;
                }
                JCalendarComboBox.this.hideCalendar();
            }
        });
        if (internalFrame != null) {
            internalFrame.addComponentListener(new ComponentL());
        }
        ancestor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                JCalendarComboBox.this.hideCalendar();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                JCalendarComboBox.this.hideCalendar();
            }

            @Override
            public void windowStateChanged(WindowEvent e) {
                JCalendarComboBox.this.hideCalendar();
            }
        });
        ancestor.addComponentListener(new ComponentL());
        this._calendarWindow.pack();
    }

    public Calendar getCalendar() {
        if (this._unset) {
            return null;
        }
        return (Calendar)this._selected.clone();
    }

    public Date getDate() {
        if (this._unset) {
            return null;
        }
        return this._selected.getTime();
    }

    public void setCalendar(Calendar cal) {
        this.hideCalendar();
        if (this._selected.equals(cal)) {
            return;
        }
        if (this._unset) {
            this._unset = false;
            this._editor.getTextField().setForeground(this._editor.getTextField().getForeground().darker().darker().darker());
        }
        this._unset = cal == null;
        this._selected.setTime(cal != null ? cal.getTime() : new Date(0L));
        this._changing = true;
        this._spinner.getModel().setValue(cal != null ? cal.getTime() : new Date(0L));
        if (this._unset) {
            this._editor.getTextField().setText(this._editor.getFormat().toPattern());
            this._editor.getTextField().setForeground(this._editor.getTextField().getForeground().brighter().brighter().brighter());
        }
        this._changing = false;
        this.fireChangeEvent();
    }

    public void setDate(Date date) {
        this.hideCalendar();
        if (this._unset) {
            this._unset = false;
            this._editor.getTextField().setForeground(this._editor.getTextField().getForeground().darker().darker().darker());
        }
        this._unset = date == null;
        this._selected.setTime(date != null ? date : new Date());
        this._changing = true;
        this._spinner.getModel().setValue(date != null ? this._selected.getTime() : new Date());
        if (this._unset) {
            this._editor.getTextField().setText(this._editor.getFormat().toPattern());
            this._editor.getTextField().setForeground(this._editor.getTextField().getForeground().brighter().brighter().brighter());
        }
        this._changing = false;
        this.fireChangeEvent();
    }

    public JCalendarPanel getCalendarPanel() {
        return this._calendarPanel;
    }

    @Deprecated
    public void setVerticalAlignment(int value) {
    }

    public void setHorizontalAlignment(int value) {
        ((JSpinner.DefaultEditor)this._spinner.getEditor()).getTextField().setHorizontalAlignment(value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._button.isSelected()) {
            if (!this._calendarWindowFocusLost) {
                this.showCalender();
            } else {
                this._button.setSelected(false);
            }
            this._calendarWindowFocusLost = false;
        } else {
            this.hideCalendar();
        }
    }

    public void hideCalendar() {
        if (this._calendarWindow != null && this._calendarWindow.isVisible()) {
            this._button.setSelected(false);
            this._calendarWindow.setVisible(false);
        }
    }

    public void showCalender() {
        Window ancestor = (Window)this.getTopLevelAncestor();
        if (this._calendarWindow == null || ancestor != this._calendarWindow.getOwner()) {
            this.createCalendarWindow();
        }
        this._changing = true;
        if (this._unset) {
            this._selected.setTime(new Date());
        }
        this._calendarPanel.setCalendar(this._selected);
        this._changing = false;
        Point location = this.getLocationOnScreen();
        int x = this._popupLocation == 4 ? (int)location.getX() + this.getSize().width - this._calendarWindow.getSize().width : (this._popupLocation == 0 ? (int)location.getX() + (this.getSize().width - this._calendarWindow.getSize().width) / 2 : (int)location.getX());
        int y = (int)location.getY() + this._button.getHeight();
        Rectangle screenSize = this.getDesktopBounds();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x + this._calendarWindow.getWidth() > screenSize.width) {
            x = screenSize.width - this._calendarWindow.getWidth();
        }
        if (y + 30 + this._calendarWindow.getHeight() > screenSize.height) {
            y = (int)location.getY() - this._calendarWindow.getHeight();
        }
        this._calendarWindow.setBounds(x, y, this._calendarWindow.getWidth(), this._calendarWindow.getHeight());
        this._calendarWindow.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JCalendarComboBox.this._calendarPanel.requestFocus();
            }
        });
    }

    private Rectangle getDesktopBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        Rectangle[] screenDeviceBounds = new Rectangle[gd.length];
        Rectangle desktopBounds = new Rectangle();
        int i = 0;
        while (i < gd.length) {
            GraphicsConfiguration gc = gd[i].getDefaultConfiguration();
            screenDeviceBounds[i] = gc.getBounds();
            desktopBounds = desktopBounds.union(screenDeviceBounds[i]);
            ++i;
        }
        return desktopBounds;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this._changing) {
            return;
        }
        this.hideCalendar();
        this.setCalendar(this._calendarPanel.getCalendar());
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListener.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListener.remove(listener);
    }

    public ChangeListener[] getChangeListener() {
        return (ChangeListener[])this._changeListener.toArray();
    }

    protected void fireChangeEvent() {
        if (!this._fireingChangeEvent) {
            this._fireingChangeEvent = true;
            ChangeEvent event = new ChangeEvent(this);
            int i = 0;
            while (i < this._changeListener.size()) {
                this._changeListener.get(i).stateChanged(event);
                ++i;
            }
            this._fireingChangeEvent = false;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._spinner.setEnabled(enabled);
        this._button.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this._button.isEnabled();
    }

    public int getPopupLocation() {
        return this._popupLocation;
    }

    public void setPopupLocation(int location) {
        this._popupLocation = location;
    }

    public void setDateFormat(DateFormat format) {
        this._calendarPanel.setDateFormat(format);
        Color c = this._editor.getTextField().getForeground();
        this._editor = new JSpinner.DateEditor(this._spinner, ((SimpleDateFormat)this._calendarPanel.getDateFormat()).toPattern());
        this._spinner.setEditor(this._editor);
        this._editor.getTextField().setHorizontalAlignment(0);
        this._editor.getTextField().setForeground(c);
    }

    public DateFormat getDateFormat() {
        return this._calendarPanel.getDateFormat();
    }

    public void setSpiningCalendarField(int calendarField) {
        this._model.setCalendarField(calendarField);
    }

    public int getSpiningCalendarField() {
        return this._model.getCalendarField();
    }
}

