/*
 * Decompiled with CFR 0.152.
 */
package de.wannawork.jcalendar;

import de.wannawork.jcalendar.JCalendarComboBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class JCalendarCellEditor
implements TableCellEditor {
    private List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
    private Date originalValue;
    private JCalendarComboBox calendar;

    public JCalendarCellEditor(JCalendarComboBox cal) {
        this.calendar = cal;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value == null) {
            return this.calendar;
        }
        if (value instanceof Date) {
            this.calendar.setDate((Date)value);
        } else {
            Date d = new Date();
            this.calendar.setDate(d);
        }
        table.setRowSelectionInterval(row, row);
        table.setColumnSelectionInterval(column, column);
        this.originalValue = this.calendar.getDate();
        this.calendar.setSize(table.getColumnModel().getColumn(column).getWidth(), this.calendar.getHeight());
        return this.calendar;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.calendar.getDate();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    protected void fireEditingCanceled() {
        this.calendar.setDate(this.originalValue);
        this.calendar.getCalendar().setTime(this.originalValue);
        ChangeEvent event = new ChangeEvent(this);
        for (CellEditorListener l : this.listeners) {
            l.editingCanceled(event);
        }
    }

    protected void fireEditingStopped() {
        ChangeEvent event = new ChangeEvent(this);
        for (CellEditorListener l : this.listeners) {
            l.editingStopped(event);
        }
    }
}

