/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PageChangeListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class ThumbPanel
extends JPanel
implements Runnable,
Scrollable,
ImageObserver {
    PDFFile file;
    Image[] images;
    int border = 2;
    int lineheight = 96 + this.border;
    int defaultWidth = (this.lineheight - this.border) * 4 / 3;
    int[] xloc;
    Thread anim;
    int showing = -1;
    int needdrawn = -1;
    boolean defaultNotSet = true;
    PageChangeListener listener;

    public ThumbPanel(PDFFile file) {
        this.file = file;
        if (file != null) {
            int count = file.getNumPages();
            this.images = new Image[count];
            this.xloc = new int[count];
            this.setPreferredSize(new Dimension(this.defaultWidth, 200));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ThumbPanel.this.handleClick(evt.getX(), evt.getY());
                }
            });
            this.anim = new Thread(this);
            this.anim.setName(this.getClass().getName());
            this.anim.start();
        } else {
            this.images = new Image[0];
            this.setPreferredSize(new Dimension(this.defaultWidth, 200));
        }
    }

    @Override
    public void run() {
        int workingon = 0;
        while (this.anim == Thread.currentThread()) {
            if (this.needdrawn >= 0) {
                workingon = this.needdrawn;
                this.needdrawn = -1;
            }
            int loop = this.images.length;
            while (loop > 0) {
                if (this.images[workingon] == null) break;
                if (++workingon >= this.images.length) {
                    workingon = 0;
                }
                --loop;
            }
            if (loop == 0) break;
            try {
                Image i;
                int pagetoread = workingon + 1;
                PDFPage p = this.file.getPage(pagetoread, true);
                int wid = (int)Math.ceil((float)(this.lineheight - this.border) * p.getAspectRatio());
                int pagetowrite = workingon;
                this.images[pagetowrite] = i = p.getImage(wid, this.lineheight - this.border, null, this, true, true);
                if (this.defaultNotSet) {
                    this.defaultNotSet = false;
                    this.setDefaultWidth(wid);
                }
                this.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
                int size = this.lineheight - this.border;
                this.images[workingon] = new BufferedImage(size, size, 12);
            }
        }
    }

    public void addPageChangeListener(PageChangeListener pl) {
        this.listener = pl;
    }

    public void removePageChangeListener(PageChangeListener pl) {
        this.listener = null;
    }

    public void stop() {
        this.anim = null;
    }

    public void setDefaultWidth(int width) {
        this.defaultWidth = width;
    }

    public void handleClick(int x, int y) {
        int linecount = -1;
        int line = y / this.lineheight;
        int i = 0;
        while (i < this.xloc.length) {
            if (this.xloc[i] == 0) {
                ++linecount;
            }
            if (line == linecount && this.xloc[i] + (this.images[i] != null ? this.images[i].getWidth(null) : this.defaultWidth) > x) {
                this.showPage(i);
                break;
            }
            ++i;
        }
    }

    public void pageShown(int pagenum) {
        if (this.showing != pagenum) {
            if (pagenum >= 0 && this.getParent() instanceof JViewport) {
                int y = -this.lineheight;
                int i = 0;
                while (i <= pagenum) {
                    if (this.xloc[i] == 0) {
                        y += this.lineheight;
                    }
                    ++i;
                }
                Rectangle r = new Rectangle(this.xloc[pagenum], y, this.images[pagenum] == null ? this.defaultWidth : this.images[pagenum].getWidth(null), this.lineheight);
                this.scrollRectToVisible(r);
            }
            this.showing = pagenum;
            this.repaint();
        }
    }

    public void showPage(int pagenum) {
        this.pageShown(pagenum);
        SwingUtilities.invokeLater(new GotoLater(pagenum));
    }

    @Override
    public void paint(Graphics g) {
        int x = 0;
        int y = 0;
        int maxwidth = 0;
        Rectangle clip = g.getClipBounds();
        g.setColor(Color.gray);
        int width = this.getWidth();
        g.fillRect(0, 0, width, this.getHeight());
        int i = 0;
        while (i < this.images.length) {
            int w = this.defaultWidth + 2;
            if (this.images[i] != null) {
                w = this.images[i].getWidth(null) + 2;
            }
            if (x + w > width && x != 0) {
                x = 0;
                y += this.lineheight;
            }
            if (clip.intersects(new Rectangle(x, y, w, this.lineheight))) {
                if (this.images[i] != null) {
                    g.drawImage(this.images[i], x + 1, y + 1, this);
                } else {
                    if (this.needdrawn == -1) {
                        this.needdrawn = i;
                    }
                    g.setColor(Color.lightGray);
                    g.fillRect(x + 1, y + 1, w - this.border, this.lineheight - this.border);
                    g.setColor(Color.darkGray);
                    g.drawRect(x + 1, y + 1, w - this.border - 1, this.lineheight - this.border - 1);
                }
                if (i == this.showing) {
                    g.setColor(Color.red);
                    g.drawRect(x, y, w - 1, this.lineheight - 1);
                    g.drawRect(x + 1, y + 1, w - 3, this.lineheight - 3);
                }
            }
            this.xloc[i] = x;
            if ((x += w) > maxwidth) {
                maxwidth = x;
            }
            ++i;
        }
        if (maxwidth == 0) {
            maxwidth = this.defaultWidth;
        }
        Dimension d = this.getPreferredSize();
        if (d.height != y + this.lineheight || d.width != maxwidth) {
            this.setPreferredSize(new Dimension(maxwidth, y + this.lineheight));
            this.revalidate();
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return (infoflags & 0xE0) == 0;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visrect, int orientation, int direction) {
        return Math.max(this.lineheight, visrect.height / this.lineheight * this.lineheight);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visrect, int orientation, int direction) {
        return this.lineheight;
    }

    class GotoLater
    implements Runnable {
        int page;

        public GotoLater(int pagenum) {
            this.page = pagenum;
        }

        @Override
        public void run() {
            if (ThumbPanel.this.listener != null) {
                ThumbPanel.this.listener.gotoPage(this.page);
            }
        }
    }
}

