/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class PDFPrintPage
implements Printable {
    private PDFFile file;
    private String jobName;
    private PrinterJob pjob;
    private JDialog pd;
    private JLabel pagenumlabel;
    private JButton cancel;
    private boolean debug = false;

    public static void main(String[] args) {
        try {
            PDFPrintPage p = new PDFPrintPage(null);
            p.createPrintDialog();
            p.pd.pack();
            p.pd.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            p.pd.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PDFPrintPage(PDFFile file) {
        this(file, null);
    }

    public PDFPrintPage(PDFFile file, String jobName) {
        this.file = file;
        this.jobName = jobName;
    }

    public void printFile(String filename, boolean setupPaper) throws IOException {
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        PDFFile pdfFile = new PDFFile(bb);
        PDFPrintPage pages = new PDFPrintPage(pdfFile);
        PrinterJob pjob = PrinterJob.getPrinterJob();
        PageFormat pfDefault = PrinterJob.getPrinterJob().defaultPage();
        Paper defaultPaper = new Paper();
        defaultPaper.setImageableArea(0.0, 0.0, defaultPaper.getWidth(), defaultPaper.getHeight());
        pfDefault.setPaper(defaultPaper);
        if (setupPaper) {
            pfDefault = PrinterJob.getPrinterJob().pageDialog(pfDefault);
        }
        pjob.setJobName(file.getName());
        if (pjob.printDialog()) {
            pfDefault = pjob.validatePage(pfDefault);
            Book book = new Book();
            book.append(pages, pfDefault, pdfFile.getNumPages());
            pjob.setPageable(book);
            try {
                pjob.print();
            }
            catch (PrinterException exc) {
                System.out.println(exc);
            }
        }
    }

    private void createPrintDialog() {
        this.pd = new JDialog(null, "Printing...", false);
        Container top = this.pd.getContentPane();
        Box lines = Box.createVerticalBox();
        lines.add(Box.createVerticalStrut(11));
        Box line = Box.createHorizontalBox();
        line.add(Box.createHorizontalStrut(11));
        lines.add(Box.createVerticalGlue());
        line.add(new JLabel("Now printing: " + (this.jobName != null ? this.jobName : "PDF Document")));
        line.add(Box.createHorizontalStrut(11));
        lines.add(line);
        line = Box.createHorizontalBox();
        line.add(Box.createHorizontalStrut(11));
        line.add(new JLabel("page "));
        this.pagenumlabel = new JLabel("1");
        line.add(this.pagenumlabel);
        line.add(new JLabel(" of "));
        JLabel totalpages = new JLabel(this.file != null ? String.valueOf(this.file.getNumPages()) : "N/A");
        line.add(totalpages);
        line.add(Box.createHorizontalStrut(11));
        lines.add(line);
        lines.add(Box.createVerticalGlue());
        lines.add(Box.createVerticalStrut(11));
        line = Box.createHorizontalBox();
        line.add(Box.createHorizontalStrut(11));
        this.cancel = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFPrintPage.this.doCancel();
            }
        });
        line.add(this.cancel);
        line.add(Box.createHorizontalStrut(11));
        lines.add(line);
        lines.add(Box.createVerticalStrut(11));
        top.add(lines);
    }

    public void show(PrinterJob pjob) {
        this.show(pjob, null);
    }

    public void show(PrinterJob pjob, Component c) {
        this.pjob = pjob;
        if (this.pd == null) {
            this.createPrintDialog();
        }
        this.pd.pack();
        this.pd.setLocationRelativeTo(c);
        this.pd.setVisible(true);
    }

    public void hide() {
        this.pd.dispose();
    }

    public void doCancel() {
        this.cancel.setEnabled(false);
        this.pjob.cancel();
    }

    @Override
    public int print(Graphics g, PageFormat format, int index) throws PrinterException {
        int pagenum = index + 1;
        if (pagenum >= 1 && pagenum <= this.file.getNumPages()) {
            int width;
            int height;
            if (this.pagenumlabel != null) {
                this.pagenumlabel.setText(String.valueOf(pagenum));
            }
            if (this.debug) {
                System.out.println("PDFview pnum " + pagenum);
                System.out.println("PDFview format o:" + format.getOrientation() + " w:" + format.getWidth() + " h:" + format.getHeight() + " ix:" + format.getImageableX() + " iy:" + format.getImageableY() + " iw:" + format.getImageableWidth() + " ih:" + format.getImageableHeight());
            }
            Graphics2D g2 = (Graphics2D)g;
            PDFPage page = this.file.getPage(pagenum);
            double pwidth = format.getImageableWidth();
            double pheight = format.getImageableHeight();
            double aspect = page.getAspectRatio();
            double paperaspect = pwidth / pheight;
            if (this.debug) {
                System.out.println("PDFview pa:" + aspect + " ia:" + paperaspect);
            }
            if (aspect > paperaspect) {
                height = (int)(pwidth / aspect);
                width = (int)pwidth;
            } else {
                width = (int)(pheight * aspect);
                height = (int)pheight;
            }
            if (this.debug) {
                System.out.println("PDFview iw:" + pwidth + " ih:" + pheight + " aw:" + width + " ah:" + height);
            }
            Rectangle imgbounds = new Rectangle((int)format.getImageableX(), (int)format.getImageableY(), width, height);
            if (this.debug) {
                System.out.println("PDFview page po:" + page.getRotation() + " pw:" + page.getWidth() + " ph:" + page.getHeight() + " pbox:" + page.getBBox());
                System.out.println("PDFview g " + g2.getClipBounds());
                System.out.println("PDFview img " + imgbounds);
            }
            PDFRenderer pgs = new PDFRenderer(page, g2, imgbounds, null, null);
            try {
                page.waitForFinish();
                pgs.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return 0;
        }
        return 1;
    }
}

