#------------------------------------------------------------------------------
#    59bbs, blog like bulletin board system.
#    Copyright (C) 2007-2010 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::Logger;

use strict;
use warnings;

use constant {
    LOCK_SH => 1,
    LOCK_EX => 2,
    LOCK_NB => 4,
    LOCK_UN => 8,
};

# コンストラクタ
sub new {
    my $self = {};

    use Lib::Conf;
    my $conf = Lib::Conf->new();

    $self->{system_dir} = $conf->get_system_dir();

    bless($self);
    return $self;
}

# ログを書き込む 第一引数に書き込む文字列が設定されている
sub write {
    my $self = shift;
    my $logstr = shift;

    # 日時を取得
    my ($lsec, $lmin,$lhour,$lday,$lmon,$lyear) = localtime(time);
    $lyear += 1900;
    $lmon++;
    my $writedate = "$lyear/$lmon/$lday $lhour:$lmin:$lsec";

    # ログを書き込む（常に追記）
    my $logfile = "$self->{system_dir}/59bbs.log";

    open my $logfh, '>>', $logfile;
    flock $logfh, LOCK_EX;
    print {$logfh} "$writedate,$logstr\n";
    flock $logfh, LOCK_UN;
    close $logfh;

    # ファイルのパーミッションを変更
    chmod 0766, $logfile;
}

1;
# End of Lib::Logger.pm
