#!/usr/bin/perl
#------------------------------------------------------------------------------
#    59bbs, blog like bulletin board system.
#    Copyright (C) 2007-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

use strict;
use warnings;

use Lib::Logger;
use Lib::Error;
use Lib::User;
use Lib::App::Ads;
use Lib::App::Conf;

my $logger = Lib::Logger->new();
my $error = Lib::Error->new();
my $user = Lib::User->new();
my $ads = Lib::App::Ads->new();
my $conf = Lib::App::Conf->new();

sub act() {
    my ($act, $cgi) = @_;

    my $sessionid = $cgi->cookie('cookie59b');
    if ($sessionid eq '') {
        $error->print_error('00003e');
    }
    my $session_userid = $user->check_session($sessionid);
    if ($session_userid eq '') {
        $error->print_error('00003e');
    }

    if (!$user->is_admin($session_userid)) {
        $error->print_error('00004e');
    }

    if ($act eq 'edit_ads') {
        _edit_ads();
    }
    elsif ($act eq 'update_ads') {
        _update_ads($cgi);
    }
    else {
        $error->print_error('00002e');
    }
}

# 広告コード、お知らせの編集
sub _edit_ads() {

    my $adsdata;
    $adsdata->{ad1} = $ads->get_ad1();
    $adsdata->{ad2} = $ads->get_ad2();
    $adsdata->{ad3} = $ads->get_ad3();
    $adsdata->{adlist} = $ads->get_adlist();

    # 編集画面表示
    _show_page($adsdata);
}

# 広告コード、お知らせの更新
sub _update_ads() {
    my ($cgi) = @_;

    my $ad1 = $cgi->param('ad1');
    my $ad2 = $cgi->param('ad2');
    my $ad3 = $cgi->param('ad3');
    my $adlist = $cgi->param('adlist');

    $ads->set_ad1($ad1);
    $ads->set_ad2($ad2);
    $ads->set_ad3($ad3);
    $ads->set_adlist($adlist);
    $ads->update();

    print "Location: ./", "\n\n";
}

# 広告設定画面の表示
sub _show_page() {
    my ($adsdata) = @_;

    my $caption = '広告設定';

    my $path = <<"END_PATH";
<p><strong>
<a href="./" class="path">ホーム</a>&nbsp;
&gt;&nbsp;
$caption
</strong></p>
END_PATH

    my $systemdir = $conf->get_system_dir();

    open my $templatefh, '<', "$systemdir/tmpl/ads.tmpl";
    my $template = do { local $/; <$templatefh> };
    close $templatefh;

    $template =~ s/\$CAPTION\$/$caption/g;
    $template =~ s/\$PATH\$/$path/g;
    $template =~ s/\$AD1\$/$adsdata->{ad1}/g;
    $template =~ s/\$AD2\$/$adsdata->{ad2}/g;
    $template =~ s/\$AD3\$/$adsdata->{ad3}/g;
    $template =~ s/\$ADLIST\$/$adsdata->{adlist}/g;

    print "Content-Type: text/html\n\n";
    print $template;

    exit;
}

1;
