#------------------------------------------------------------------------------
#    59bbs, blog like bulletin board system.
#    Copyright (C) 2007-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::Ping;

use strict;
use warnings;

use constant {
    LOCK_SH => 1,
    LOCK_EX => 2,
    LOCK_NB => 4,
    LOCK_UN => 8,
};

use XMLRPC::Lite;
use HTTP::Request::Common;
use LWP::UserAgent;

use Lib::Logger;

my $logger = Lib::Logger->new();

my @pinglist = ();

# コンストラクタ
sub new {
    my $self = {};

    use Lib::App::Conf;
    my $conf = Lib::App::Conf->new();

    $self->{system_dir} = $conf->get_system_dir(); # システムディレクトリ

    bless($self);
    return $self;
}

# ping送信先リストの取得
sub get_pinglist {
    my $self = shift;
    return @pinglist;
}

# ping送信先リストの取得
sub set_pinglist {
    my $self = shift;
    @pinglist = @_;
}

# ping送信先リストの読み込み
sub load {
    my $self = shift;

    my $pingfile = "$self->{system_dir}/pinglist.txt";
    if (-f $pingfile) {
        open my $pingfh, '<', $pingfile;
        while (my $data = <$pingfh>) {
            chomp($data);
            if ($data ne '') {
                push @pinglist, $data;
            }
        }
        close $pingfh;
    }
}

# ping送信先リストの更新
sub update {
    my $self = shift;

    my $pingfile = "$self->{system_dir}/pinglist.txt";
    open my $pingfh, '>', $pingfile;
    flock $pingfh, LOCK_EX;
    foreach my $data (@pinglist) {
        print {$pingfh} "$data\n";
    }
    flock $pingfh, LOCK_UN;
    close $pingfh;

    chmod 0766, $pingfile;
}

# weblogUpdates Pingの送信
sub weblogupdates {
    my $self = shift;
    my ($blogurl, $blogname) = @_;

    my $pingfile = "$self->{system_dir}/pinglist.txt";
    if (-f $pingfile) {
        open my $pingfh, '<', $pingfile;
        while (my $pingurl = <$pingfh>) {
            chomp($pingurl); # 改行を取り除く
            if ($pingurl ne '') {
                my $result = eval { 
                    XMLRPC::Lite->proxy($pingurl)->
                    call('weblogUpdates.ping', $blogname, $blogurl, )->result; };
                for my $key (keys %$result) {
                    my $logline = "$pingurl $key:$result->{$key}";
                    $logger->write($logline);
                }
            }
        }
        close $pingfh;
    }
}

# トラックバックPingの送信
sub trackback {
    my $self = shift;
    my ($pingdata, @urllist) = @_;

    my $ua = LWP::UserAgent->new();
    $ua->agent("pingtb/1.0");

    foreach my $trackbackurl (@urllist) {
#        $logger->write($trackbackurl);  # for debug
        my $req = POST $trackbackurl,
                 [title     => $pingdata->{title},
                  url       => $pingdata->{url},
                  blog_name => $pingdata->{blog_name},
                  excerpt   => $pingdata->{excerpt},
                  charset   => 'UTF-8', ];
        my $response = $ua->request($req);
        if (!$response->is_success) {
            $logger->write("$trackbackurl:トラックバックPingの送信が失敗しました");
        }
    }
}

1;
# End of Ping.pm
