/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.kintai.common.action.MosPCodeAction;
import jp.mosp.system.vo.YukyuInformationCardVo;

/**
 * @author yoshida
 *
 */
public class YukyuInformationCardAction extends MosPCodeAction {
	
	// R}h
	private static final String	CMD_YUKYU_INFO_SHOW		= "S2700";	//\
	private static final String	CMD_YUKYU_INFO_UPDATE	= "S2708";	//XV
																	
	
	/**
	 * RXgN^
	 */
	public YukyuInformationCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_YUKYU_INFO_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_YUKYU_INFO_UPDATE)) {
			// JzXVAXV
			regist();
			// \
			show();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new YukyuInformationCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// VXemF
		confirmSystemAuth();
		YukyuInformationCardVo vo = (YukyuInformationCardVo)getVo();
		// v_EXg쐬
		vo.aryPltCFMonth = StringUtil.getMonthArray();
		// Jz敪
		vo.aryPltCFKbn = new String[][]{ { CommonConst.NAM_COMMON_FLAG_OFF, CommonConst.NAM_CARRY_OVER_THIS_YEAR },
			{ CommonConst.NAM_COMMON_FLAG_ON, CommonConst.NAM_CARRY_OVER_TOTAL } };
		// x@
		vo.aryPltSupplyModel = new String[][]{ { CommonConst.NAM_COMMON_FLAG_OFF, CommonConst.NAM_STANDARD_MONTH },
			{ CommonConst.NAM_COMMON_FLAG_ON, CommonConst.NAM_EMPLOY_MONTH } };
	}
	
	@Override
	protected void show() throws Exception {
		YukyuInformationCardVo vo = (YukyuInformationCardVo)getVo();
		// LJz 
		String[] aryPaidHolidayInfo = getPaidHolidayInfo();
		// Jz
		vo.setPltCFMonth(aryPaidHolidayInfo[0]);
		// Jz
		vo.setTxtCFDays(aryPaidHolidayInfo[1]);
		// Jz敪
		vo.setPltCFKbn(aryPaidHolidayInfo[2]);
		// x@
		vo.setPltSupplyModel(findTchange(CommonConst.TID_PAID_HOLIDAY, CommonConst.TCD_SUPPLY_MODEL));
		// LxɎx	
		vo.setDefaultValues();
		vo.setFields(part().mospcode().getPaidHolidayList());
	}
	
	/**
	 * f[^XViJzځj
	 * @throws Exception 	Oꍇ
	 */
	private void regist() throws Exception {
		YukyuInformationCardVo vo = (YukyuInformationCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// Jz
		regist(CommonConst.TID_PAID_HOLIDAY, CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_MONTH, "", vo
			.getPltCFMonth());
		// Jz
		regist(CommonConst.TID_PAID_HOLIDAY, CommonConst.TCD_CARRIED_FORWARD_DAYS, "", vo.getTxtCFDays());
		// Jz敪
		regist(CommonConst.TID_PAID_HOLIDAY, CommonConst.TCD_CARRIED_FORWARD_TYPE, CommonConst.TNM_CARRY_OVER, vo
			.getPltCFKbn());
		// x@
		regist(CommonConst.TID_PAID_HOLIDAY, CommonConst.TCD_SUPPLY_MODEL, "", vo.getPltSupplyModel());
		// f[^XV(x)
		// e[ubN
//		part().mospcode().getMCodeDao().tableLock(CommonConst.TID_PAID_HOLIDAY_SUPPLY);
		// 폜
		part().mospcode().getMCodeDao().delete(CommonConst.TID_PAID_HOLIDAY_SUPPLY);
		String[] aryStandard = vo.getAryTxtStandard();
		String[] aryInfo = vo.getAryTxtInfo();
		String[] aryDays = vo.getAryTxtDays();
		for (int i = 0; i < aryStandard.length; i++) {
			if (StringUtil.isNotNull(aryStandard[i])) {
				// XV
				regist(CommonConst.TID_PAID_HOLIDAY_SUPPLY, StringUtil.addZero(aryStandard[i]), aryInfo[i], aryDays[i]);
			}
		}
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
	}
	
}
