/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.cloudzero.mosp.exception.CloudzeroUnsupportedException;
import jp.getset.gae.bigtable.Statement.Mode;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.dto.MKintaiDto;

/**
 * M_KINTAI(ΑӏWv)DAONX B
 */
public class MKintaiDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * M_KINTAI(ΑӏWv)B
	 */
	public static final String	TABLE				= "M_KINTAI";
	
	/**
	 * KEY_1 = KCODE(ЈR[h)B
	 */
	public static final String	KEY_1				= "KCODE";
	/**
	 * KEY_2 = SIKYUYM(xN)B
	 */
	public static final String	KEY_2				= "SIKYUYM";
	
	// 
	/**
	 * KCODE(ЈR[h)B
	 */
	public static final String	COL_KCODE			= "KCODE";
	/**
	 * SIKYUYM(xN)B
	 */
	public static final String	COL_SIKYUYM			= "SIKYUYM";
	/**
	 * SNEN(xN)B
	 */
	public static final String	COL_SNEN			= "SNEN";
	/**
	 * STUKI(x)B
	 */
	public static final String	COL_STUKI			= "STUKI";
	/**
	 * SHI(x)B
	 */
	public static final String	COL_SHI				= "SHI";
	/**
	 * SNISSU(oΓ)B
	 */
	public static final String	COL_SNISSU			= "SNISSU";
	/**
	 * SKAISU(oΉ)B
	 */
	public static final String	COL_SKAISU			= "SKAISU";
	/**
	 * KINMUJI(Ζ)B
	 */
	public static final String	COL_KINMUJI			= "KINMUJI";
	/**
	 * KYUKEIJI(xe)B
	 */
	public static final String	COL_KYUKEIJI		= "KYUKEIJI";
	/**
	 * YUKYU(L)B
	 */
	public static final String	COL_YUKYU			= "YUKYU";
	/**
	 * TOKUKYU(ʋx)B
	 */
	public static final String	COL_TOKUKYU			= "TOKUKYU";
	/**
	 * KEKKIN(ʌΓ)B
	 */
	public static final String	COL_KEKKIN			= "KEKKIN";
	/**
	 * SKEKKIN(aΓ)B
	 */
	public static final String	COL_SKEKKIN			= "SKEKKIN";
	/**
	 * DAIKYU(֋x)B
	 */
	public static final String	COL_DAIKYU			= "DAIKYU";
	/**
	 * FURIKAE(U֋x)B
	 */
	public static final String	COL_FURIKAE			= "FURIKAE";
	/**
	 * SONOTA(̑x)B
	 */
	public static final String	COL_SONOTA			= "SONOTA";
	/**
	 * TISOKAI(xމ)B
	 */
	public static final String	COL_TISOKAI			= "TISOKAI";
	/**
	 * TIJIKAN(xގ)B
	 */
	public static final String	COL_TIJIKAN			= "TIJIKAN";
	/**
	 * ZAJIKAN(ʎcƎ)B
	 */
	public static final String	COL_ZAJIKAN			= "ZAJIKAN";
	/**
	 * KSJIKAN(xoΎ)B
	 */
	public static final String	COL_KSJIKAN			= "KSJIKAN";
	/**
	 * SNJIKAN([Ζ)B
	 */
	public static final String	COL_SNJIKAN			= "SNJIKAN";
	/**
	 * KAIKIN(FΎ蓖x)B
	 */
	public static final String	COL_KAIKIN			= "KAIKIN";
	/**
	 * SYOKUJIKAISU(H蓖x)B
	 */
	public static final String	COL_SYOKUJIKAISU	= "SYOKUJIKAISU";
	/**
	 * CYOKUKAISU1(1蓖x)B
	 */
	public static final String	COL_CYOKUKAISU1		= "CYOKUKAISU1";
	/**
	 * CYOKUKAISU2(2蓖x)B
	 */
	public static final String	COL_CYOKUKAISU2		= "CYOKUKAISU2";
	/**
	 * CYOKUKAISU3(3蓖x)B
	 */
	public static final String	COL_CYOKUKAISU3		= "CYOKUKAISU3";
	/**
	 * HOKAKAISU1(̑x1)B
	 */
	public static final String	COL_HOKAKAISU1		= "HOKAKAISU1";
	/**
	 * HOKAKAISU2(̑x2)B
	 */
	public static final String	COL_HOKAKAISU2		= "HOKAKAISU2";
	/**
	 * HOKAKAISU3(̑x3)B
	 */
	public static final String	COL_HOKAKAISU3		= "HOKAKAISU3";
	/**
	 * HOKAKAISU4(̑x4)B
	 */
	public static final String	COL_HOKAKAISU4		= "HOKAKAISU4";
	/**
	 * HOKAKAISU5(̑x5)B
	 */
	public static final String	COL_HOKAKAISU5		= "HOKAKAISU5";
	/**
	 * SINSEIGAKU(x\z)B
	 */
	public static final String	COL_SINSEIGAKU		= "SINSEIGAKU";
	/**
	 * NIJIKYU(񎞊ԔNx)B
	 */
	public static final String	COL_NIJIKYU			= "NIJIKYU";
	/**
	 * WARIMASI1(1.00)B
	 */
	public static final String	COL_WARIMASI1		= "WARIMASI1";
	

	/**
	 * RXgN^
	 */
	public MKintaiDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<MKintaiDto> mappingAll() throws SQLException {
		List<MKintaiDto> all = new ArrayList<MKintaiDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return m_kintaiDto m_kintaiR[h
	 * @throws SQLException SQLOꍇ
	 */
	private MKintaiDto mapping() throws SQLException {
		MKintaiDto dto = new MKintaiDto();
		dto.setKCode(rs.getString(COL_KCODE));
		dto.setSikyuYM(rs.getString(COL_SIKYUYM));
		dto.setSNen(rs.getInt(COL_SNEN));
		dto.setSTuki(rs.getInt(COL_STUKI));
		dto.setSHi(rs.getInt(COL_SHI));
		dto.setSNissu(rs.getDouble(COL_SNISSU));
		dto.setSKaisu(rs.getInt(COL_SKAISU));
		dto.setKinmuJi(rs.getInt(COL_KINMUJI));
		dto.setKyukeiJi(rs.getInt(COL_KYUKEIJI));
		dto.setYukyu(rs.getDouble(COL_YUKYU));
		dto.setTokuKyu(rs.getDouble(COL_TOKUKYU));
		dto.setKekkin(rs.getDouble(COL_KEKKIN));
		dto.setSKekkin(rs.getDouble(COL_SKEKKIN));
		dto.setDaiKyu(rs.getDouble(COL_DAIKYU));
		dto.setFurikae(rs.getDouble(COL_FURIKAE));
		dto.setSonota(rs.getInt(COL_SONOTA));
		dto.setTiSoKai(rs.getInt(COL_TISOKAI));
		dto.setTiJikan(rs.getInt(COL_TIJIKAN));
		dto.setZaJikan(rs.getInt(COL_ZAJIKAN));
		dto.setKsJikan(rs.getInt(COL_KSJIKAN));
		dto.setSnJikan(rs.getInt(COL_SNJIKAN));
		dto.setKaikin(rs.getInt(COL_KAIKIN));
		dto.setSyokujiKaisu(rs.getInt(COL_SYOKUJIKAISU));
		dto.setCyokuKaisu1(rs.getInt(COL_CYOKUKAISU1));
		dto.setCyokuKaisu2(rs.getInt(COL_CYOKUKAISU2));
		dto.setCyokuKaisu3(rs.getInt(COL_CYOKUKAISU3));
		dto.setHokaKaisu1(rs.getInt(COL_HOKAKAISU1));
		dto.setHokaKaisu2(rs.getInt(COL_HOKAKAISU2));
		dto.setHokaKaisu3(rs.getInt(COL_HOKAKAISU3));
		dto.setHokaKaisu4(rs.getInt(COL_HOKAKAISU4));
		dto.setHokaKaisu5(rs.getInt(COL_HOKAKAISU5));
		dto.setSinseiGaku(rs.getInt(COL_SINSEIGAKU));
		dto.setNijiKyu(rs.getInt(COL_NIJIKYU));
		dto.setWarimasi1(rs.getInt(COL_WARIMASI1));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MKintaiDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<MKintaiDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kcode ЈR[h(L[)
	 * @param sikyuym xN(L[)
	 * @return dto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKintaiDto findForKey(String kcode, String sikyuym) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, sikyuym);
			executeQuery();
			MKintaiDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @param sikyuym xN(L[)
	 * @return dto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKintaiDto findForUpdate(String kcode, String sikyuym) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kcode);
			setParam(index++, sikyuym);
			executeQuery();
			MKintaiDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param sikyuym xN(L[)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public void findForUpdate(String sikyuym) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_SIKYUYM);
			sb.append(" = ? ");
			this.pob.appendWhere(COL_SIKYUYM, Query.FilterOperator.EQUAL);
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getForUpdate());
			setParam(index++, sikyuym);
			executeQuery();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param sikyuym xN
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findForCondition(String kcode, String sikyuym) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_SIKYUYM);
		sb.append(" LIKE ? ");
		this.pob.appendLike(COL_KCODE);
		this.pob.appendLike(COL_SIKYUYM);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, sikyuym + "%");
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(͈͎w)
	 * @param kcode ЈR[h
	 * @param startSikyuNen JnN
	 * @param startSikyuTuki IN
	 * @param endSikyuNen Jn
	 * @param endSikyuTuki I
	 * @param dif N
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MKintaiDto> findForCondition(String kcode, int startSikyuNen, int startSikyuTuki, int endSikyuNen,
			int endSikyuTuki, int dif) throws SQLException, IllegalAccessException, NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? AND ");
		if (dif != 0) {
			sb.append("((");
			sb.append(COL_SNEN);
			sb.append(" = ? AND ");
			sb.append(COL_STUKI);
			sb.append(" BETWEEN");
			sb.append(" ? AND ? )");
			sb.append(" OR ");
		}
		for (int i = 1; dif > i; i++) {
			sb.append(COL_SNEN);
			sb.append(" = ?");
			sb.append(" OR ");
		}
		sb.append("(");
		sb.append(COL_SNEN);
		sb.append(" = ? AND ");
		sb.append(COL_STUKI);
		sb.append(" BETWEEN");
		sb.append(" ? AND ? )");
		if (dif != 0) {
			sb.append(")");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode);
			if (dif != 0) {
				setParam(index++, startSikyuNen);
				setParam(index++, startSikyuTuki);
				setParam(index++, 12);
			}
			for (int i = 1; dif > i; i++) {
				setParam(index++, startSikyuNen + i);
			}
			setParam(index++, endSikyuNen);
			if (dif == 0) {
				setParam(index++, startSikyuTuki);
			} else {
				setParam(index++, 1);
			}
			setParam(index++, endSikyuTuki);
			executeQuery();
			List<MKintaiDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * ɂf[^擾
	 * @param sikyuym xN
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MKintaiDto> findForExport(String sikyuym) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_SIKYUYM);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_SIKYUYM, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, sikyuym);
			executeQuery();
			List<MKintaiDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(MKintaiDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * @param list		Αӏ
	 * @param divSize	
	 * @return	}()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(List<MKintaiDto> list, int divSize) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			int listSize = list.size();
			int rev = listSize / divSize + 1;
			if (listSize % divSize == 0) {
				rev--;
			}
			int insertCount = 0;
			List<MKintaiDto> divList = new ArrayList<MKintaiDto>();
			for (int i = 0; i < rev; i++) {
				// XgdivƕB
				for (int k = 0; k < divSize; k++) {
					int count = k + (i * divSize);
					if (count >= listSize) {
						break;
					}
					divList.add(list.get(count));
				}
				int divListSize = divList.size();
				prepareStatement(getInsertQuery(getClass(), divListSize, divSize));
				for (MKintaiDto dto : divList) {
					setParams(dto, true);
				}
				executeUpdate();
				clearParams();
				index = 1;
				divList.clear();
				chkInsert(divListSize);
				insertCount += cnt;
			}
			return insertCount;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param 	aryDto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(MKintaiDto[] aryDto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass(), aryDto.length, aryDto.length));
			for (MKintaiDto dto : aryDto) {
				setParams(dto, true);
			}
			executeUpdate();
			chkInsert(aryDto.length);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(MKintaiDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getSikyuYM());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(MKintaiDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getSikyuYM());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param aryDto XVΏDTO
	 * @param sikyuym 	XVΏ۔N
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(MKintaiDto[] aryDto, String sikyuym) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		throw new CloudzeroUnsupportedException();
/*		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" WHERE (");
			int i = 0;
			while (i != aryDto.length) {
				sb.append(COL_KCODE);
				sb.append(" = ? OR ");
				i++;
			}
			sb.delete(sb.length() - 4, sb.length());
			sb.append(") AND ");
			sb.append(COL_SIKYUYM);
			sb.append(" = ?");
			prepareStatement(sb.toString());
			for (MKintaiDto dto : aryDto) {
				setParam(index++, dto.getKCode());
			}
			setParam(index++, sikyuym);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * f[^폜
	 * @param 	sikyuym	XVΏ۔N
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(String sikyuym) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" ");
			sb.append("WHERE ");
			sb.append(COL_SIKYUYM);
			sb.append(" = ? ");
			
			this.setPreparedStatement(Mode.DELETE, TABLE);
			this.pob.appendWhere(COL_SIKYUYM, Query.FilterOperator.EQUAL);
			
			prepareStatement(sb.toString());
			setParam(index++, sikyuym);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert  }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(MKintaiDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode());
		setParam(index++, dto.getSikyuYM());
		setParam(index++, dto.getSNen());
		setParam(index++, dto.getSTuki());
		setParam(index++, dto.getSHi());
		setParam(index++, dto.getSNissu());
		setParam(index++, dto.getSKaisu());
		setParam(index++, dto.getKinmuJi());
		setParam(index++, dto.getKyukeiJi());
		setParam(index++, dto.getYukyu());
		setParam(index++, dto.getTokuKyu());
		setParam(index++, dto.getKekkin());
		setParam(index++, dto.getSKekkin());
		setParam(index++, dto.getDaiKyu());
		setParam(index++, dto.getFurikae());
		setParam(index++, dto.getSonota());
		setParam(index++, dto.getTiSoKai());
		setParam(index++, dto.getTiJikan());
		setParam(index++, dto.getZaJikan());
		setParam(index++, dto.getKsJikan());
		setParam(index++, dto.getSnJikan());
		setParam(index++, dto.getKaikin());
		setParam(index++, dto.getSyokujiKaisu());
		setParam(index++, dto.getCyokuKaisu1());
		setParam(index++, dto.getCyokuKaisu2());
		setParam(index++, dto.getCyokuKaisu3());
		setParam(index++, dto.getHokaKaisu1());
		setParam(index++, dto.getHokaKaisu2());
		setParam(index++, dto.getHokaKaisu3());
		setParam(index++, dto.getHokaKaisu4());
		setParam(index++, dto.getHokaKaisu5());
		setParam(index++, dto.getSinseiGaku());
		setParam(index++, dto.getNijiKyu());
		setParam(index++, dto.getWarimasi1());
		setCommonParams(isInsert);
	}
	
	/**
	 * e[ubN
	 * @param 	sikyuYM	XVΏ۔N
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public void tableLock(String sikyuYM) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				findForUpdate(sikyuYM);
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * e[ubN
	 * @param	kCode	ЈR[h
	 * @param 	sikyuYM	XVΏ۔N
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public void tableLock(String kCode, String sikyuYM) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				findForUpdate(kCode, sikyuYM);
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * e[ubN
	 * @param	listMKintai	DTO
	 * @param 	sikyuYM		XVΏ۔N
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public void tableLock(List<MKintaiDto> listMKintai, String sikyuYM) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				for (MKintaiDto mKintaiDto : listMKintai) {
					MKintaiDto dto = mKintaiDto;
					findForUpdate(dto.getKCode(), sikyuYM);
				}
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
}
