/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.appengine.api.datastore.Query;

import jp.cloudzero.mosp.exception.CloudzeroUnsupportedException;
import jp.getset.gae.bigtable.Statement.Mode;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CmResidenceTaxDto;

/**
 * @author koike
 *
 */
public class CmResidenceTaxDao extends PayrollDao {
	
	// e[uyуL[
	
	/**
	 * l}X^Zŕe[u
	 */
	public static final String	TABLE					= "CM_RESIDENCE_TAX";
	
	/**
	 * ЈR[h
	 */
	public static final String	KEY_1					= "K_CODE";
	
	/**
	 * ZœKpN
	 */
	public static final String	KEY_2					= "RES_EXPECTED_DATE";
	
	/**
	 * ЈR[h
	 */
	public static final String	COL_K_CODE				= "K_CODE";
	
	/**
	 * ZœKpN
	 */
	public static final String	COL_RES_EXPECTED_DATE	= "RES_EXPECTED_DATE";
	
	/**
	 * [tsR[h
	 */
	public static final String	COL_PAYMENT_CITY_CODE	= "PAYMENT_CITY_CODE";
	
	/**
	 * osR[h
	 */
	public static final String	COL_SUBMIT_CITY_CODE	= "SUBMIT_CITY_CODE";
	
	/**
	 * 6
	 */
	public static final String	COL_JUNE_AMOUNT			= "JUNE_AMOUNT";
	
	/**
	 * 7
	 */
	public static final String	COL_JULY_AMOUNT			= "JULY_AMOUNT";
	
	/**
	 * 8
	 */
	public static final String	COL_AUGUST_AMOUNT		= "AUGUST_AMOUNT";
	
	/**
	 * 9
	 */
	public static final String	COL_SEPTEMBER_AMOUNT	= "SEPTEMBER_AMOUNT";
	
	/**
	 * 10
	 */
	public static final String	COL_OCTOBER_AMOUNT		= "OCTOBER_AMOUNT";
	
	/**
	 * 11
	 */
	public static final String	COL_NOVEMBER_AMOUNT		= "NOVEMBER_AMOUNT";
	
	/**
	 * 12
	 */
	public static final String	COL_DECEMBER_AMOUNT		= "DECEMBER_AMOUNT";
	
	/**
	 * 1
	 */
	public static final String	COL_JANUARY_AMOUNT		= "JANUARY_AMOUNT";
	
	/**
	 * 2
	 */
	public static final String	COL_FEBRUARY_AMOUNT		= "FEBRUARY_AMOUNT";
	
	/**
	 * 3
	 */
	public static final String	COL_MARCH_AMOUNT		= "MARCH_AMOUNT";
	
	/**
	 * 4
	 */
	public static final String	COL_APRIL_AMOUNT		= "APRIL_AMOUNT";
	
	/**
	 * 5
	 */
	public static final String	COL_MAY_AMOUNT			= "MAY_AMOUNT";
	

	/**
	 * RXgN^
	 */
	public CmResidenceTaxDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<CmResidenceTaxDto> mappingAll() throws SQLException {
		List<CmResidenceTaxDto> all = new ArrayList<CmResidenceTaxDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return CmResidenceTaxDto R[h
	 * @throws SQLException SQLOꍇ
	 */
	private CmResidenceTaxDto mapping() throws SQLException {
		CmResidenceTaxDto dto = new CmResidenceTaxDto();
		dto.setKCode(rs.getString(COL_K_CODE)); // ЈR[h
		dto.setResExpectedDate(rs.getDate(COL_RES_EXPECTED_DATE)); // ZœKpN
		dto.setPaymentCityCode(rs.getString(COL_PAYMENT_CITY_CODE)); // [tsR[h
		dto.setSubmitCityCode(rs.getString(COL_SUBMIT_CITY_CODE)); // osR[h
		dto.setJuneAmount(rs.getInt(COL_JUNE_AMOUNT)); // 6
		dto.setJulyAmount(rs.getInt(COL_JULY_AMOUNT)); // 7
		dto.setAugustAmount(rs.getInt(COL_AUGUST_AMOUNT)); // 8
		dto.setSeptemberAmount(rs.getInt(COL_SEPTEMBER_AMOUNT)); // 9
		dto.setOctoberAmount(rs.getInt(COL_OCTOBER_AMOUNT)); // 10
		dto.setNovemberAmount(rs.getInt(COL_NOVEMBER_AMOUNT)); // 11
		dto.setDecemberAmount(rs.getInt(COL_DECEMBER_AMOUNT)); // 12
		dto.setJanuaryAmount(rs.getInt(COL_JANUARY_AMOUNT)); // 1
		dto.setFebruaryAmount(rs.getInt(COL_FEBRUARY_AMOUNT)); // 2
		dto.setMarchAmount(rs.getInt(COL_MARCH_AMOUNT)); // 3
		dto.setAprilAmount(rs.getInt(COL_APRIL_AMOUNT)); // 4
		dto.setMayAmount(rs.getInt(COL_MAY_AMOUNT)); // 5
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ʎ擾(DTOMap)
	 * @return Map }bv
	 * @throws SQLException SQLOꍇ
	 */
	private Map<String, CmResidenceTaxDto> mappingAllMap() throws SQLException {
		Map<String, CmResidenceTaxDto> all = new HashMap<String, CmResidenceTaxDto>();
		while (rs.next()) {
			CmResidenceTaxDto dto = mapping();
			all.put(dto.getKCode(), dto);
		}
		return all;
	}
	
	/**
	 * ɂf[^擾(lo͗p)
	 * @param resExpectedDate ZœKpN(L[)
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	public Map<String, CmResidenceTaxDto> findForHumanData(Date resExpectedDate) throws SQLException,
			IllegalAccessException {
		try {
			index = 1;
			prepareStatement(getHistoryTableForHumanData());
			setParam(index++, resExpectedDate);
			executeQuery();
			return mappingAllMap();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(lo͗p)
	 * @param resExpectedDate ZœKpN(L[)
	 * @param kCode Ј(L[)
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	public CmResidenceTaxDto findForHumanDataOnly(String kCode, Date resExpectedDate) throws SQLException,
			IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" AND ");
			sb.append(COL_K_CODE + " = ? ");
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			prepareStatement(getHistoryTableForHumanData() + sb.toString());
			setParam(index++, resExpectedDate);
			setParam(index++, kCode);
			executeQuery();
			CmResidenceTaxDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^擾
	 * @param kCode           ЈR[h(L[)
	 * @param resExpectedDate KpN  (L[)
	 * @return CmIncomeTaxDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	public CmResidenceTaxDto findForEmployeeDate(String kCode, Date resExpectedDate) throws SQLException,
			IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(getSelectStatement(getClass()) + " ");
			sb.append("FROM ");
			sb.append(getHistoryTableForDate() + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			prepareStatement(sb.toString());
			setParam(index++, resExpectedDate);
			setParam(index++, kCode);
			executeQuery();
			CmResidenceTaxDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<CmResidenceTaxDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CmResidenceTaxDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode           ЈR[h(L[)
	 * @param resExpectedDate ZœKpN(L[)
	 * @return CmResidenceTaxDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public CmResidenceTaxDto findForKey(String kCode, Date resExpectedDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, resExpectedDate);
			executeQuery();
			CmResidenceTaxDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	public CmResidenceTaxDto findForEmployee(String kCode) throws SQLException, IllegalAccessException {
		try {
//			index = 1;
//			prepareStatement(getHistoryTable());
//			setParam(index++, kCode);
//			executeQuery();
//			CmResidenceTaxDto dto = null;
//			if (rs.next()) {
//				dto = mapping();
//			}
//			return dto;
			
			// TuNG̎s
			this.setPreparedStatement(Mode.SELECT, "CM_RESIDENCE_TAX");
			this.pob.appendWhere("K_CODE", Query.FilterOperator.EQUAL, kCode);
			this.pob.appendOperationMax("RES_EXPECTED_DATE");
			prepareStatement(null);
			executeQuery();
			List<Object> hKCodes = new ArrayList<Object>();
			List<Object> hExpectedDates = new ArrayList<Object>();
			while(rs.next()) {
				Object hKCode = rs.getObject("K_CODE");
				if (!hKCodes.contains(hKCode)) {
					hKCodes.add(hKCode);
				}
				Object hExpectedDate = rs.getObject("RES_EXPECTED_DATE");
				if (!hExpectedDates.contains(hExpectedDate)) {
					hExpectedDates.add(hExpectedDate);
				}
			}
			// C̎s
			this.setPreparedStatement(Mode.SELECT);
			this.pob.appendWhere("K_CODE", Query.FilterOperator.IN, hKCodes);
			this.pob.appendWhere("RES_EXPECTED_DATE", Query.FilterOperator.IN, hExpectedDates);
			prepareStatement(null);
			executeQuery();
			CmResidenceTaxDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
			
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂzf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return CmResidenceTaxDto (DTO)
	 * @throws SQLException SQLOꍇ
	 */
	public List<CmResidenceTaxDto> findForEmployeeList(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT * FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			this.setPreparedStatement(Mode.SELECT, TABLE);
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeQuery();
			List<CmResidenceTaxDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public CmResidenceTaxDto findForUpdate(String kCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getForUpdate());
			setParam(index++, kCode);
			executeQuery();
			CmResidenceTaxDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode           ЈR[h(L[)
	 * @param resExpectedDate ZœKpN(L[)
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public CmResidenceTaxDto findForUpdate(String kCode, Date resExpectedDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			setParam(index++, resExpectedDate);
			executeQuery();
			CmResidenceTaxDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}(Abv[h)
	 * @param aryHeaderNo }Ώۃwb_[
	 * @param aryCsvData  }Ώۃf[^
	 * @param kCode ЈR[h
	 * @param calcDate KpN
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 */
	public int insertUpload(String[] aryHeaderNo, String[] aryCsvData, String kCode, Date calcDate) throws SQLException {
		throw new CloudzeroUnsupportedException();
/*		try {
			Date date = new Date();
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("INSERT INTO ");
			sb.append(TABLE);
			sb.append(" ( ");
			sb.append(COL_K_CODE);
			sb.append(", ");
			sb.append(createCol(aryHeaderNo, true));
			sb.append(COL_RES_EXPECTED_DATE);
			sb.append(", ");
			if (!INSERT_DATE.equals("")) {
				sb.append(INSERT_DATE + ", ");
			}
			if (!INSERT_USER.equals("")) {
				sb.append(INSERT_USER + ", ");
			}
			if (!UPDATE_DATE.equals("")) {
				sb.append(UPDATE_DATE + ", ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append(UPDATE_USER + " ");
			}
			sb.append(" ) VALUES ( ");
			sb.append("?, ");
			sb.append(insertRow(aryCsvData));
			sb.append("?, ");
			if (!INSERT_DATE.equals("")) {
				sb.append("?, ");
			}
			if (!INSERT_USER.equals("")) {
				sb.append("?, ");
			}
			if (!UPDATE_DATE.equals("")) {
				sb.append("?, ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append("?  ");
			}
			sb.append(" ) ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			for (String element : aryCsvData) {
				setParam(index++, element);
			}
			setParam(index++, calcDate);
			if (!INSERT_DATE.equals("")) {
				setParam(index++, date);
			}
			if (!INSERT_USER.equals("")) {
				setParam(index++, userId);
			}
			if (!UPDATE_DATE.equals("")) {
				setParam(index++, date);
			}
			if (!UPDATE_USER.equals("")) {
				setParam(index++, userId);
			}
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * IĴSQL쐬
	 * @param aryHeaderNo
	 * @param isInsert
	 * @return IĴSQL
	 */
	public String createCol(String[] aryHeaderNo, boolean isInsert) {
		index = 1;
		StringBuffer sb = new StringBuffer();
		for (String element : aryHeaderNo) {
			sb.append(getColumn(Integer.parseInt(element)));
			if (!isInsert) {
				sb.append(" = ? ");
			}
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
		}
		return sb.toString();
	}
	
	/**
	 * o^p[^
	 * @param aryCsvData
	 * @return o^p[^
	 */
	public String insertRow(String[] aryCsvData) {
		index = 1;
		StringBuffer sb = new StringBuffer();
		for (String element : aryCsvData) {
			sb.append(" ? ");
			sb.append(PayrollConst.STR_CSV_SEPARATOR);
		}
		return sb.toString();
		
	}
	
	/**
	 * f[^XV(Abv[h)
	 * @param aryHeaderNo XVΏۃwb_[
	 * @param aryCsvData  XVΏۃf[^
	 * @param kCode       ЈR[h
	 * @param calcDate    KpN
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 */
	public int updateUpload(String[] aryHeaderNo, String[] aryCsvData, String kCode, Date calcDate) throws SQLException {
		throw new CloudzeroUnsupportedException();
/*		try {
			Date date = new Date();
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("UPDATE ");
			sb.append(TABLE);
			sb.append(" SET ");
			sb.append(createCol(aryHeaderNo, false));
			sb.append(COL_RES_EXPECTED_DATE + " = ?, ");
			if (!UPDATE_DATE.equals("")) {
				sb.append(UPDATE_DATE + " = ?, ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append(UPDATE_USER + " = ? ");
			}
			sb.append(" WHERE ");
			sb.append(COL_K_CODE);
			sb.append(" = ? ");
			sb.append(" AND ");
			sb.append(COL_RES_EXPECTED_DATE);
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			for (String element : aryCsvData) {
				setParam(index++, element);
			}
			setParam(index++, calcDate);
			if (!UPDATE_DATE.equals("")) {
				setParam(index++, date);
			}
			if (!UPDATE_USER.equals("")) {
				setParam(index++, userId);
			}
			setParam(index++, kCode);
			setParam(index++, calcDate);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public int insert(CmResidenceTaxDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException MosPOꍇ
	 */
	public int update(CmResidenceTaxDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getResExpectedDate());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			
			this.setPreparedStatement(Mode.DELETE, TABLE);
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 * @throws MospException
	 */
	public int delete(CmResidenceTaxDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getResExpectedDate());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
//	/**
//	 * f[^SQL擾
//	 * @return f[^擾SQL
//	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
//	 */
//	private String getHistoryTable() throws IllegalAccessException {
//		StringBuffer sb = new StringBuffer();
//		sb.append(getSelectStatement(getClass()));
//		sb.append("FROM ");
//		sb.append(TABLE + ", ");
//		sb.append("(");
//		sb.append("SELECT ");
//		sb.append(COL_K_CODE + " AS H_K_CODE, ");
//		sb.append("MAX(" + COL_RES_EXPECTED_DATE + ") AS H_EXPECTED_DATE ");
//		sb.append("FROM " + TABLE + " ");
//		sb.append("WHERE ");
//		sb.append(COL_K_CODE + " = ? ");
//		sb.append("GROUP BY " + COL_K_CODE + " ");
//		sb.append(") HISTORY ");
//		sb.append("WHERE ");
//		sb.append(COL_K_CODE + " = HISTORY.H_K_CODE ");
//		sb.append("AND ");
//		sb.append(COL_RES_EXPECTED_DATE + " = HISTORY.H_EXPECTED_DATE ");
//		return sb.toString();
//	}
	
	/**
	 * f[^SQL擾
	 * @return f[^擾SQL
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	private String getHistoryTableForHumanData() throws IllegalAccessException {
		throw new CloudzeroUnsupportedException();
/*		StringBuffer sb = new StringBuffer();
		sb.append(getSelectStatement(getClass()));
		sb.append("FROM ");
		sb.append(TABLE + ", ");
		sb.append("(");
		sb.append("SELECT ");
		sb.append(COL_K_CODE + " H_K_CODE, ");
		sb.append("MAX(" + COL_RES_EXPECTED_DATE + ") H_EXPECTED_DATE ");
		sb.append("FROM " + TABLE + " ");
		sb.append("WHERE " + COL_RES_EXPECTED_DATE + " <= ? ");
		sb.append("GROUP BY " + COL_K_CODE + " ");
		sb.append(") HISTORY ");
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = HISTORY.H_K_CODE ");
		sb.append("AND ");
		sb.append(COL_RES_EXPECTED_DATE + " = HISTORY.H_EXPECTED_DATE ");
		return sb.toString();*/
	}
	
	/**
	 * f[^SQL擾(ZFBf[^p)
	 * @return f[^擾SQL
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	private String getHistoryForFirmBanking() throws IllegalAccessException {
		throw new CloudzeroUnsupportedException();
/*		StringBuffer sb = new StringBuffer();
		sb.append(getSelectStatement(getClass()));
		sb.append("FROM ");
		sb.append(TABLE + ", ");
		sb.append("(");
		sb.append("SELECT ");
		sb.append(COL_K_CODE + " H_K_CODE, ");
		sb.append("MAX(" + COL_RES_EXPECTED_DATE + ") H_EXPECTED_DATE ");
		sb.append("FROM " + TABLE + " ");
		sb.append("WHERE " + COL_RES_EXPECTED_DATE + " <= ? ");
		sb.append("AND " + COL_PAYMENT_CITY_CODE + " = ? ");
		sb.append("GROUP BY " + COL_K_CODE + " ");
		sb.append(") HISTORY ");
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = HISTORY.H_K_CODE ");
		sb.append("AND ");
		sb.append(COL_RES_EXPECTED_DATE + " = HISTORY.H_EXPECTED_DATE ");
		return sb.toString();*/
	}
	
	/**
	 * f[^SQL擾
	 * @return f[^擾SQL
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	public String getHistoryTableForDate() throws IllegalAccessException {
		throw new CloudzeroUnsupportedException();
/*		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(getHistoryTableForHumanData());
		sb.append(") " + TABLE + " ");
		return sb.toString();*/
	}
	
	/**
	 * f[^SQL擾
	 * @return f[^擾SQL
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	public String getHistoryTableForFB() throws IllegalAccessException {
		throw new CloudzeroUnsupportedException();
/*		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(getHistoryForFirmBanking());
		sb.append(") " + " ");
		return sb.toString();*/
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(CmResidenceTaxDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode()); // ЈR[h
		setParam(index++, dto.getResExpectedDate()); // ZœKpN
		setParam(index++, dto.getPaymentCityCode()); // [tsR[h
		setParam(index++, dto.getSubmitCityCode()); // osR[h
		setParam(index++, dto.getJuneAmount()); // 6
		setParam(index++, dto.getJulyAmount()); // 7
		setParam(index++, dto.getAugustAmount()); // 8
		setParam(index++, dto.getSeptemberAmount()); // 9
		setParam(index++, dto.getOctoberAmount()); // 10
		setParam(index++, dto.getNovemberAmount()); // 11
		setParam(index++, dto.getDecemberAmount()); // 12
		setParam(index++, dto.getJanuaryAmount()); // 1
		setParam(index++, dto.getFebruaryAmount()); // 2
		setParam(index++, dto.getMarchAmount()); // 3
		setParam(index++, dto.getAprilAmount()); // 4
		setParam(index++, dto.getMayAmount()); // 5
		setCommonParams(isInsert);
	}
	
	/**
	 * J擾
	 * @param idx
	 * @return J
	 */
	public String getColumn(int idx) {
		switch (idx) {
			case 25:
				return COL_PAYMENT_CITY_CODE; // [tsR[h
			case 26:
				return COL_SUBMIT_CITY_CODE; // osR[h
			case 27:
				return COL_JUNE_AMOUNT; // 6
			case 28:
				return COL_JULY_AMOUNT; // 7
			case 29:
				return COL_AUGUST_AMOUNT; // 8
			case 30:
				return COL_SEPTEMBER_AMOUNT; // 9
			case 31:
				return COL_OCTOBER_AMOUNT; // 10
			case 32:
				return COL_NOVEMBER_AMOUNT; // 11
			case 33:
				return COL_DECEMBER_AMOUNT; // 12
			case 34:
				return COL_JANUARY_AMOUNT; // 1
			case 35:
				return COL_FEBRUARY_AMOUNT; // 2
			case 36:
				return COL_MARCH_AMOUNT; // 3
			case 37:
				return COL_APRIL_AMOUNT; // 4
			case 38:
				return COL_MAY_AMOUNT; // 5
			default:
				return "";
		}
	}
}
