/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.getset.gae.bigtable.Statement.Mode;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.CdSocInsuranceDto;

public class CdSocInsuranceDao extends PayrollDao {
	
	// e[uyуL[
	public static final String	TABLE						= "CD_SOC_INSURANCE";
	public static final String	KEY_1						= "K_CODE";					// ЈR[h
	public static final String	KEY_2						= "CALC_DATE";					// vZN
																							
	// 
	public static final String	COL_K_CODE					= "K_CODE";					// ЈR[h
	public static final String	COL_K_NAME					= "K_NAME";					// Ј
	public static final String	COL_SCODE					= "SCODE";						// R[h
	public static final String	COL_CALC_DATE				= "CALC_DATE";					// vZN
	public static final String	COL_PAY_BASIC_MONTH1		= "PAY_BASIC_MONTH1";			// xb1()
	public static final String	COL_PAY_BASIC_MONTH2		= "PAY_BASIC_MONTH2";			// xb2()
	public static final String	COL_PAY_BASIC_MONTH3		= "PAY_BASIC_MONTH3";			// xb3()
	public static final String	COL_PAY_BASIC_DAY1			= "PAY_BASIC_DAY1";			// xb1()
	public static final String	COL_PAY_BASIC_DAY2			= "PAY_BASIC_DAY2";			// xb2()
	public static final String	COL_PAY_BASIC_DAY3			= "PAY_BASIC_DAY3";			// xb3()
	public static final String	COL_PAY_AMOUNT1				= "PAY_AMOUNT1";				// K̊z1
	public static final String	COL_PAY_AMOUNT2				= "PAY_AMOUNT2";				// K̊z2
	public static final String	COL_PAY_AMOUNT3				= "PAY_AMOUNT3";				// K̊z3
	public static final String	COL_GOODS_AMOUNT1			= "GOODS_AMOUNT1";				// ̊z1
	public static final String	COL_GOODS_AMOUNT2			= "GOODS_AMOUNT2";				// ̊z2
	public static final String	COL_GOODS_AMOUNT3			= "GOODS_AMOUNT3";				// ̊z3
	public static final String	COL_REWARD_TOTAL1			= "REWARD_TOTAL1";				// Vv1
	public static final String	COL_REWARD_TOTAL2			= "REWARD_TOTAL2";				// Vv2
	public static final String	COL_REWARD_TOTAL3			= "REWARD_TOTAL3";				// Vv3
	public static final String	COL_REWARD_TOTAL_SUM		= "REWARD_TOTAL_SUM";			// Vz
	public static final String	COL_AVERAGE_THREE_MONTHS	= "AVERAGE_THREE_MONTHS";		// R
	public static final String	COL_EDIT_AVERAGE			= "EDIT_AVERAGE";				// C
	public static final String	COL_HEALTH_BEF_GRADE		= "HEALTH_BEF_GRADE";			// ۏ]O
	public static final String	COL_HEALTH_BEF_PREMIUM		= "HEALTH_BEF_PREMIUM";		// ۏ]Oی
	public static final String	COL_PENSION_BEF_GRADE		= "PENSION_BEF_GRADE";			// N]O
	public static final String	COL_PENSION_BEF_PREMIUM		= "PENSION_BEF_PREMIUM";		// N]Oی
	public static final String	COL_HEALTH_DEC_GRADE		= "HEALTH_DEC_GRADE";			// ی蓙
	public static final String	COL_HEALTH_DEC_PREMIUM		= "HEALTH_DEC_PREMIUM";		// یی
	public static final String	COL_PENSION_DEC_GRADE		= "PENSION_DEC_GRADE";			// N蓙
	public static final String	COL_PENSION_DEC_PREMIUM		= "PENSION_DEC_PREMIUM";		// Nی
	public static final String	COL_RETROACTIVE_PAYMENT		= "RETROACTIVE_PAYMENT";		// kyxz
	public static final String	COL_RAISE_DOWN_SALARY_DATE	= "RAISE_DOWN_SALARY_DATE";	// ~N
	public static final String	COL_RAISE_DOWN_SALARY_BASIS	= "RAISE_DOWN_SALARY_BASIS";	// ~̌z
	public static final String	COL_EXPECTED_DATE			= "EXPECTED_DATE";				// KpN
	public static final String	COL_CALC_RESULT				= "CALC_RESULT";				// vZ
																							
	
	/**
	 * RXgN^
	 */
	public CdSocInsuranceDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<CdSocInsuranceDto> mappingAll() throws SQLException {
		List<CdSocInsuranceDto> all = new ArrayList<CdSocInsuranceDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return UdPaymentDto UD_PAYMENTR[h
	 * @throws SQLException
	 */
	private CdSocInsuranceDto mapping() throws SQLException {
		CdSocInsuranceDto dto = new CdSocInsuranceDto();
		dto.setKCode(rs.getString(COL_K_CODE)); // ЈR[h
		dto.setKName(rs.getString(COL_K_NAME)); // Ј
		dto.setSCode(rs.getString(COL_SCODE)); // R[h
		dto.setCalcDate(rs.getDate(COL_CALC_DATE)); // vZN
		dto.setPayBasicMonth1(rs.getInt(COL_PAY_BASIC_MONTH1)); // xb1()
		dto.setPayBasicMonth2(rs.getInt(COL_PAY_BASIC_MONTH2)); // xb2()
		dto.setPayBasicMonth3(rs.getInt(COL_PAY_BASIC_MONTH3)); // xb3()
		dto.setPayBasicDay1(rs.getInt(COL_PAY_BASIC_DAY1)); // xb1()
		dto.setPayBasicDay2(rs.getInt(COL_PAY_BASIC_DAY2)); // xb2()
		dto.setPayBasicDay3(rs.getInt(COL_PAY_BASIC_DAY3)); // xb3()
		dto.setPayAmount1(rs.getInt(COL_PAY_AMOUNT1)); // K̊z1
		dto.setPayAmount2(rs.getInt(COL_PAY_AMOUNT2)); // K̊z2
		dto.setPayAmount3(rs.getInt(COL_PAY_AMOUNT3)); // K̊z3
		dto.setGoodsAmount1(rs.getInt(COL_GOODS_AMOUNT1)); // ̊z1
		dto.setGoodsAmount2(rs.getInt(COL_GOODS_AMOUNT2)); // ̊z2
		dto.setGoodsAmount3(rs.getInt(COL_GOODS_AMOUNT3)); // ̊z3
		dto.setRewardTotal1(rs.getInt(COL_REWARD_TOTAL1)); // Vv1
		dto.setRewardTotal2(rs.getInt(COL_REWARD_TOTAL2)); // Vv2
		dto.setRewardTotal3(rs.getInt(COL_REWARD_TOTAL3)); // Vv3
		dto.setRewardTotalSum(rs.getInt(COL_REWARD_TOTAL_SUM)); // Vz
		dto.setAverageThreeMonths(rs.getInt(COL_AVERAGE_THREE_MONTHS)); // R
		dto.setEditAverage(rs.getInt(COL_EDIT_AVERAGE)); // C
		dto.setHealthBefGrade(rs.getInt(COL_HEALTH_BEF_GRADE)); // ۏ]O
		dto.setHealthBefPremium(rs.getInt(COL_HEALTH_BEF_PREMIUM)); // ۏ]Oی
		dto.setPensionBefGrade(rs.getInt(COL_PENSION_BEF_GRADE)); // N]O
		dto.setPensionBefPremium(rs.getInt(COL_PENSION_BEF_PREMIUM)); // N]Oی
		dto.setHealthDecGrade(rs.getInt(COL_HEALTH_DEC_GRADE)); // ی蓙
		dto.setHealthDecPremium(rs.getInt(COL_HEALTH_DEC_PREMIUM)); // یی
		dto.setPensionDecGrade(rs.getInt(COL_PENSION_DEC_GRADE)); // N蓙
		dto.setPensionDecPremium(rs.getInt(COL_PENSION_DEC_PREMIUM)); // Nی
		dto.setRetroactivePayment(rs.getInt(COL_RETROACTIVE_PAYMENT)); // kyxz
		dto.setRaiseDownSalaryDate(rs.getDate(COL_RAISE_DOWN_SALARY_DATE)); // ~N
		dto.setRaiseDownSalaryBasis(rs.getInt(COL_RAISE_DOWN_SALARY_BASIS)); // ~̌z
		dto.setExpectedDate(rs.getDate(COL_EXPECTED_DATE)); // KpN
		dto.setCalcResult(rs.getInt(COL_CALC_RESULT)); // vZ
		
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CdSocInsuranceDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<CdSocInsuranceDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @param calcDate vZN(L[)
	 * @return CdSocInsuranceDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CdSocInsuranceDto findForKey(String kCode, Date calcDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, calcDate);
			executeQuery();
			CdSocInsuranceDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @param calcDate vZN(L[)
	 * @return CdSocInsuranceDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public CdSocInsuranceDto findForUpdate(String kCode, Date calcDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			setParam(index++, calcDate);
			executeQuery();
			CdSocInsuranceDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param calcDate vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<CdSocInsuranceDto> findForCondition(Date calcDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_CALC_DATE);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_CALC_DATE, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, calcDate);
			executeQuery();
			List<CdSocInsuranceDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^폜
	 * @param calcDate vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 */
	public int deleteForCondition(Date calcDate) throws SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("DELETE FROM ");
		sb.append(TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_CALC_DATE);
		sb.append(" = ? ");
		
		this.setPreparedStatement(Mode.DELETE, TABLE);
		this.pob.appendWhere(COL_CALC_DATE, Query.FilterOperator.EQUAL);
		
		try {
			prepareStatement(sb.toString());
			setParam(index++, calcDate);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CdSocInsuranceDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @param needLog Oo͗v
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(CdSocInsuranceDto dto, boolean needLog) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate(needLog);
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(CdSocInsuranceDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getCalcDate());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(CdSocInsuranceDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getCalcDate());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(l}X^ێ-Јꗗp)
	 * @param kCode          ЈR[h
	 * @param kName          Ј
	 * @param kKana          ض
	 * @param stationCode    R[h
	 * @param positionCode   EʃR[h
	 * @param retirementFlag ސEtO
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public List<CdSocInsuranceDto> findForSocInsList(String clacResult, String kCode, String kName, String stationCode,
			Date calcdDate) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_CALC_DATE + " =  ? ");
		this.pob.appendWhere(COL_CALC_DATE, Query.FilterOperator.EQUAL);
		if (kCode != null && !kCode.equals("") || kName != null && !kName.equals("") || stationCode != null
				&& !stationCode.equals("") || clacResult != null && !clacResult.equals("")) {
			sb.append(" AND ");
		}
		if (kCode != null && !kCode.equals("")) {
			sb.append(COL_K_CODE + " =  ? ");
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			if (kName != null && !kName.equals("") || stationCode != null && !stationCode.equals("")
					|| clacResult != null && !clacResult.equals("")) {
				sb.append("AND ");
			}
		}
		if (kName != null && !kName.equals("")) {
			sb.append(COL_K_NAME + " =  ? ");
			this.pob.appendWhere(COL_K_NAME, Query.FilterOperator.EQUAL);
			if (

			stationCode != null && !stationCode.equals("") || clacResult != null && !clacResult.equals("")) {
				sb.append("AND ");
			}
		}
		if (stationCode != null && !stationCode.equals("")) {
			sb.append(COL_SCODE + " =  ? ");
			this.pob.appendWhere(COL_SCODE, Query.FilterOperator.EQUAL);
			if (clacResult != null && !clacResult.equals("")) {
				sb.append("AND ");
			}
		}
		if (clacResult != null && !clacResult.equals("")) {
			sb.append(COL_CALC_RESULT + " =  ? ");
			this.pob.appendWhere(COL_CALC_RESULT, Query.FilterOperator.EQUAL);
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, calcdDate);
			
			if (kCode != null && !kCode.equals("")) {
				setParam(index++, kCode);
			}
			if (kName != null && !kName.equals("")) {
				setParam(index++, kName);
			}
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			if (clacResult != null && !clacResult.equals("")) {
				setParam(index++, clacResult);
			}
			// s
			executeQuery();
			List<CdSocInsuranceDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(CdSocInsuranceDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode()); // ЈR[h
		setParam(index++, dto.getKName()); // Ј
		setParam(index++, dto.getSCode()); // R[h
		setParam(index++, dto.getCalcDate()); // vZN
		setParam(index++, dto.getPayBasicMonth1()); // xb1()
		setParam(index++, dto.getPayBasicMonth2()); // xb2()
		setParam(index++, dto.getPayBasicMonth3()); // xb3()
		setParam(index++, dto.getPayBasicDay1()); // xb1()
		setParam(index++, dto.getPayBasicDay2()); // xb2()
		setParam(index++, dto.getPayBasicDay3()); // xb3()
		setParam(index++, dto.getPayAmount1()); // K̊z1
		setParam(index++, dto.getPayAmount2()); // K̊z2
		setParam(index++, dto.getPayAmount3()); // K̊z3
		setParam(index++, dto.getGoodsAmount1()); // ̊z1
		setParam(index++, dto.getGoodsAmount2()); // ̊z2
		setParam(index++, dto.getGoodsAmount3()); // ̊z3
		setParam(index++, dto.getRewardTotal1()); // Vv1
		setParam(index++, dto.getRewardTotal2()); // Vv2
		setParam(index++, dto.getRewardTotal3()); // Vv3
		setParam(index++, dto.getRewardTotalSum()); // Vz
		setParam(index++, dto.getAverageThreeMonths()); // R
		setParam(index++, dto.getEditAverage()); // C
		setParam(index++, dto.getHealthBefGrade()); // ۏ]O
		setParam(index++, dto.getHealthBefPremium()); // ۏ]Oی
		setParam(index++, dto.getPensionBefGrade()); // N]O
		setParam(index++, dto.getPensionBefPremium()); // N]Oی
		setParam(index++, dto.getHealthDecGrade()); // ی蓙
		setParam(index++, dto.getHealthDecPremium()); // یی
		setParam(index++, dto.getPensionDecGrade()); // N蓙
		setParam(index++, dto.getPensionDecPremium()); // Nی
		setParam(index++, dto.getRetroactivePayment()); // kyxz
		setParam(index++, dto.getRaiseDownSalaryDate()); // ~N
		setParam(index++, dto.getRaiseDownSalaryBasis()); // ~̌z
		setParam(index++, dto.getExpectedDate()); // KpN
		setParam(index++, dto.getCalcResult()); // vZ
		
		setCommonParams(isInsert);
	}
	
}
