/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.appengine.api.datastore.Query;

import jp.cloudzero.mosp.exception.CloudzeroUnsupportedException;
import jp.getset.gae.bigtable.Statement.Mode;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.bonus.dto.PhIndividualDto;

public class PhIndividualDao extends PayrollDao {
	
	// e[uyуL[
	public static final String	TABLE					= "UH_INDIVIDUAL";
	public static final String	KEY_1					= "K_CODE";			// ЈR[h
	public static final String	KEY_2					= "EXPECTED_DATE";		// Kp\
																				
	// 
	public static final String	COL_K_CODE				= "K_CODE";			// ЈR[h
	public static final String	COL_EXPECTED_DATE		= "EXPECTED_DATE";		// Kp\
	public static final String	COL_APPLIED_DATE		= "APPLIED_DATE";		// Kp
	public static final String	COL_BUSINESS_TYPE		= "BUSINESS_TYPE";		// Ƌ敪
	public static final String	COL_CALENDAR_TYPE		= "CALENDAR_TYPE";		// J_[敪
	public static final String	COL_EFFORT_TYPE			= "EFFORT_TYPE";		// ʗ敪
	public static final String	COL_GRADE				= "GRADE";				// 
	public static final String	COL_NOTCH				= "NOTCH";				// 
	public static final String	COL_BASIC_SALARY		= "BASIC_SALARY";		// {
	public static final String	COL_ABILITY_ALLOWANCE	= "ABILITY_ALLOWANCE";	// E\蓖
	public static final String	COL_ABILITY_ALLOWANCE2	= "ABILITY_ALLOWANCE2"; // E\蓖2
	public static final String	COL_PAYMENT_TYPE		= "PAYMENT_TYPE";		// x敪
	public static final String	COL_OVERTIME_TYPE		= "OVERTIME_TYPE";		// cƋ敪
	public static final String	COL_PAID_HOLIDAY_TYPE	= "PAID_HOLIDAY_TYPE";	// L敪
	public static final String	COL_PAID_HOLIDAY_MONTH	= "PAID_HOLIDAY_MONTH"; // LxɋNZ
																				
	
	/**
	 * RXgN^
	 */
	public PhIndividualDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PhIndividualDto> mappingAll() throws SQLException {
		List<PhIndividualDto> all = new ArrayList<PhIndividualDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTOMap)
	 * @return Map }bv
	 * @throws SQLException
	 */
	private Map<String, PhIndividualDto> mappingAllMap() throws SQLException {
		Map<String, PhIndividualDto> all = new HashMap<String, PhIndividualDto>();
		while (rs.next()) {
			PhIndividualDto dto = mapping();
			all.put(dto.getKCode(), dto);
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return PhIndividualDto UH_INDIVIDUALR[h
	 * @throws SQLException
	 */
	private PhIndividualDto mapping() throws SQLException {
		PhIndividualDto dto = new PhIndividualDto();
		dto.setKCode(rs.getString(COL_K_CODE)); // ЈR[h
		dto.setExpectedDate(rs.getDate(COL_EXPECTED_DATE)); // Kp\
		dto.setAppliedDate(rs.getDate(COL_APPLIED_DATE)); // Kp
		dto.setBusinessType(rs.getString(COL_BUSINESS_TYPE)); // Ƌ敪
		dto.setCalendarType(rs.getString(COL_CALENDAR_TYPE)); // J_[敪
		dto.setEffortType(rs.getString(COL_EFFORT_TYPE)); // ʗ敪
		dto.setGrade(rs.getInt(COL_GRADE)); // 
		dto.setNotch(rs.getInt(COL_NOTCH)); // 
		dto.setBasicSalary(rs.getInt(COL_BASIC_SALARY)); // {
		dto.setAbilityAllowance(rs.getInt(COL_ABILITY_ALLOWANCE)); // E\蓖
		dto.setAbilityAllowance2(rs.getInt(COL_ABILITY_ALLOWANCE2)); // E\蓖2
		dto.setPaymentType(rs.getString(COL_PAYMENT_TYPE)); // x敪
		dto.setOvertimeType(rs.getString(COL_OVERTIME_TYPE)); // cƋ敪
		dto.setPaidHolidayType(rs.getString(COL_PAID_HOLIDAY_TYPE)); // L敪
		dto.setPaidHolidayMonth(rs.getDate(COL_PAID_HOLIDAY_MONTH)); // LxɋNZ
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PhIndividualDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<PhIndividualDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @param expectedDate Kp\(L[)
	 * @return PhIndividualDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PhIndividualDto findForKey(String kCode, Date expectedDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, expectedDate);
			executeQuery();
			PhIndividualDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Nɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @param expectedDate KpN(L[)
	 * @return PhIndividualDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PhIndividualDto findForDate(String kCode, Date expectedDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_EXPECTED_DATE + " = (");
			sb.append("SELECT MAX(" + COL_EXPECTED_DATE + ") ");
			sb.append("FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_EXPECTED_DATE + " <= ? ");
			sb.append("AND ");
			sb.append(COL_APPLIED_DATE + " IS NOT NULL ");
			sb.append(")");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, kCode);
			setParam(index++, expectedDate);
			executeQuery();
			PhIndividualDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * ЈR[hɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return PhIndividualDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PhIndividualDto> findForEmployeeAll(String kCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_APPLIED_DATE + " IS NOT NULL ");
			
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			this.pob.appendIsNotNull(COL_APPLIED_DATE);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈR[hɂf[^擾
	 * @param kCode ЈR[h(L[)
	 * @return PhIndividualDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PhIndividualDto findForEmployee(String kCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_EXPECTED_DATE + " = (");
			sb.append("SELECT MAX(" + COL_EXPECTED_DATE + ") ");
			sb.append("FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_APPLIED_DATE + " IS NOT NULL ");
			sb.append(")");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, kCode);
			executeQuery();
			PhIndividualDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kCode ЈR[h(L[)
	 * @param expectedDate Kp\(L[)
	 * @return PhIndividualDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PhIndividualDto findForUpdate(String kCode, Date expectedDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kCode);
			setParam(index++, expectedDate);
			executeQuery();
			PhIndividualDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode ЈR[h
	 * @param expectedDate Kp\
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PhIndividualDto> findForCondition(String kCode, String expectedDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_EXPECTED_DATE);
		sb.append(" LIKE ? AND ");
		this.pob.appendLike(COL_K_CODE);
		this.pob.appendLike(COL_EXPECTED_DATE);
		
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, expectedDate + "%");
			executeQuery();
			List<PhIndividualDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(lo͗p)
	 * @param endDate WvI
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public Map<String, PhIndividualDto> findForHumanData(Date endDate) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("FROM ");
			sb.append(getHistoryTable());
			prepareStatement(getSelectStatement(getClass()) + sb.toString());
			setParam(index++, endDate);
			executeQuery();
			return mappingAllMap();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^SQL擾
	 * @return f[^擾SQL
	 * @throws IllegalAccessException 
	 */
	private String getHistoryTable() throws IllegalAccessException {
		throw new CloudzeroUnsupportedException();
/*		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(getSelectStatement(getClass()));
		sb.append("FROM ");
		sb.append(TABLE + ", ");
		sb.append("(");
		sb.append("SELECT ");
		sb.append(COL_K_CODE + " AS H_K_CODE, ");
		sb.append("MAX(" + COL_EXPECTED_DATE + ") AS H_EXPECTED_DATE ");
		sb.append("FROM " + TABLE + " ");
		sb.append("WHERE ");
		sb.append(COL_EXPECTED_DATE + " <= ? ");
		sb.append("AND ");
		sb.append(COL_APPLIED_DATE + " IS NOT NULL ");
		sb.append("GROUP BY " + COL_K_CODE + " ");
		sb.append(") HISTORY ");
		sb.append("WHERE ");
		sb.append(COL_K_CODE + " = HISTORY.H_K_CODE ");
		sb.append("AND ");
		sb.append(COL_EXPECTED_DATE + " = HISTORY.H_EXPECTED_DATE");
		sb.append(") " + TABLE + " ");
		return sb.toString();*/
	}
	
	/**
	 * ЈR[hɂ関Kpf[^擾
	 * @param kCode       ЈR[h(L[)
	 * @param isForUpdate UPDATEptO
	 * @return PhIndividualDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PhIndividualDto findForEmployeeNotApplied(String kCode, boolean isForUpdate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_APPLIED_DATE + " IS NULL ");
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			this.pob.appendIsNull(COL_APPLIED_DATE);
			if (isForUpdate) {
				sb.append(getForUpdate());
			}
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			executeQuery();
			PhIndividualDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈR[hɂ関Kpf[^폜
	 * @param expectedDate Kp\
	 * @return List (DTOList)
	 * @throws SQLException
	 */
	public int deleteNotApplied(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			sb.append("AND ");
			sb.append(COL_APPLIED_DATE + " IS NULL ");
			
			this.setPreparedStatement(Mode.DELETE);
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			this.pob.appendIsNull(COL_APPLIED_DATE);
			
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PhIndividualDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(PhIndividualDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getExpectedDate());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(PhIndividualDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getExpectedDate());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Јɂf[^폜
	 * @param kCode 폜ΏێЈR[h
	 * @return int 폜()
	 * @throws SQLException
	 */
	public int deleteForEmployee(String kCode) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM " + TABLE + " ");
			sb.append("WHERE ");
			sb.append(COL_K_CODE + " = ? ");
			
			this.setPreparedStatement(Mode.DELETE);
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(lǉo͗p)
	 * @param kCode          ЈR[h
	 * @param kName          Ј
	 * @param kKana          ض
	 * @param stationCode    R[h
	 * @param positionCode   EʃR[h
	 * @param retirementFlag ސEtO
	 * @param startDate      Jn
	 * @param endDate        I
	 * @return UhLicenseTypeDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PhIndividualDto> findForConditionList(String kCode, String kName, String kKana, String stationCode,
			String positionCode, String retirementFlag, Date startDate, Date endDate) throws SQLException,
			IllegalAccessException {
		throw new CloudzeroUnsupportedException();
/*		try {
			PmBasisDao pmBasisDao = new PmBasisDao();
			StringBuffer sb = new StringBuffer();
			index = 1;
			sb.append(getSelectStatement(getClass()) + " ");
			sb.append("FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_K_CODE + " IN  ");
			sb.append(" ( ");
			sb.append(pmBasisDao.getForAddHumanListSubQuery(stationCode, positionCode, retirementFlag));
			sb.append(" ) ");
			sb.append(" AND ");
			sb.append(COL_EXPECTED_DATE + " >= ? ");
			sb.append(" AND ");
			sb.append(COL_EXPECTED_DATE + " <= ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode + "%");
			setParam(index++, "%" + kName + "%");
			setParam(index++, "%" + kKana + "%");
			if (stationCode != null && !stationCode.equals("")) {
				setParam(index++, stationCode);
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			List<PhIndividualDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(PhIndividualDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode()); // ЈR[h
		setParam(index++, dto.getExpectedDate()); // Kp\
		setParam(index++, dto.getAppliedDate()); // Kp
		setParam(index++, dto.getBusinessType()); // Ƌ敪
		setParam(index++, dto.getCalendarType()); // J_[敪
		setParam(index++, dto.getEffortType()); // ʗ敪
		setParam(index++, dto.getGrade()); // 
		setParam(index++, dto.getNotch()); // 
		setParam(index++, dto.getBasicSalary()); // {
		setParam(index++, dto.getAbilityAllowance()); // E\蓖
		setParam(index++, dto.getAbilityAllowance2()); // E\蓖2
		setParam(index++, dto.getPaymentType()); // x敪
		setParam(index++, dto.getOvertimeType()); // cƋ敪
		setParam(index++, dto.getPaidHolidayType()); // L敪
		setParam(index++, dto.getPaidHolidayMonth()); // LxɋNZ
		setCommonParams(isInsert);
	}
	
}
