/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.mospcommon.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.mospcommon.system.dto.CmAgreementWorkOnDto;

/**
 * @author matsusita
 *
 */
public class WorkOnHolidayAgreementListVo extends MosPVo {
	
	private static final long	serialVersionUID		= 1628399132471374488L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		SEARCH_OFF				= 0;
	/**
	 * 
	 */
	public static final int		SEARCH_ON				= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_TXT_WORK_ON_CODE	= "txtWorkOnCode";
	/**
	 * 
	 */
	public static final String	PRM_TXT_WORK_TYPE_NAME	= "txtWorkTypeName";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE			= "pltDelete";
	
	// tB[h
	private String[]			aryWorkOnId;
	private String[]			aryWorkOnCode;
	private String[]			aryWorkTypeName;
	private String[]			aryStartDate;
	private String[]			aryDelete;
	private String				txtWorkOnCode;
	private String				txtWorkTypeName;
	private String				pltDelete;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_WORK_ON_CODE;
	/**
	 * 
	 */
	public String				NAM_WORK_TYPE_NAME;
	/**
	 * 
	 */
	public String				NAM_START_DATE;
	/**
	 * 
	 */
	public String				NAM_DELETE;
	/**
	 * 
	 */
	public int					LEN_WORK_ON_CODE;
	/**
	 * 
	 */
	public int					LEN_WORK_TYPE_NAME;
	
	// \[gL[
	/**
	 * 
	 */
	public final String			KEY_WORK_ON_CODE		= "keyWorkOnCode";
	/**
	 * 
	 */
	public final String			KEY_WORK_TYPE_NAME		= "keyWorkTypeName";
	/**
	 * 
	 */
	public final String			KEY_START_DATE			= "keyStartDate";
	/**
	 * 
	 */
	public final String			KEY_DELETE				= "keyDelete";
	
	// [h(0FȂA1F)
	private int					searchmode;
	

	/**
	 * RXgN^
	 */
	public WorkOnHolidayAgreementListVo() {
		super();
		setViewPath(getClassName());
		aryWorkOnId = new String[0];
		aryWorkOnCode = new String[0];
		aryWorkTypeName = new String[0];
		aryStartDate = new String[0];
		aryDelete = new String[0];
		setFormerKey(KEY_WORK_ON_CODE);
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_WORK_ON_HOLIDAY_AGREEMENT;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuLaborAgreement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_WORK_ON_CODE = CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_AGREEMENT + CommonConst.NAM_COMMON_CODE;
		NAM_WORK_TYPE_NAME = CommonConst.NAM_WORK_TYPE_NAME;
		NAM_START_DATE = CommonConst.NAM_START_DATE;
		NAM_DELETE = CommonConst.NAM_DELETE_FLAG;
		LEN_WORK_ON_CODE = 10;
		LEN_WORK_TYPE_NAME = 50;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		txtWorkOnCode = request.getParameter(PRM_TXT_WORK_ON_CODE);
		txtWorkTypeName = request.getParameter(PRM_TXT_WORK_TYPE_NAME);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	@Override
	public void setFields(List<?> listAgreement) throws MospException {
		// Xg̐ݒ
		list = listAgreement;
		// f[^̎擾
		count = listAgreement.size();
		// z̏
		aryWorkOnId = new String[count];
		aryWorkOnCode = new String[count];
		aryWorkTypeName = new String[count];
		aryStartDate = new String[count];
		aryDelete = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listAgreement.iterator();
		while (it.hasNext()) {
			CmAgreementWorkOnDto dto = (CmAgreementWorkOnDto)it.next();
			aryWorkOnId[i] = escapeHTML(String.valueOf(dto.getWorkOnId()));
			aryWorkOnCode[i] = escapeHTML(dto.getWorkOnCode());
			aryWorkTypeName[i] = escapeHTML(dto.getWorkTypeName());
			aryStartDate[i] = escapeHTML(DateUtil.convDateFormatted(dto.getStartDate()));
			if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_OFF) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_OFF_NAME);
			} else if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_ON) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_ON_NAME);
			} else {
				throw new MospException(MospConst.EX_CM_USER_ILLEGAL);
			}
			i++;
		}
	}
	
	// ANZT\bh
	/**
	 * @return aryWorkOnId;
	 */
	public String[] getEscAryWorkOnId() {
		return aryWorkOnId.clone();
	}
	
	/**
	 * @return aryWorkOnCode
	 */
	public String[] getEscAryWorkOnCode() {
		return aryWorkOnCode.clone();
	}
	
	/**
	 * @return aryWorkTypeName
	 */
	public String[] getEscAryWorkTypeName() {
		return aryWorkTypeName.clone();
	}
	
	/**
	 * @return aryStartDate
	 */
	public String[] getEscAryStartDate() {
		return aryStartDate.clone();
	}
	
	/**
	 * @return aryDelete
	 */
	public String[] getEscAryDelete() {
		return aryDelete.clone();
	}
	
	/**
	 * @return txtWorkOnCode
	 */
	public String getTxtWorkOnCode() {
		return txtWorkOnCode;
	}
	
	/**
	 * @return txtWorkTypeName
	 */
	public String getTxtWorkTypeName() {
		return txtWorkTypeName;
	}
	
	/**
	 * @return pltDelete
	 */
	public String getPltDelete() {
		return pltDelete;
	}
	
	/**
	 * @return txtWorkOnCode
	 */
	public String getEscTxtWorkOnCode() {
		return escapeHTML(txtWorkOnCode);
	}
	
	/**
	 * @return txtWorkTypeName
	 */
	public String getEscTxtWorkTypeName() {
		return escapeHTML(txtWorkTypeName);
	}
	
	/**
	 * @param pltDelete Zbg pltDelete
	 */
	public void setPltDelete(int pltDelete) {
		this.pltDelete = String.valueOf(pltDelete);
	}
	
	/**
	 * 
	 * @param searchmode Zbg searchmode
	 */
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	/**
	 * @return searchmode
	 */
	public int getSearchmode() {
		return searchmode;
	}
	
}
