/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.cloudzero.mosp.exception.CloudzeroUnsupportedException;
import jp.getset.gae.bigtable.PreparedStatement;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.dao.MKihonDao;
import jp.mosp.kintai.payroll.dto.KdSubstituteHolidayDto;

/**
 * KD_SUBSTITUTE_HOLIDAY(֋xɊǗe[u)DAONX B
 */
public class KdSubstituteHolidayDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * KD_SUBSTITUTE_HOLIDAY(֋xɊǗe[u)B
	 */
	public static final String	TABLE							= "KD_SUBSTITUTE_HOLIDAY";
	
	/**
	 * KEY_1 = SUBSTITUTE_ID(ǗID)B
	 */
	public static final String	KEY_1							= "SUBSTITUTE_ID";
	
	// 
	/**
	 * SUBSTITUTE_ID(ǗID)B
	 */
	public static final String	COL_SUBSTITUTE_ID				= "SUBSTITUTE_ID";
	/**
	 * K_CODE(ЈR[h)B
	 */
	public static final String	COL_K_CODE						= "K_CODE";
	/**
	 * OCCUR_YEAR(N)B
	 */
	public static final String	COL_OCCUR_YEAR					= "OCCUR_YEAR";
	/**
	 * OCCUR_MONTH()B
	 */
	public static final String	COL_OCCUR_MONTH					= "OCCUR_MONTH";
	/**
	 * CLOSE_DATE(ؓ)B
	 */
	public static final String	COL_CLOSE_DATE					= "CLOSE_DATE";
	/**
	 * LIMIT_START_DATE(Jn)B
	 */
	public static final String	COL_LIMIT_START_DATE			= "LIMIT_START_DATE";
	/**
	 * LIMIT_END_DATE(I)B
	 */
	public static final String	COL_LIMIT_END_DATE				= "LIMIT_END_DATE";
	/**
	 * ATTITUDE_STATUS(ӌ)B
	 */
	public static final String	COL_ATTITUDE_STATUS				= "ATTITUDE_STATUS";
	/**
	 * PAYMENT_ACQUIRE_TIME(֋xɎ擾ԊO)B
	 */
	public static final String	COL_PAYMENT_ACQUIRE_TIME		= "PAYMENT_ACQUIRE_TIME";
	/**
	 * PAYMENT_ACQUIRE_HOLIDAY(֋xɎ擾xԊO)B
	 */
	public static final String	COL_PAYMENT_ACQUIRE_HOLIDAY		= "PAYMENT_ACQUIRE_HOLIDAY";
	/**
	 * PAYMENT_QUIT_TIME(֋xɕԊO)B
	 */
	public static final String	COL_PAYMENT_QUIT_TIME			= "PAYMENT_QUIT_TIME";
	/**
	 * USE_HOLIDAY_TIME(p)B
	 */
	public static final String	COL_USE_HOLIDAY_TIME			= "USE_HOLIDAY_TIME";
	/**
	 * ACQUISITION_STATUS(擾)B
	 */
	public static final String	COL_ACQUISITION_STATUS			= "ACQUISITION_STATUS";
	/**
	 * LIQUIDATION_OVER_TIME(xςɂ鎞ԊOZ)B
	 */
	public static final String	COL_LIQUIDATION_OVER_TIME		= "LIQUIDATION_OVER_TIME";
	/**
	 * LIQUIDATION_WEEK_HOLIDAY(xςɂxԊOZ)B
	 */
	public static final String	COL_LIQUIDATION_WEEK_HOLIDAY	= "LIQUIDATION_WEEK_HOLIDAY";
	/**
	 * DECISION_STATUS(Ϗ)B
	 */
	public static final String	COL_DECISION_STATUS				= "DECISION_STATUS";
	/**
	 * DELETE_FLAG(폜tO)B
	 */
	public static final String	COL_DELETE_FLAG					= "DELETE_FLAG";
	

	/**
	 * RXgN^B
	 */
	public KdSubstituteHolidayDao() {
		super();
		INSERT_DATE = "INSERT_DATE";
		INSERT_USER = "INSERT_USER";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
	/**
	 * ʎ擾(DTOList)B
	 * @return ʃXg
	 * @throws SQLException 	SQLOꍇ
	 */
	private List<KdSubstituteHolidayDto> mappingAll() throws SQLException {
		List<KdSubstituteHolidayDto> all = new ArrayList<KdSubstituteHolidayDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)B
	 * @return KD_SUBSTITUTE_HOLIDAYR[h
	 * @throws SQLException 	SQLOꍇ
	 */
	private KdSubstituteHolidayDto mapping() throws SQLException {
		KdSubstituteHolidayDto dto = new KdSubstituteHolidayDto();
		dto.setSubstituteId(rs.getLong(COL_SUBSTITUTE_ID));
		dto.setKCode(rs.getString(COL_K_CODE));
		dto.setOccurYear(rs.getInt(COL_OCCUR_YEAR));
		dto.setOccurMonth(rs.getInt(COL_OCCUR_MONTH));
		dto.setCloseDate(rs.getDate(COL_CLOSE_DATE));
		dto.setLimitStartDate(rs.getDate(COL_LIMIT_START_DATE));
		dto.setLimitEndDate(rs.getDate(COL_LIMIT_END_DATE));
		dto.setAttitudeStatus(rs.getString(COL_ATTITUDE_STATUS));
		dto.setPaymentAcquireTime(rs.getInt(COL_PAYMENT_ACQUIRE_TIME));
		dto.setPaymentAcquireHoliday(rs.getInt(COL_PAYMENT_ACQUIRE_HOLIDAY));
		dto.setPaymentQuitTime(rs.getInt(COL_PAYMENT_QUIT_TIME));
		dto.setUseHolidayTime(rs.getInt(COL_USE_HOLIDAY_TIME));
		dto.setAcquisitionStatus(rs.getString(COL_ACQUISITION_STATUS));
		dto.setLiquidationOverTime(rs.getInt(COL_LIQUIDATION_OVER_TIME));
		dto.setLiquidationWeekHoliday(rs.getInt(COL_LIQUIDATION_WEEK_HOLIDAY));
		dto.setDecisionStatus(rs.getString(COL_DECISION_STATUS));
		dto.setDeleteFlag(rs.getInt(COL_DELETE_FLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾B
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KdSubstituteHolidayDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾B
	 * @param substituteId ǗID
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public KdSubstituteHolidayDto findForKey(long substituteId) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, substituteId);
			executeQuery();
			KdSubstituteHolidayDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾B
	 * @param substituteId ǗID
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public KdSubstituteHolidayDto findForUpdate(long substituteId) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, substituteId);
			executeQuery();
			KdSubstituteHolidayDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param substituteId ǗID
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KdSubstituteHolidayDto> findForCondition(long substituteId) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_SUBSTITUTE_ID);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_SUBSTITUTE_ID, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, substituteId);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param occurYear N
	 * @param occurMonth 
	 * @param decisionStatus Ϗ
	 * @param date N
	 * @return (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<KdSubstituteHolidayDto> findForCondition(int occurYear, int occurMonth, String decisionStatus, Date date)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_OCCUR_YEAR);
			sb.append(" = ? AND ");
			sb.append(COL_OCCUR_MONTH);
			sb.append(" = ? AND ");
			sb.append(COL_DECISION_STATUS);
			sb.append(" = ? AND ");
			sb.append(COL_CLOSE_DATE);
			sb.append(" < ?");
			
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_OCCUR_YEAR, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_OCCUR_MONTH, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_DECISION_STATUS, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_CLOSE_DATE, Query.FilterOperator.LESS_THAN);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, occurYear);
			setParam(index++, occurMonth);
			setParam(index++, decisionStatus);
			setParam(index++, date);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param limitEndDate I
	 * @param decisionStatus Ϗ
	 * @return (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<KdSubstituteHolidayDto> findForCondition(Date limitEndDate, String decisionStatus) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_LIMIT_END_DATE);
			sb.append(" < ? AND ");
			sb.append(COL_DECISION_STATUS);
			sb.append(" = ? ");
			
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_LIMIT_END_DATE, Query.FilterOperator.LESS_THAN);
			this.pob.appendWhere(COL_DECISION_STATUS, Query.FilterOperator.EQUAL);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, limitEndDate);
			setParam(index++, decisionStatus);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param startDate ԊJn
	 * @param endDate ԏI
	 * @param decisionStatus Ϗ
	 * @return (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<KdSubstituteHolidayDto> findForCondition(Date startDate, Date endDate, String decisionStatus)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_LIMIT_END_DATE);
			sb.append(" >= ? ");
			sb.append("AND ");
			sb.append(COL_LIMIT_END_DATE);
			sb.append(" <= ?");
			sb.append("AND ");
			sb.append(COL_DECISION_STATUS);
			sb.append(" = ? ");
			
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_LIMIT_END_DATE, Query.FilterOperator.GREATER_THAN_OR_EQUAL);
			this.pob.appendWhere(COL_LIMIT_END_DATE, Query.FilterOperator.LESS_THAN_OR_EQUAL);
			this.pob.appendWhere(COL_DECISION_STATUS, Query.FilterOperator.EQUAL);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, startDate);
			setParam(index++, endDate);
			setParam(index++, decisionStatus);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param kCode ЈR[h
	 * @param occurYear N
	 * @param occurMonth 
	 * @return (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public KdSubstituteHolidayDto findForOccurMonth(String kCode, int occurYear, int occurMonth) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_K_CODE);
			sb.append(" = ? AND ");
			sb.append(COL_OCCUR_YEAR);
			sb.append(" = ? AND ");
			sb.append(COL_OCCUR_MONTH);
			sb.append(" = ? ");
			
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_OCCUR_YEAR, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_OCCUR_MONTH, Query.FilterOperator.EQUAL);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, occurYear);
			setParam(index++, occurMonth);
			executeQuery();
			KdSubstituteHolidayDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param kCode ЈR[h
	 * @param occurYear N
	 * @param occurMonth 
	 * @param acquisitionStatus 擾
	 * @param decisionStatus Ϗ
	 * @return (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public KdSubstituteHolidayDto findForOccurMonth(String kCode, int occurYear, int occurMonth,
			String acquisitionStatus, String decisionStatus) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_K_CODE);
			sb.append(" = ? AND ");
			sb.append(COL_OCCUR_YEAR);
			sb.append(" = ? AND ");
			sb.append(COL_OCCUR_MONTH);
			sb.append(" = ? AND ");
			sb.append(COL_ACQUISITION_STATUS);
			sb.append(" = ? AND ");
			sb.append(COL_DECISION_STATUS);
			sb.append(" = ? ");
			
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_OCCUR_YEAR, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_OCCUR_MONTH, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_ACQUISITION_STATUS, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_DECISION_STATUS, Query.FilterOperator.EQUAL);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, occurYear);
			setParam(index++, occurMonth);
			setParam(index++, acquisitionStatus);
			setParam(index++, decisionStatus);
			executeQuery();
			KdSubstituteHolidayDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param occurYear N
	 * @param occurMonth 
	 * @param acquisition 擾
	 * @return (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<KdSubstituteHolidayDto> findForOccurMonth(int occurYear, int occurMonth, String acquisition)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_OCCUR_YEAR);
			sb.append(" = ?");
			sb.append(" AND ");
			sb.append(COL_OCCUR_MONTH);
			sb.append(" = ?");
			sb.append(" AND ");
			sb.append(COL_ACQUISITION_STATUS);
			sb.append(" = ?");
			
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_OCCUR_YEAR, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_OCCUR_MONTH, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_ACQUISITION_STATUS, Query.FilterOperator.EQUAL);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, occurYear);
			setParam(index++, occurMonth);
			setParam(index++, acquisition);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param kCode ЈR[h
	 * @param closeDate N
	 * @return (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public KdSubstituteHolidayDto findForCloseDate(String kCode, Date closeDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_K_CODE);
			sb.append(" = ? AND ");
			sb.append(COL_CLOSE_DATE);
			sb.append(" >= ? ");
			sb.append(getOrderBy());
			sb.append(COL_CLOSE_DATE);
			sb.append(" ");
			sb.append(getDesc());
			sb.append(getLimit());
			sb.append("1");
			
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			this.pob.appendWhere(COL_CLOSE_DATE, Query.FilterOperator.GREATER_THAN_OR_EQUAL);
			this.pob.appendSort(COL_CLOSE_DATE, Query.SortDirection.DESCENDING);
			this.pob.setLimit(1);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, closeDate);
			executeQuery();
			KdSubstituteHolidayDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param kCode ЈR[h
	 * @param targetDate Ώ۔N
	 * @param acquisition 擾
	 * @param decision Ϗ
	 * @return (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<KdSubstituteHolidayDto> findForTargetDate(String kCode, Date targetDate, String acquisition,
			String decision) throws SQLException, IllegalAccessException, NoSuchFieldException {
		throw new CloudzeroUnsupportedException("2d\[gΉĂ邩H");
/*		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_K_CODE);
			sb.append(" = ?");
			this.pob.appendWhere(COL_DELETE_FLAG, Query.FilterOperator.EQUAL, MospConst.DELETE_FLAG_OFF);
			this.pob.appendWhere(COL_K_CODE, Query.FilterOperator.EQUAL);
			if (acquisition.length() != 0) {
				sb.append(" AND ");
				sb.append(COL_ACQUISITION_STATUS);
				sb.append(" = ?");
				this.pob.appendWhere(COL_ACQUISITION_STATUS, Query.FilterOperator.EQUAL);
			}
			if (decision.length() != 0) {
				sb.append(" AND ");
				sb.append(COL_DECISION_STATUS);
				sb.append(" = ?");
				this.pob.appendWhere(COL_DECISION_STATUS, Query.FilterOperator.EQUAL);
			}
			sb.append(" AND ");
			sb.append(COL_LIMIT_START_DATE);
			sb.append(" <= ? ");
			sb.append(" AND ");
			sb.append(COL_LIMIT_END_DATE);
			sb.append(" >= ? ");
			sb.append(getOrderBy());
			sb.append(COL_OCCUR_YEAR);
			sb.append(",");
			sb.append(COL_OCCUR_MONTH);
			
//			this.pob.appendWhere(COL_LIMIT_START_DATE, Query.FilterOperator.LESS_THAN_OR_EQUAL);
//			this.pob.appendWhere(COL_LIMIT_END_DATE, Query.FilterOperator.GREATER_THAN_OR_EQUAL);
// 2d\[g
//			this.pob.appendSort(COL_OCCUR_YEAR);
//			this.pob.appendSort(COL_OCCUR_MONTH);
			
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			if (acquisition.length() != 0) {
				setParam(index++, acquisition);
			}
			if (decision.length() != 0) {
				setParam(index++, decision);
			}
			setParam(index++, targetDate);
			setParam(index++, targetDate);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * ɂf[^擾B
	 * @param kCode ЈR[h
	 * @param kName Ј
	 * @param occurYear N
	 * @param occurMonth 
	 * @param attitude ӌ
	 * @param acquisition 擾
	 * @param decision Ϗ
	 * @return (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public List<KdSubstituteHolidayDto> findForTargetDate(String kCode, String kName, String occurYear,
			String occurMonth, String attitude, String acquisition, String decision) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = ");
			sb.append(MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			/* ЈR[hݒ 
			sb.append(COL_K_CODE + " LIKE ? ");
			/* Јݒ 
			sb.append(" AND ");
			sb.append(" ( ");
			sb.append(COL_K_CODE + " IN (" + MKihonDao.getSearchKNameSubQuery() + ") ");
			sb.append(" ) ");
			/* Nݒ 
			if (occurYear.length() != 0) {
				sb.append(" AND ");
				sb.append(COL_OCCUR_YEAR);
				sb.append(" = ?");
			}
			/* ݒ 
			if (occurMonth.length() != 0) {
				sb.append(" AND ");
				sb.append(COL_OCCUR_MONTH);
				sb.append(" = ?");
			}
			/* ӌ󋵐ݒ 
			if (attitude.length() != 0) {
				sb.append(" AND ");
				sb.append(COL_ATTITUDE_STATUS);
				sb.append(" = ?");
			}
			/* 擾󋵐ݒ 
			if (acquisition.length() != 0) {
				sb.append(" AND ");
				sb.append(COL_ACQUISITION_STATUS);
				sb.append(" = ?");
			}
			/* Ϗ󋵐ݒ 
			if (decision.length() != 0) {
				sb.append(" AND ");
				sb.append(COL_DECISION_STATUS);
				sb.append(" = ?");
			}
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode + "%");
			setParam(index++, "%" + kName + "%");
			if (occurYear.length() != 0) {
				setParam(index++, Integer.parseInt(occurYear));
			}
			if (occurMonth.length() != 0) {
				setParam(index++, Integer.parseInt(occurMonth));
			}
			if (attitude.length() != 0) {
				setParam(index++, attitude);
			}
			if (acquisition.length() != 0) {
				setParam(index++, acquisition);
			}
			if (decision.length() != 0) {
				setParam(index++, decision);
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * maxl擾
	 * @return String őA
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException tB[hȂꍇ
	 */
	public String findForMax() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			String max = "";
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT MAX(");
			sb.append(COL_SUBSTITUTE_ID);
			sb.append(") FROM ");
			sb.append(TABLE);
			
			this.setPreparedStatement(PreparedStatement.Mode.SELECT);
			this.pob.appendOperationMax(COL_SUBSTITUTE_ID);
			
			prepareStatement(sb.toString());
			executeQuery();
			if (rs.next()) {
				max = String.valueOf(rs.getLong(1));
			}
			return max;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}B
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(KdSubstituteHolidayDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XVB
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(KdSubstituteHolidayDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getSubstituteId());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜B
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(KdSubstituteHolidayDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getSubstituteId());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒB
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseF})
	 * @throws SQLException 	SQLOꍇ
	 */
	private void setParams(KdSubstituteHolidayDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getSubstituteId());
		setParam(index++, dto.getKCode());
		setParam(index++, dto.getOccurYear());
		setParam(index++, dto.getOccurMonth());
		setParam(index++, dto.getCloseDate());
		setParam(index++, dto.getLimitStartDate());
		setParam(index++, dto.getLimitEndDate());
		setParam(index++, dto.getAttitudeStatus());
		setParam(index++, dto.getPaymentAcquireTime());
		setParam(index++, dto.getPaymentAcquireHoliday());
		setParam(index++, dto.getPaymentQuitTime());
		setParam(index++, dto.getUseHolidayTime());
		setParam(index++, dto.getAcquisitionStatus());
		setParam(index++, dto.getLiquidationOverTime());
		setParam(index++, dto.getLiquidationWeekHoliday());
		setParam(index++, dto.getDecisionStatus());
		setParam(index++, dto.getDeleteFlag());
		setCommonParams(isInsert);
	}
	
}
