/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;

/**
 * @author yoshida
 *
 */
public abstract class MosPWorkFlowVo extends MosPVo {
	
	private static final long	serialVersionUID	= -1733626895330281082L;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_HID_VOUCHER		= "hidVoucher";
	/**
	 * 
	 */
	public static final String	PRM_TXT_COMMENT		= "txtComment";
	
	// tB[h
	private String				hidVoucher;
	private String				txtComment;
	
	private String[][]			aryComments;
	private String				lblComment;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_CHANGE_COMMENT;
	/**
	 * 
	 */
	public String				NAM_AUTHOR_COMMENT;
	/**
	 * 
	 */
	public int					LEN_COMMENT;
	

	/**
	 * RXgN^
	 */
	public MosPWorkFlowVo() {
		super();
		hidVoucher = "";
		txtComment = "";
		aryComments = new String[0][0];
	}
	
	@Override
	protected void setFieldsName() {
		NAM_CHANGE_COMMENT = CommonConst.NAM_CHANGING + CommonConst.NAM_COMMENT;
		NAM_AUTHOR_COMMENT = CommonConst.NAM_APPROVER + CommonConst.MSG_FROM + CommonConst.MSG_OF
				+ CommonConst.NAM_COMMENT;
		LEN_COMMENT = 20;
	}
	
	/**
	 * p[^ݒ
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		hidVoucher = request.getParameter(PRM_HID_VOUCHER);
		txtComment = request.getParameter(PRM_TXT_COMMENT);
	}
	
	/**
	 * ߃Rgꗗ
	 * @param aryComments	Rgz
	 */
	public void setCommentFields(String[][] aryComments) {
		for (int i = 0; i < aryComments.length; i++) {
			aryComments[i][0] = escapeHTML(aryComments[i][0]);
			aryComments[i][1] = escapeHTML(aryComments[i][1]);
		}
		this.aryComments = aryComments.clone();
	}
	
	// ANZT\bh
	/**
	 * @return hidVoucher
	 */
	public String getHidVoucher() {
		return hidVoucher;
	}
	
	/**
	 * @return hidVoucher
	 */
	public String getEscHidVoucher() {
		return escapeHTML(hidVoucher);
	}
	
	/**
	 * @param hidVoucher `[ԍ
	 */
	public void setHidVoucher(String hidVoucher) {
		this.hidVoucher = hidVoucher;
	}
	
	/**
	 * @return txtComment
	 */
	public String getTxtComment() {
		return txtComment;
	}
	
	/**
	 * @return txtComment
	 */
	public String getEscTxtComment() {
		return escapeHTML(txtComment);
	}
	
	/**
	 * @param txtComment Rg
	 */
	public void setTxtComment(String txtComment) {
		this.txtComment = txtComment;
	}
	
	/**
	 * @return aryComments
	 */
	public String[][] getEscAryComments() {
		return aryComments.clone();
	}
	
	/**
	 * @return lblComment
	 */
	public String getEscLblComment() {
		return escapeHTML(lblComment);
	}
	
	/**
	 * @param lblComment Rg
	 */
	public void setLblComment(String lblComment) {
		this.lblComment = lblComment;
	}
	
}
