/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.part;

import java.util.Calendar;
import java.util.Date;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.BasePart;
import jp.mosp.common.part.PartInfo;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.NumberUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.payroll.dao.MKintaiKeisanDao;
import jp.mosp.payroll.dto.MKintaiKeisanDto;

/**
 * ΑӌvZɊւPartNX
 * @author yoshida
 *	@version	0.0.2
 */
public class CalculatePart extends BasePart {
	
	/**
	 * RXgN^
	 */
	public CalculatePart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo 	Part𗘗pۂɕKvȏ
	 */
	public CalculatePart(PartInfo partInfo) {
		super(partInfo);
	}
	

	private MKintaiKeisanDao	keisanDao;
	

	/**
	 * M_KINTAIKEISANe[upDAO擾
	 * @return	ςMKintaiKeisanDaoCX^X
	 * @throws Exception Oꍇ
	 */
	public MKintaiKeisanDao getKeisanDao() throws Exception {
		if (VariousUtil.isNull(keisanDao)) {
			keisanDao = (MKintaiKeisanDao)getPreparedDao(MKintaiKeisanDao.class.getCanonicalName());
		}
		return keisanDao;
	}
	
	/**
	 * ΑӌvZ擾
	 * @return	ΑӌvZDTO
	 * @throws Exception Oꍇ
	 */
	public MKintaiKeisanDto findForCalc() throws Exception {
		return getKeisanDao().findForCalc();
	}
	
	/**
	 * ΑӒ擾
	 * @return	Date	Ώ۔N
	 * @throws Exception Oꍇ
	 */
	public Date getCalcMonth() throws Exception {
		MKintaiKeisanDto dto = findForCalc();
		// Ώ۔Nl擾
		Date targetDate = DateUtil.getSystemDate();
		if (dto != null) {
			int closeDay = getCloseDay();
			if (closeDay == 0) {
				closeDay = 1;
			}
			targetDate = DateUtil.getDate(dto.getKTNen(), dto.getKTTuki(), closeDay);
		}
		return targetDate;
	}
	
	/**
	 * ΑӌvZ擾
	 * @return yyyymm vZN
	 * @throws Exception Oꍇ
	 */
	public Date getCalcAttendance() throws Exception {
		// Ώ۔N擾
		Date targetDate = getCalcMonth();
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// ߓ擾
		int minusMonth = getMinusMonth();
		int closeDay = getCloseDay();
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.roll(Calendar.MONTH, minusMonth * -1);
		if (closeDay != 0) {
			cal.roll(Calendar.MONTH, 1);
			cal.set(Calendar.DAY_OF_MONTH, closeDay);
		}
		return cal.getTime();
	}
	
	/**
	 * ^xΏ۔N擾
	 * @param targetDate Ώۓ
	 * @return	iΑӏWvji^xj
	 * @throws Exception Oꍇ
	 */
	public Date getCalcPayment(Date targetDate) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// x擾
		int plusMonth = Integer.parseInt(part().mospcode().findTchange(CommonConst.TID_PROVIDED_DATE,
				CommonConst.TCD_MONTH));
		int providedDay = Integer.parseInt(part().mospcode().findTchange(CommonConst.TID_PROVIDED_DATE,
				CommonConst.TCD_DAYS));
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.roll(Calendar.MONTH, plusMonth * 1);
		// 1̏ꍇAxɂėN擾
		if ((cal.get(Calendar.MONTH) == 0) && plusMonth != 0) {
			cal.roll(Calendar.YEAR, 1);
		}
		if (providedDay != 0) {
			cal.set(Calendar.DAY_OF_MONTH, providedDay);
		}
		return cal.getTime();
	}
	
	/**
	 * ^x擾
	 * @return	Date	Ώ۔N
	 * @throws Exception Oꍇ
	 */
	public Date getCalcPayment() throws Exception {
		MKintaiKeisanDto dto = findForCalc();
		// Ώ۔Nl擾
		Date targetDate = getCalcPayment(DateUtil.getSystemDate());
		if (VariousUtil.chkExistDto(dto)) {
			targetDate = DateUtil.getDate(dto.getKSNen(), dto.getKSTuki(), dto.getKShi());
		}
		return targetDate;
	}
	
	/**
	 * WvJn擾
	 * @param targetMonth Ώی
	 * @return WvJn
	 * @throws Exception Oꍇ
	 */
	public Date getStartDate(Date targetMonth) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetMonth);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// ߓ擾
		int minusMonth = getMinusMonth();
		int closeDay = getCloseDay();
		cal.set(Calendar.DAY_OF_MONTH, 1);
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		cal.add(Calendar.MONTH, minusMonth * -1);
		// WvJnvZ
		if (closeDay != 0) {
			if (MospUtility.getDay(targetMonth) <= closeDay) {
				cal.add(Calendar.MONTH, -1);
			}
			cal.set(Calendar.DAY_OF_MONTH, closeDay);
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		return cal.getTime();
	}
	
	/**
	 * WvI擾
	 * @param targetMonth Ώی
	 * @return WvI
	 * @throws Exception Oꍇ
	 */
	public Date getEndDate(Date targetMonth) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		// ߓ擾
		int closeDay = getCloseDay();
		// Jn擾
		cal.setTime(getStartDate(targetMonth));
		// ꃖZ
		cal.add(Calendar.MONTH, 1);
		if (closeDay != 0) {
			// w
			cal.roll(Calendar.DAY_OF_MONTH, -1);
		} else {
			// 
			cal.add(Calendar.MONTH, -1);
			// Ώی̍ŏIZbg
			cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
		}
		return cal.getTime();
	}
	
	/**
	 * Wv擾
	 * @param targetDate Ώۓ
	 * @return Wv
	 * @throws Exception Oꍇ
	 */
	public Date getCalcAttendanceMonth(Date targetDate) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// ߓ擾
		int minusMonth = getMinusMonth();
		int closeDay = getCloseDay();
		// Wv擾
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.roll(Calendar.MONTH, minusMonth * 1);
		if (closeDay != 0) {
			if (MospUtility.getDay(targetDate) > closeDay) {
				cal.roll(Calendar.MONTH, 1);
			}
		}
		return cal.getTime();
	}
	
	/**
	 * \pJnN
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param targetDate	Ώ۔N	
	 * @return \pJnN
	 * @throws Exception Oꍇ
	 */
	public Date getStartDateForList(Date targetDate) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetDate);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		// ߓ擾
		int closeDay = getCloseDay();
		// WvJnvZ
		if (closeDay != 0) {
			if (MospUtility.getDay(targetDate) <= closeDay) {
				cal.add(Calendar.MONTH, -1);
			}
			cal.set(Calendar.DAY_OF_MONTH, closeDay);
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		return cal.getTime();
	}
	
	/**
	 * \pIN
	 * <p>2009/01/20	m.yoshida	ǉ</p>
	 * @param targetDate	Ώ۔N
	 * @return \pJnN
	 * @throws Exception Oꍇ
	 */
	public Date getEndDateForList(Date targetDate) throws Exception {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		// ߓ擾
		int closeDay = getCloseDay();
		// Jn擾
		cal.setTime(getStartDateForList(targetDate));
		// ꃖZ
		cal.add(Calendar.MONTH, 1);
		if (closeDay != 0) {
			// w
			cal.roll(Calendar.DAY_OF_MONTH, -1);
		} else {
			// 
			cal.add(Calendar.MONTH, -1);
			// Ώی̍ŏIZbg
			cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
		}
		return cal.getTime();
	}
	
	/**
	 * ΑӌvZIf
	 * @since	0.0.2
	 * @return
	 * <p>
	 * ΑӌvZĂꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception Oꍇ
	 */
	public boolean isCalculateFinish() throws Exception {
		return isCalculateFinish(findForCalc());
	}
	
	/**
	 * ΑӌvZIf
	 * @since	0.0.2
	 * @param dto	ΏDTO
	 * @return
	 * <p>
	 * ΑӌvZĂꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception Oꍇ
	 */
	public static boolean isCalculateFinish(MKintaiKeisanDto dto) throws Exception {
		if (VariousUtil.chkExistDto(dto) && CommonConst.NUM_ATTENDANCE_CALCULATE_FLAG_ON.equals(dto.getKKanryou())) {
			return true;
		}
		return false;
	}
	
	/**
	 * Ώ۔NΑӒߓf
	 * @since	0.0.2
	 * @param targetDate		Ώ۔N
	 * @return
	 * <p>
	 * Ώ۔NΑӒߓOȂtrueAłȂꍇfalse
	 * <p>
	 * @throws Exception Oꍇ
	 */
	public boolean isBeforeCalcMonth(Date targetDate) throws Exception {
		// ΑӒߓ
		Date calcMonth = getCalcMonth();
		// ΑӌvZI͗
		if (isCalculateFinish()) {
			calcMonth = DateUtil.addMonth(calcMonth, 1);
		}
		// ΑӏWvȌꍇ
		if (calcMonth.compareTo(targetDate) > 0) {
			return true;
		}
		return false;
	}
	
	/**
	 * ߓ擾
	 * @return	ߓ
	 * @throws Exception Oꍇ
	 */
	public int getCloseDay() throws Exception {
		return NumberUtil.getIntParam(part().mospcode().findTchange(CommonConst.TID_CALCULATION, CommonConst.TCD_DAYS));
	}
	
	/**
	 * ߌ擾
	 * @return	}CiX錎
	 * @throws Exception Oꍇ
	 */
	public int getMinusMonth() throws Exception {
		return NumberUtil
			.getIntParam(part().mospcode().findTchange(CommonConst.TID_CALCULATION, CommonConst.TCD_MONTH));
	}
	
}
