/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.google.appengine.api.datastore.Query;

import jp.cloudzero.mosp.exception.CloudzeroUnsupportedException;
import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.kintai.common.dto.MKihonDto;

/**
 * M_KIHON(Ј}X^[{)DAONX B
 */
public class MKihonDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * M_KIHON(Ј}X^[{)B
	 */
	public static final String	TABLE			= "M_KIHON";
	
	/**
	 * KEY_1 = KCODE(ЈR[h)B
	 */
	public static final String	KEY_1			= "KCODE";
	
	// 
	/**
	 * KCODE(ЈR[h)B
	 */
	public static final String	COL_KCODE		= "KCODE";
	/**
	 * SIMEI()B
	 */
	public static final String	COL_SIMEI		= "SIMEI";
	/**
	 * FURIGANA(ӂ肪)B
	 */
	public static final String	COL_FURIGANA	= "FURIGANA";
	/**
	 * SCODE(R[h)B
	 */
	public static final String	COL_SCODE		= "SCODE";
	/**
	 * YCODE(ER[h)B
	 */
	public static final String	COL_YCODE		= "YCODE";
	/**
	 * TOKYU()B
	 */
	public static final String	COL_TOKYU		= "TOKYU";
	/**
	 * JCODE(ƏR[h)B
	 */
	public static final String	COL_JCODE		= "JCODE";
	/**
	 * NYDATE(Г)B
	 */
	public static final String	COL_NYDATE		= "NYDATE";
	/**
	 * TSDATE(ސE)B
	 */
	public static final String	COL_TSDATE		= "TSDATE";
	/**
	 * KNKUBUN(xސE敪)B
	 */
	public static final String	COL_KNKUBUN		= "KNKUBUN";
	/**
	 * KYKUBUN(^敪)B
	 */
	public static final String	COL_KYKUBUN		= "KYKUBUN";
	/**
	 * TXKUBUN(ŋ敪)B
	 */
	public static final String	COL_TXKUBUN		= "TXKUBUN";
	/**
	 * TXKUBUNX(̑ŋ敪)B
	 */
	public static final String	COL_TXKUBUNX	= "TXKUBUNX";
	/**
	 * KMKUBUN(g敪)B
	 */
	public static final String	COL_KMKUBUN		= "KMKUBUN";
	/**
	 * PTKUBUN(p[g敪)B
	 */
	public static final String	COL_PTKUBUN		= "PTKUBUN";
	/**
	 * SHKUBUN(x敪)B
	 */
	public static final String	COL_SHKUBUN		= "SHKUBUN";
	/**
	 * SIWAKECD(dWvR[h)B
	 */
	public static final String	COL_SIWAKECD	= "SIWAKECD";
	/**
	 * HAIGUSYA(}{z)B
	 */
	public static final String	COL_HAIGUSYA	= "HAIGUSYA";
	/**
	 * FUYOSU(}{Ƒ)B
	 */
	public static final String	COL_FUYOSU		= "FUYOSU";
	/**
	 * YUKYU(Lc)B
	 */
	public static final String	COL_YUKYU		= "YUKYU";
	/**
	 * NENREI(N)B
	 */
	public static final String	COL_NENREI		= "NENREI";
	/**
	 * KINZOKU(ΑN)B
	 */
	public static final String	COL_KINZOKU		= "KINZOKU";
	/**
	 * KENPONO(۔ԍ)B
	 */
	public static final String	COL_KENPONO		= "KENPONO";
	/**
	 * KOHONO(۔ԍ)B
	 */
	public static final String	COL_KOHONO		= "KOHONO";
	/**
	 * KUSER([U)B
	 */
	public static final String	COL_KUSER		= "KUSER";
	/**
	 * PASSW(pX[h)B
	 */
	public static final String	COL_PASSW		= "PASSW";
	/**
	 * EMAIL(email)B
	 */
	public static final String	COL_EMAIL		= "EMAIL";
	/**
	 * NINSYO(F؎)B
	 */
	public static final String	COL_NINSYO		= "NINSYO";
	/**
	 * DATALVL(f[^x)B
	 */
	public static final String	COL_DATALVL		= "DATALVL";
	/**
	 * PROGLEVEL(vOgp)B
	 */
	public static final String	COL_PROGLEVEL	= "PROGLEVEL";
	

	/**
	 * RXgN^
	 */
	public MKihonDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	protected List<MKihonDto> mappingAll() throws SQLException {
		List<MKihonDto> all = new ArrayList<MKihonDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return m_kihonDto m_kihonR[h
	 * @throws SQLException SQLOꍇ
	 */
	private MKihonDto mapping() throws SQLException {
		MKihonDto dto = new MKihonDto();
		dto.setKCode(rs.getString(COL_KCODE)); //ЈR[h
		dto.setSimei(rs.getString(COL_SIMEI)); //
		dto.setFurigana(rs.getString(COL_FURIGANA)); //ӂ肪
		dto.setSCode(rs.getString(COL_SCODE)); //R[h
		dto.setYCode(rs.getString(COL_YCODE)); //ER[h
		dto.setTokyu(rs.getString(COL_TOKYU)); //
		dto.setJCode(rs.getString(COL_JCODE)); //ƏR[h
		dto.setNyDate(rs.getInt(COL_NYDATE)); //Г
		dto.setTsDate(rs.getInt(COL_TSDATE)); //ސE
		dto.setKnKubun(rs.getString(COL_KNKUBUN)); //xސE敪
		dto.setKyKubun(rs.getString(COL_KYKUBUN)); //^敪
		dto.setTxKubun(rs.getString(COL_TXKUBUN)); //ŋ敪
		dto.setTxKubunx(rs.getString(COL_TXKUBUNX)); //̑ŋ敪
		dto.setKmKubun(rs.getString(COL_KMKUBUN)); //g敪
		dto.setPtKubun(rs.getString(COL_PTKUBUN)); //p[g敪
		dto.setShKubun(rs.getString(COL_SHKUBUN)); //x敪
		dto.setSiwakeCd(rs.getString(COL_SIWAKECD)); //dWvR[h
		dto.setHaigusya(rs.getString(COL_HAIGUSYA)); //}{z
		dto.setFuyosu(rs.getInt(COL_FUYOSU)); //}{Ƒ
		dto.setYukyu(rs.getDouble(COL_YUKYU)); //Lc
		dto.setNenrei(rs.getInt(COL_NENREI)); //N
		dto.setKinzoku(rs.getInt(COL_KINZOKU)); //ΑN
		dto.setKenpoNo(rs.getString(COL_KENPONO)); //۔ԍ
		dto.setKohoNo(rs.getString(COL_KOHONO)); //۔ԍ
		dto.setKUser(rs.getString(COL_KUSER)); //[U
		dto.setPassw(rs.getString(COL_PASSW)); //pX[h
		dto.setEmail(rs.getString(COL_EMAIL)); //email
		dto.setNinsyo(rs.getString(COL_NINSYO)); //F؎
		dto.setDataLvl(rs.getInt(COL_DATALVL)); //f[^x
		dto.setProgLevel(rs.getInt(COL_PROGLEVEL)); //vOgp
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MKihonDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<MKihonDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param kcode ЈR[h(L[)
	 * @return m_kihonDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKihonDto findForKey(String kcode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kcode);
			executeQuery();
			MKihonDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @return m_kihonDto (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKihonDto findForUpdate(String kcode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kcode);
			executeQuery();
			MKihonDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findForCondition(String kcode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_KCODE, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode);
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param kcode 		ЈR[h
	 * @param simei 		Ј
	 * @param sCode			R[h
	 * @param selfJCode		[UƏR[h
	 * @param selfKCode		[UЈR[h
	 * @param dataLevel		f[^x
	 * @param startDate		Jn
	 * @param endDate 		I
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MKihonDto> findForCondition(String kcode, String simei, String sCode, String selfJCode,
			String selfKCode, int dataLevel, int startDate, int endDate) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(" ( ");
		sb.append(COL_KCODE + " LIKE ? ");
		sb.append(" AND ");
		sb.append(COL_SIMEI + " LIKE ? ");
		sb.append(" AND ");
		// Ə
		sb.append(COL_JCODE + " = ? ");
		// I
		if (!sCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SCODE + " IN (" + MSyozokuDao.getSectionQuery() + ") ");
		}
		sb.append(" AND ");
		// f[^xȉ̐l
		sb.append(COL_KCODE + " IN (" + MosPUserDao.getSearchDataLevelSubQuery() + ") ");
		sb.append(" AND ");
		// WvJnɍݐEĂl		
		sb.append(getSearchEmployeeStatementPeriod(false));
		sb.append(" ) ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kcode + "%");
			setParam(index++, "%" + simei + "%");
			// Ə
			setParam(index++, selfJCode);
			// 
			if (!sCode.equals("")) {
				setParam(index++, sCode);
			}
			// f[^x
			setParam(index++, dataLevel);
			// WvJn
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * ɂf[^擾
	 * @param sCode			R[h
	 * @param selfJCode		[UƏR[h
	 * @param selfKCode		[UЈR[h
	 * @param dataLevel		f[^x
	 * @param startDate		Jn
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MKihonDto> findForCondition(String sCode, String selfJCode, String selfKCode, int dataLevel,
			int startDate) throws SQLException, IllegalAccessException, NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		// 
		sb.append(COL_KCODE + " = ? ");
		sb.append(" OR ");
		sb.append(" ( ");
		// Ə
		sb.append(COL_JCODE + " = ? ");
		sb.append(" AND ");
		sb.append(COL_SCODE + " IN (" + MSyozokuDao.getSectionQuery() + ") ");
		sb.append(" AND ");
		// f[^xȉ̐l
		sb.append(COL_KCODE + " IN (" + MosPUserDao.getSearchDataLevelSubQuery() + ") ");
		sb.append(" AND ");
		// WvJnɍݐEĂl		
		sb.append(getSearchEmployeeStatement());
		sb.append(" ) ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			// 
			setParam(index++, selfKCode);
			// Ə
			setParam(index++, selfJCode);
			// 
			setParam(index++, sCode);
			// f[^x
			setParam(index++, dataLevel);
			// WvJn
			setParam(index++, startDate);
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * ɂf[^擾
	 * @param tsdate t
	 * @param kcode ЈR[h
	 * @param kname Ј
	 * @param scode R[h
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MKihonDto> findForCondition(int tsdate, String kcode, String kname, String scode) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(getSearchEmployeeStatement());
		if (!kcode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_KCODE);
			sb.append(" LIKE ? ");
		}
		if (!kname.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SIMEI);
			sb.append(" LIKE ? ");
		}
		if (!scode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SCODE);
			sb.append(" IN( ");
			sb.append(MSyozokuDao.getSectionQuery());
			sb.append(") ");
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, tsdate);
			if (!kcode.equals("")) {
				setParam(index++, kcode + "%");
			}
			if (!kname.equals("")) {
				setParam(index++, "%" + kname + "%");
			}
			if (!scode.equals("")) {
				setParam(index++, scode);
			}
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * ɂf[^擾
	 * @param jCode ƏR[h
	 * @param sCode R[h
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MKihonDto> findForCondition(String jCode, String sCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KNKUBUN);
		sb.append(" = '");
		sb.append(CommonConst.RETIREMENT_FLAG_OFF);
		sb.append("' AND ");
		sb.append(COL_JCODE);
		sb.append(" = ? AND ");
		sb.append(COL_SCODE);
		sb.append(" = ? ");
		this.pob.appendWhere(COL_KCODE, Query.FilterOperator.EQUAL, CommonConst.RETIREMENT_FLAG_OFF);
		this.pob.appendWhere(COL_JCODE, Query.FilterOperator.EQUAL);
		this.pob.appendWhere(COL_SCODE, Query.FilterOperator.EQUAL);
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, jCode);
			setParam(index++, sCode);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(R[h)
	 * @param stationCode R[h
	 * @param tsdate ގДN
	 * @param nydate ДN
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MKihonDto> findForSection(String stationCode, int tsdate, int nydate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		if (stationCode.length() != 0) {
			sb.append(COL_SCODE + " IN (");
			sb.append(MSyozokuDao.getSectionQuery());
			sb.append(") ");
			sb.append("AND ");
		}
		sb.append(getSearchEmployeeStatementPeriod(true));
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForPosition());
			if (stationCode.length() != 0) {
				setParam(index++, stationCode);
			}
			setParam(index++, tsdate);
			setParam(index++, nydate);
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * ɂf[^擾(l}X^ێ-Јꗗp)
	 * @param kCode          ЈR[h
	 * @param simei          Ј
	 * @param officeCode    ƏR[h
	 * @param sectionCode    R[h
	 * @param positionCode   EʃR[h
	 * @param retirementFlag ސEtO
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MKihonDto> findForHumanList(String kCode, String simei, String officeCode, String sectionCode,
			String positionCode, String retirementFlag) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_KCODE + " LIKE ? ");
		sb.append(" AND ");
		sb.append(COL_SIMEI + " LIKE ? ");
		this.pob.appendLike(COL_KCODE);
		this.pob.appendLike(COL_SIMEI);
		if (officeCode != null && !officeCode.equals("")) {
			sb.append("AND ");
			sb.append(COL_JCODE + " =  ? ");
			this.pob.appendWhere(COL_JCODE, Query.FilterOperator.EQUAL);
		}
		if (sectionCode != null && !sectionCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SCODE + " =  ? ");
			this.pob.appendWhere(COL_SCODE, Query.FilterOperator.EQUAL);
		}
		if (positionCode != null && !positionCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_YCODE + " = ? ");
			this.pob.appendWhere(COL_YCODE, Query.FilterOperator.EQUAL);
		}
		if (retirementFlag != null && retirementFlag.equals(String.valueOf(CommonConst.RETIREMENT_FLAG_OFF))) {
			sb.append(" AND ");
			sb.append(COL_KNKUBUN + " = '" + CommonConst.RETIREMENT_FLAG_OFF + "' ");
			this.pob.appendWhere(COL_KNKUBUN, Query.FilterOperator.EQUAL, CommonConst.RETIREMENT_FLAG_OFF);
		} else if (retirementFlag != null && retirementFlag.equals(String.valueOf(CommonConst.RETIREMENT_FLAG_LEAVE))) {
			sb.append(" AND ");
			sb.append(COL_KNKUBUN + " = '" + CommonConst.RETIREMENT_FLAG_LEAVE + "' ");
			this.pob.appendWhere(COL_KNKUBUN, Query.FilterOperator.EQUAL, CommonConst.RETIREMENT_FLAG_LEAVE);
		} else if (retirementFlag != null && retirementFlag.equals(String.valueOf(CommonConst.RETIREMENT_FLAG_ON))) {
			sb.append(" AND ");
			sb.append(COL_KNKUBUN + " = '" + CommonConst.RETIREMENT_FLAG_ON + "' ");
			this.pob.appendWhere(COL_KNKUBUN, Query.FilterOperator.EQUAL, CommonConst.RETIREMENT_FLAG_ON);
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode + "%");
			setParam(index++, "%" + simei + "%");
			if (officeCode != null && !officeCode.equals("")) {
				setParam(index++, officeCode);
			}
			if (sectionCode != null && !sectionCode.equals("")) {
				setParam(index++, sectionCode);
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			// s
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾(R[h)
	 * @param authCode1 R[h1
	 * @param authCode2 R[h2
	 * @param date N
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MKihonDto> findForAuth(String authCode1, String authCode2, int date) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_KCODE + " IN ( " + MosPUserDao.getSearchApprovalSubQuery() + " ) ");
		sb.append(" AND ");
		sb.append(getSearchEmployeeStatement());
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, authCode1);
			setParam(index++, authCode2);
			setParam(index++, date);
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * ɂf[^擾
	 * @param sCode			R[h
	 * @param selfJCode 	[UƏR[h 
	 * @param selfKCode		[UЈR[h
	 * @param dataLevel		f[^x
	 * @param startDate		Jn
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MKihonDto> findForApproval(String sCode, String selfJCode, String selfKCode, int dataLevel,
			int startDate) throws SQLException, IllegalAccessException, NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		// O
		sb.append(COL_KCODE + " != ? ");
		sb.append(" AND ");
		sb.append(" ( ");
		// Ə
		sb.append(COL_JCODE + " = ? ");
		// I
		sb.append(" AND ");
		sb.append(COL_SCODE + " IN (" + MSyozokuDao.getSectionQuery() + ") ");
		sb.append(" AND ");
		// f[^xȉ̐l
		sb.append(COL_KCODE + " IN (" + MosPUserDao.getSearchDataLevelSubQuery() + ") ");
		sb.append(" AND ");
		// WvJnɍݐEĂl		
		sb.append(getSearchEmployeeStatement());
		sb.append(") ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			// 
			setParam(index++, selfKCode);
			// Ə
			setParam(index++, selfJCode);
			// 
			setParam(index++, sCode);
			// f[^x
			setParam(index++, dataLevel);
			// WvJn
			setParam(index++, startDate);
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode			ЈR[h
	 * @param sCode			R[h
	 * @param selfJCode		[UƏR[h
	 * @param selfKCode		[UЈR[h
	 * @param dataLevel		f[^x
	 * @param startDate		Jn
	 * @return (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKihonDto findForApproval(String kCode, String sCode, String selfJCode, String selfKCode, int dataLevel,
			int startDate) throws SQLException, IllegalAccessException, NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		// Ώێ
		sb.append(COL_KCODE + " = ? ");
		sb.append(" AND ");
		sb.append(" ( ");
		// Ə
		sb.append(COL_JCODE + " = ? ");
		// I
		sb.append(" AND ");
		sb.append(COL_SCODE + " IN (" + MSyozokuDao.getSectionQuery() + ") ");
		sb.append(" AND ");
		// f[^xȉ̐l
		sb.append(COL_KCODE + " IN (" + MosPUserDao.getSearchDataLevelSubQuery() + ") ");
		sb.append(" AND ");
		// WvJnɍݐEĂl		
		sb.append(getSearchEmployeeStatement());
		sb.append(" ) ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			// Ώێ
			setParam(index++, kCode);
			// Ə
			setParam(index++, selfJCode);
			// 
			setParam(index++, sCode);
			// f[^x
			setParam(index++, dataLevel);
			// WvJn
			setParam(index++, startDate);
			executeQuery();
			MKihonDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * ɂf[^擾
	 * @param kCode 		ЈR[h
	 * @param selfJCode		[UƏR[h
	 * @param dataLevel		f[^x
	 * @param startDate		Jn
	 * @return (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public MKihonDto findForApprovalKCode(String kCode, String selfJCode, int dataLevel, int startDate)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		// Ώێ
		sb.append(COL_KCODE + " = ? ");
		sb.append(" AND ");
		sb.append(" ( ");
		// Ə
		sb.append(COL_JCODE + " = ? ");
		sb.append(" AND ");
		// f[^xȉ̐l
		sb.append(COL_KCODE + " IN (" + MosPUserDao.getSearchDataLevelSubQuery() + ") ");
		sb.append(" AND ");
		// WvJnɍݐEĂl		
		sb.append(getSearchEmployeeStatement());
		sb.append(" ) ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			// Ώێ
			setParam(index++, kCode);
			// Ə
			setParam(index++, selfJCode);
			// f[^x
			setParam(index++, dataLevel);
			// WvJn
			setParam(index++, startDate);
			executeQuery();
			MKihonDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * ɂf[^擾
	 * @param tsdate t
	 * @param kcode ЈR[h
	 * @param kname Ј
	 * @param scode R[h
	 * @param limit 
	 * @param offset ItZbg
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<MKihonDto> findForEmployeeWithLimit(int tsdate, String kcode, String kname, String scode, int limit,
			int offset) throws SQLException, IllegalAccessException, NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(getSearchEmployeeStatement());
		if (!kcode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_KCODE);
			sb.append(" LIKE ? ");
		}
		if (!kname.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SIMEI);
			sb.append(" LIKE ? ");
		}
		if (!scode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SCODE);
			sb.append(" IN( ");
			sb.append(MSyozokuDao.getSectionQuery());
			sb.append(") ");
		}
		sb.append(" ORDER BY ");
		sb.append(KEY_1);
		sb.append(" LIMIT ? OFFSET ?");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, tsdate);
			if (!kcode.equals("")) {
				setParam(index++, kcode + "%");
			}
			if (!kname.equals("")) {
				setParam(index++, "%" + kname + "%");
			}
			if (!scode.equals("")) {
				setParam(index++, scode);
			}
			setParam(index++, limit);
			setParam(index++, offset);
			executeQuery();
			List<MKihonDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * countl擾
	 * @param tsdate t
	 * @param kcode ЈR[h
	 * @param kname Ј
	 * @param scode R[h
	 * @return count
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public int findForCount(int tsdate, String kcode, String kname, String scode) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		throw new CloudzeroUnsupportedException();
/*		int count = 0;
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT COUNT(");
		sb.append(COL_KCODE);
		sb.append(") FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(getSearchEmployeeStatement());
		if (!kcode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_KCODE);
			sb.append(" LIKE ? ");
		}
		if (!kname.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SIMEI);
			sb.append(" LIKE ? ");
		}
		if (!scode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SCODE);
			sb.append(" IN( ");
			sb.append(MSyozokuDao.getSectionQuery());
			sb.append(") ");
		}
		try {
			prepareStatement(sb.toString());
			setParam(index++, tsdate);
			if (!kcode.equals("")) {
				setParam(index++, kcode + "%");
			}
			if (!kname.equals("")) {
				setParam(index++, "%" + kname + "%");
			}
			if (!scode.equals("")) {
				setParam(index++, scode);
			}
			executeQuery();
			if (rs.next()) {
				count = rs.getInt(1);
			}
			return count;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}*/
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(MKihonDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(MKihonDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(MKihonDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert  }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(MKihonDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode()); //ЈR[h
		setParam(index++, dto.getSimei()); //
		setParam(index++, dto.getFurigana()); //ӂ肪
		setParam(index++, dto.getSCode()); //R[h
		setParam(index++, dto.getYCode()); //ER[h
		setParam(index++, dto.getTokyu()); //
		setParam(index++, dto.getJCode()); //ƏR[h
		setParam(index++, dto.getNyDate()); //Г
		setParam(index++, dto.getTsDate()); //ސE
		setParam(index++, dto.getKnKubun()); //xސE敪
		setParam(index++, dto.getKyKubun()); //^敪
		setParam(index++, dto.getTxKubun()); //ŋ敪
		setParam(index++, dto.getTxKubunx()); //̑ŋ敪
		setParam(index++, dto.getKmKubun()); //g敪
		setParam(index++, dto.getPtKubun()); //p[g敪
		setParam(index++, dto.getShKubun()); //x敪
		setParam(index++, dto.getSiwakeCd()); //dWvR[h
		setParam(index++, dto.getHaigusya()); //}{z
		setParam(index++, dto.getFuyosu()); //}{Ƒ
		setParam(index++, dto.getYukyu()); //Lc
		setParam(index++, dto.getNenrei()); //N
		setParam(index++, dto.getKinzoku()); //ΑN
		setParam(index++, dto.getKenpoNo()); //۔ԍ
		setParam(index++, dto.getKohoNo()); //۔ԍ
		setParam(index++, dto.getKUser()); //[U
		setParam(index++, dto.getPassw()); //pX[h
		setParam(index++, dto.getEmail()); //email
		setParam(index++, dto.getNinsyo()); //F؎
		setParam(index++, dto.getDataLvl()); //f[^x
		setParam(index++, dto.getProgLevel()); //vOgp
		setCommonParams(isInsert);
	}
	
	/**
	 * ݐEҎ擾pSQL擾
	 * @return ݐEҎ擾pSQL
	 */
	protected String getSearchEmployeeStatement() {
		StringBuffer sb = new StringBuffer();
		sb.append("(");
		sb.append(COL_TSDATE + " = 0 ");
		sb.append(" OR ");
		sb.append(COL_TSDATE + " >= ? ");
		sb.append(") ");
		sb.append(" AND ");
		sb.append(COL_KNKUBUN);
		sb.append(" = '" + CommonConst.RETIREMENT_FLAG_OFF + "' ");
		return sb.toString();
	}
	
	/**
	 * ݐEҎ擾pSQL擾
	 * <p>	2009/06/08	m.yoshida	ސEҕ\Ή	</p>
	 * @param useKnKubun xސE敪ptO
	 * @return ݐEҎ擾pSQL
	 */
	public static String getSearchEmployeeStatementPeriod(boolean useKnKubun) {
		StringBuffer sb = new StringBuffer();
		sb.append(" (");
		sb.append(COL_TSDATE + " = 0 ");
		sb.append(" OR ");
		sb.append(COL_TSDATE + " >= ? ");
		sb.append(") ");
		sb.append(" AND ");
		sb.append(COL_NYDATE + " <= ? ");
		if (useKnKubun) {
			sb.append(" AND ");
			sb.append(COL_KNKUBUN);
			sb.append(" = '" + CommonConst.RETIREMENT_FLAG_OFF + "' ");
		}
		return sb.toString();
	}
	
	/**
	 * EʂɂבւSQL擾
	 * @return EʂɂבւSQL
	 */
	private String getOrderForPosition() {
		StringBuffer sb = new StringBuffer();
		sb.append("ORDER BY ");
		sb.append(COL_YCODE + ", ");
		sb.append(COL_PTKUBUN + ", ");
		sb.append(COL_SCODE + ", ");
		sb.append(COL_KCODE + " ");
		return sb.toString();
	}
	
	/**
	 * ЈR[hpTuNG[
	 * @return	sb	TuNG
	 */
	public static String getSearchKCodeSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_KCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_KCODE);
		sb.append(" LIKE ? ");
		return sb.toString();
	}
	
	/**
	 * ЈR[hpTuNG[
	 * @return	sb	TuNG
	 */
	public static String getSearchKCodeEqualSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_KCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? ");
		return sb.toString();
	}
	
	/**
	 * ЈpTuNG[
	 * @return	sb	TuNG
	 */
	public static String getSearchKNameSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_KCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_SIMEI);
		sb.append(" LIKE ? ");
		return sb.toString();
	}
	
	/**
	 * pTuNG[
	 * @return	sb	TuNG
	 */
	public static String getSearchAuthoritySubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_KCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_PROGLEVEL);
		sb.append(" = ? ");
		return sb.toString();
	}
	
	/**
	 * pTuNG[
	 * @return@sb	TuNG
	 */
	public static String getSearchSectionSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_KCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_SCODE);
		sb.append(" = ? ");
		return sb.toString();
	}
	
}
