/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.dao.CmCodeDao;
import jp.mosp.common.dto.CmCodeDto;
import jp.mosp.common.utils.VariousUtil;

/**
 * ʃR[hɊւPartNX
 * @author yoshida
 *	@version	0.0.1
 */
public class CmCodePart extends BasePart {
	
	/**
	 * RXgN^
	 */
	public CmCodePart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo	Part𗘗pۂɕKvȏ
	 */
	public CmCodePart(PartInfo partInfo) {
		super(partInfo);
	}
	

	private CmCodeDao	codeDao;
	

	/**
	 * CM_CODEe[upDAO擾
	 * @return	ςCmCodeDaoCX^X
	 * @throws Exception Oꍇ
	 */
	public CmCodeDao getCmCodeDao() throws Exception {
		if (VariousUtil.isNull(codeDao)) {
			codeDao = (CmCodeDao)getPreparedDao(CmCodeDao.class.getCanonicalName());
		}
		return codeDao;
	}
	
	/**
	 * R[hXg擾(CM_CODE)
	 * @param tId R[h敪
	 * @return R[hXg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getCodeArray(String tId) throws Exception {
		// f[^̎擾
		List<CmCodeDto> list = getCmCodeDao().findForCondition(tId);
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			CmCodeDto dto = list.get(i);
			array[i][0] = dto.getTCode();
			array[i][1] = dto.getTName();
		}
		return array;
	}
	
	/**
	 * R[h敪擾(CM_CODE)
	 * @return R[h敪Xg
	 * @throws Exception  Oꍇ
	 */
	public String[][] getCodeArray() throws Exception {
		// R[h敪̎擾(distinctf[^)
		List<CmCodeDto> list = getCmCodeDao().findAllTId();
		String[][] aryCode = new String[list.size()][2];
		// Sting̔zɊi[
		for (int i = 0; i < list.size(); i++) {
			String tId = list.get(i).getTId();
			aryCode[i][0] = tId;
			aryCode[i][1] = getCodeTypeName(tId);
		}
		return aryCode;
	}
	
	/**
	 * R[h敪̎擾(CM_CODE)
	 * @param	tId R[h敪
	 * @return	tId R[h敪
	 */
	public String getCodeTypeName(String tId) {
		if (tId.equals(CommonConst.TID_AUTHORITY)) {
			return CommonConst.TNM_AUTHORITY;
		} else {
			return tId;
		}
	}
	
	/**
	 * az
	 * @return	az
	 * @throws Exception Oꍇ
	 */
	public String[][] getJPCalendarGengo() throws Exception {
		String[][] array = JPDatePart.getJpCalendarGengo();
		String[][] aryGengo = getCodeArray(CommonConst.TID_JAPANESE);
		if (aryGengo.length > array.length) {
			array = aryGengo;
		}
		return array;
	}
	
}
