/*
 * Decompiled with CFR 0.152.
 */
package jp.getset.gae.bigtable;

import com.google.appengine.api.datastore.Query;
import java.util.HashMap;
import java.util.Map;
import jp.getset.gae.GaeUnsupportedException;
import jp.getset.gae.bigtable.PreparedOption;
import jp.getset.gae.bigtable.option.Preparable;
import jp.getset.gae.bigtable.option.PreparedCondition;
import jp.getset.gae.bigtable.option.PreparedConditionLike;
import jp.getset.gae.bigtable.option.PreparedDistinct;
import jp.getset.gae.bigtable.option.PreparedJoin;
import jp.getset.gae.bigtable.option.PreparedLimit;
import jp.getset.gae.bigtable.option.PreparedProperty;
import jp.getset.gae.bigtable.option.PreparedSort;
import jp.getset.gae.bigtable.option.operation.Operatable;
import jp.getset.gae.bigtable.option.operation.OperationCount;
import jp.getset.gae.bigtable.option.operation.OperationMax;
import jp.getset.gae.bigtable.option.operation.OperationSum;
import jp.getset.gae.exception.GaeSystemException;

public class PreparedOptionBuffer {
    private PreparedOption filledOption = new PreparedOption();
    private Map<Integer, Preparable> optionMap = new HashMap<Integer, Preparable>();
    private Integer optionIndex = 0;
    private boolean isSetLimit = false;

    public boolean hasOption() {
        return !this.optionMap.isEmpty() || this.filledOption.size() != 0;
    }

    public void appendFilledPreparable(Preparable preparable) {
        this.filledOption.add(preparable);
    }

    public void appendStoredPreparable(Preparable preparable) {
        this.optionIndex = this.optionIndex + 1;
        this.optionMap.put(this.optionIndex, preparable);
    }

    public void appendFilledOption(PreparedOption preparedOption) {
        this.filledOption.add(preparedOption);
    }

    public void appendStoredOption(PreparedOption option) {
        for (Preparable preparable : option) {
            this.optionIndex = this.optionIndex + 1;
            this.optionMap.put(this.optionIndex, preparable);
        }
    }

    private void appendPreparable(Preparable option) {
        this.optionIndex = this.optionIndex + 1;
        this.optionMap.put(this.optionIndex, option);
    }

    public PreparedOption getOption() {
        PreparedOption reparedOption = new PreparedOption();
        int i = 0;
        while (i < this.optionIndex) {
            reparedOption.add(this.optionMap.get(new Integer(i + 1)));
            ++i;
        }
        reparedOption.addAll(this.filledOption);
        return reparedOption;
    }

    public void appendWhere(String key, Query.FilterOperator operator, Object value) {
        this.filledOption.add(new PreparedCondition(key, operator, value));
    }

    public void appendIsNull(String key) {
        this.appendWhere(key, Query.FilterOperator.EQUAL, null);
    }

    public void appendIsNotNull(String key) {
        this.appendWhere(key, Query.FilterOperator.NOT_EQUAL, null);
    }

    public void appendWhere(String key, Query.FilterOperator operator) {
        this.appendPreparable(new PreparedCondition(key, operator));
    }

    public void appendOr(String key, Query.FilterOperator operator) {
        throw new GaeUnsupportedException("OR\u6761\u4ef6");
    }

    public void appendOr(String key, Query.FilterOperator operator, Object value) {
        throw new GaeUnsupportedException("OR\u6761\u4ef6");
    }

    public void appendLike(String key, Object value) {
        this.filledOption.add(new PreparedConditionLike(key, value));
    }

    public void appendLike(String key) {
        this.appendPreparable(new PreparedConditionLike(key));
    }

    public void appendDistinct(String key) {
        this.filledOption.add(new PreparedDistinct(key));
    }

    public void appendGroupBy(String key) {
        this.appendDistinct(key);
    }

    public void appendSort(String key) {
        this.filledOption.add(new PreparedSort(key));
    }

    public void appendSort(String key, Query.SortDirection direction) {
        this.filledOption.add(new PreparedSort(key, direction));
    }

    public void setLimit(int limit) {
        if (this.isSetLimit) {
            throw new GaeSystemException("\u65e2\u306bLIMIT\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        this.filledOption.add(new PreparedLimit(limit));
        this.isSetLimit = true;
    }

    public void appendOperationMax(String property) {
        this._appendProperty(property, new OperationMax());
    }

    public void appendOperationSum(String property) {
        this._appendProperty(property, new OperationSum());
    }

    public void appendOperationCount(String property) {
        this._appendProperty(property, new OperationCount());
    }

    public void appendOperationCount() {
        this.appendOperationCount("count");
    }

    public void appendJoin(String columnJoinFrom, String keyJoinTo, String columnJoinTo) {
        this.filledOption.add(new PreparedJoin(columnJoinFrom, keyJoinTo, columnJoinTo));
    }

    public void appendProperty(String property) {
        this._appendProperty(property);
    }

    private void _appendProperty(String property, Operatable operation) {
        PreparedProperty operationProperty = new PreparedProperty(property);
        operationProperty.setOperation(operation);
        this.appendFilledPreparable(operationProperty);
    }

    private void _appendProperty(String property) {
        PreparedProperty operationProperty = new PreparedProperty(property);
        this.appendFilledPreparable(operationProperty);
    }

    public static enum Type {
        LIKE;

    }
}

