fcf.module({
  name: "fcf:tests/NFSQL/Parser.multiquery.test.js",
  dependencies: ["fcf:NTest/uniTest.js", "fcf:NFSQL/Parser.js", "fcf:NFSQL/Builder.js"],
  module: function(uniTest, Parser, Builder) {
    var NTests = fcf.prepareObject(fcf, "NFSQL.NTests");
    var parser = new Parser();
    var builder = new Builder();


    uniTest.add("001 FSQL", "Parser Multi Query", function(a_tester) {
      var data = parser.parse("INSERT INTO proj ( name1 , f2 ) VALUES ( ${1} , ${2} ); SELECT * FROM proj", [1, 2]);
      uniTest.equalObject(
        data,
        [
          {
            type: 'insert',
            from: 'proj',
            values: [{field: "name1", value: 1}, {field: "f2", value: 2}],
            args: {"values[0].value": 1, "values[1].value": 2}
          },
          {
            type: 'select',
            from: 'proj',
            fields: [{field: "*"}],
            join: [],
            where: [],
            group: [],
            order: [],
            args: {}
          },
        ],
        "");
      var txtQuery = builder.build(data);
      var data2 = parser.parse(txtQuery.query, txtQuery.args);
      uniTest.equalObject(data, data2, "");


      var data = parser.parse("INSERT INTO \"pr;oj\" ( name1 , f2 ) VALUES ( ${1} , ${2} ); SELECT * FROM proj WHERE id <> ${3}", [1, 2, 3]);
      uniTest.equalObject(
        data,
        [
          {
            type: 'insert',
            from: 'pr;oj',
            values: [{field: "name1", value: 1}, {field: "f2", value: 2}],
            args: {"values[0].value": 1, "values[1].value": 2}
          },
          {
            type: 'select',
            from: 'proj',
            fields: [{field: "*"}],
            join: [],
            where: [{logic: "and", type: "<>", args: [{field: "id"}, {value: 3}]}],
            group: [],
            order: [],
            args: { "where[0].args[1].value": 3 }
          },
        ],
        ""
      );
      var txtQuery = builder.build(data);
      var data2 = parser.parse(txtQuery.query, txtQuery.args);
      uniTest.equalObject(data, data2, "");
    });

    return NTests;
  }
});
