/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import sun.nio.ch.DirectBuffer;
import sun.security.jca.JCAUtil;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_GCM_PARAMS;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11AEADCipher
extends CipherSpi {
    private static final int MODE_GCM = 10;
    private static final int GCM_DEFAULT_TAG_LEN = 16;
    private static final int GCM_DEFAULT_IV_LEN = 16;
    private static final String ALGO = "AES";
    private final Token token;
    private final long mechanism;
    private final int blockMode;
    private final int fixedKeySize;
    private Session session = null;
    private P11Key p11Key = null;
    private boolean initialized = false;
    private boolean encrypt = true;
    private byte[] iv = null;
    private int tagLen = -1;
    private SecureRandom random = JCAUtil.getSecureRandom();
    private ByteArrayOutputStream dataBuffer = new ByteArrayOutputStream();
    private ByteArrayOutputStream aadBuffer = new ByteArrayOutputStream();
    private boolean updateCalled = false;
    private boolean requireReinit = false;
    private P11Key lastEncKey = null;
    private byte[] lastEncIv = null;

    P11AEADCipher(Token token, String string, long l) throws PKCS11Exception, NoSuchAlgorithmException {
        this.token = token;
        this.mechanism = l;
        String[] stringArray = string.split("/");
        if (stringArray.length != 3) {
            throw new ProviderException("Unsupported Transformation format: " + string);
        }
        if (!stringArray[0].startsWith(ALGO)) {
            throw new ProviderException("Only support AES for AEAD cipher mode");
        }
        int n = stringArray[0].indexOf(95);
        this.fixedKeySize = n != -1 ? Integer.parseInt(stringArray[0].substring(n + 1)) >> 3 : -1;
        this.blockMode = this.parseMode(stringArray[1]);
        if (!stringArray[2].equals("NoPadding")) {
            throw new ProviderException("Only NoPadding is supported for AEAD cipher mode");
        }
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Unsupported mode " + string);
    }

    private int parseMode(String string) throws NoSuchAlgorithmException {
        if (!(string = string.toUpperCase(Locale.ENGLISH)).equals("GCM")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + string);
        }
        int n = 10;
        return n;
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Unsupported padding " + string);
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return this.doFinalLength(n);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.encrypt && this.iv == null && this.tagLen == -1) {
            switch (this.blockMode) {
                case 10: {
                    this.iv = new byte[16];
                    this.tagLen = 16;
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported mode");
                }
            }
            this.random.nextBytes(this.iv);
        }
        try {
            GCMParameterSpec gCMParameterSpec;
            String string;
            switch (this.blockMode) {
                case 10: {
                    string = "GCM";
                    gCMParameterSpec = new GCMParameterSpec(this.tagLen << 3, this.iv);
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported mode");
                }
            }
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string);
            algorithmParameters.init(gCMParameterSpec);
            return algorithmParameters;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException("Could not encode parameters", generalSecurityException);
        }
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (n == 2) {
            throw new InvalidKeyException("Parameters required for decryption");
        }
        this.updateCalled = false;
        try {
            this.implInit(n, key, null, -1, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("init() failed", invalidAlgorithmParameterException);
        }
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n == 2 && algorithmParameterSpec == null) {
            throw new InvalidAlgorithmParameterException("Parameters required for decryption");
        }
        this.updateCalled = false;
        byte[] byArray = null;
        int n2 = -1;
        if (algorithmParameterSpec != null) {
            switch (this.blockMode) {
                case 10: {
                    if (!(algorithmParameterSpec instanceof GCMParameterSpec)) {
                        throw new InvalidAlgorithmParameterException("Only GCMParameterSpec is supported");
                    }
                    byArray = ((GCMParameterSpec)algorithmParameterSpec).getIV();
                    n2 = ((GCMParameterSpec)algorithmParameterSpec).getTLen() >> 3;
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported mode");
                }
            }
        }
        this.implInit(n, key, byArray, n2, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n == 2 && algorithmParameters == null) {
            throw new InvalidAlgorithmParameterException("Parameters required for decryption");
        }
        this.updateCalled = false;
        try {
            GCMParameterSpec gCMParameterSpec = null;
            if (algorithmParameters != null) {
                switch (this.blockMode) {
                    case 10: {
                        gCMParameterSpec = algorithmParameters.getParameterSpec(GCMParameterSpec.class);
                        break;
                    }
                    default: {
                        throw new ProviderException("Unsupported mode");
                    }
                }
            }
            this.engineInit(n, key, gCMParameterSpec, secureRandom);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException);
        }
    }

    private void implInit(int n, Key key, byte[] byArray, int n2, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.reset(true);
        if (this.fixedKeySize != -1 && (key instanceof P11Key ? ((P11Key)key).length() >> 3 : key.getEncoded().length) != this.fixedKeySize) {
            throw new InvalidKeyException("Key size is invalid");
        }
        P11Key p11Key = P11SecretKeyFactory.convertKey(this.token, key, ALGO);
        switch (n) {
            case 1: {
                this.encrypt = true;
                boolean bl = this.requireReinit = Arrays.equals(byArray, this.lastEncIv) && p11Key == this.lastEncKey;
                if (!this.requireReinit) break;
                throw new InvalidAlgorithmParameterException("Cannot reuse iv for GCM encryption");
            }
            case 2: {
                this.encrypt = false;
                this.requireReinit = false;
                break;
            }
            default: {
                throw new InvalidAlgorithmParameterException("Unsupported mode: " + n);
            }
        }
        if (secureRandom != null) {
            this.random = secureRandom;
        }
        if (byArray == null && n2 == -1) {
            switch (this.blockMode) {
                case 10: {
                    byArray = new byte[16];
                    this.random.nextBytes(byArray);
                    n2 = 16;
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported mode");
                }
            }
        }
        this.iv = byArray;
        this.tagLen = n2;
        this.p11Key = p11Key;
        try {
            this.initialize();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not initialize cipher", pKCS11Exception);
        }
    }

    private void cancelOperation() {
        try {
            if (!this.session.hasObjects()) {
                this.session = this.token.killSession(this.session);
                return;
            }
            int n = this.doFinalLength(0);
            byte[] byArray = new byte[n];
            if (this.encrypt) {
                this.token.p11.C_Encrypt(this.session.id(), 0L, byArray, 0, n, 0L, byArray, 0, n);
            } else {
                this.token.p11.C_Decrypt(this.session.id(), 0L, byArray, 0, n, 0L, byArray, 0, n);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Cancel failed", pKCS11Exception);
        }
    }

    private void ensureInitialized() throws PKCS11Exception {
        if (this.initialized && this.aadBuffer.size() > 0) {
            this.reset(true);
        }
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.p11Key == null) {
            throw new ProviderException("Operation cannot be performed without calling engineInit first");
        }
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        this.token.ensureValid();
        byte[] byArray = this.aadBuffer.size() > 0 ? this.aadBuffer.toByteArray() : null;
        long l = this.p11Key.getKeyID();
        try {
            CK_MECHANISM cK_MECHANISM;
            if (this.session == null) {
                this.session = this.token.getOpSession();
            }
            switch (this.blockMode) {
                case 10: {
                    cK_MECHANISM = new CK_MECHANISM(this.mechanism, new CK_GCM_PARAMS(this.tagLen << 3, this.iv, byArray));
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported mode: " + this.blockMode);
                }
            }
            if (this.encrypt) {
                this.token.p11.C_EncryptInit(this.session.id(), cK_MECHANISM, l);
            } else {
                this.token.p11.C_DecryptInit(this.session.id(), cK_MECHANISM, l);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.p11Key.releaseKeyID();
            this.session = this.token.releaseSession(this.session);
            throw pKCS11Exception;
        }
        finally {
            this.dataBuffer.reset();
            this.aadBuffer.reset();
        }
        this.initialized = true;
    }

    private int doFinalLength(int n) {
        if (n < 0) {
            throw new ProviderException("Invalid negative input length");
        }
        int n2 = n + this.dataBuffer.size();
        if (this.encrypt) {
            n2 += this.tagLen;
        }
        return n2;
    }

    private void reset(boolean bl) {
        if (!this.initialized) {
            return;
        }
        try {
            if (this.session == null) {
                return;
            }
            if (bl && this.token.explicitCancel) {
                this.cancelOperation();
            }
        }
        finally {
            this.p11Key.releaseKeyID();
            this.session = this.token.releaseSession(this.session);
        }
        this.initialized = false;
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.updateCalled = true;
        int n3 = this.implUpdate(byArray, n, n2);
        return new byte[0];
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        this.updateCalled = true;
        this.implUpdate(byArray, n, n2);
        return 0;
    }

    @Override
    protected int engineUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        this.updateCalled = true;
        this.implUpdate(byteBuffer);
        return 0;
    }

    @Override
    protected synchronized void engineUpdateAAD(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (byArray == null || n < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("Invalid AAD");
        }
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        if (this.p11Key == null) {
            throw new IllegalStateException("Need to initialize Cipher first");
        }
        if (this.updateCalled) {
            throw new IllegalStateException("Update has been called; no more AAD data");
        }
        this.aadBuffer.write(byArray, n, n2);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) throws IllegalStateException {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("Invalid AAD");
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        this.engineUpdateAAD(byArray, 0, byArray.length);
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        int n3 = this.doFinalLength(n2);
        try {
            byte[] byArray2 = new byte[n3];
            int n4 = this.engineDoFinal(byArray, n, n2, byArray2, 0);
            byte[] byArray3 = P11Util.convert(byArray2, 0, n4);
            return byArray3;
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProviderException(shortBufferException);
        }
        finally {
            this.updateCalled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        try {
            int n4 = this.implDoFinal(byArray, n, n2, byArray2, n3, byArray2.length - n3);
            return n4;
        }
        finally {
            this.updateCalled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        try {
            int n = this.implDoFinal(byteBuffer, byteBuffer2);
            return n;
        }
        finally {
            this.updateCalled = false;
        }
    }

    private int implUpdate(byte[] byArray, int n, int n2) {
        if (n2 > 0) {
            this.updateCalled = true;
            try {
                this.ensureInitialized();
            }
            catch (PKCS11Exception pKCS11Exception) {
                this.reset(false);
                throw new ProviderException("update() failed", pKCS11Exception);
            }
            this.dataBuffer.write(byArray, n, n2);
        }
        return 0;
    }

    private int implUpdate(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n > 0) {
            try {
                this.ensureInitialized();
            }
            catch (PKCS11Exception pKCS11Exception) {
                this.reset(false);
                throw new ProviderException("update() failed", pKCS11Exception);
            }
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            this.dataBuffer.write(byArray, 0, byArray.length);
        }
        return 0;
    }

    private int implDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n5 = this.doFinalLength(n2);
        if (n4 < n5) {
            throw new ShortBufferException();
        }
        boolean bl = true;
        try {
            this.ensureInitialized();
            if (this.dataBuffer.size() > 0) {
                if (byArray != null && n > 0 && n2 > 0 && n < byArray.length - n2) {
                    this.dataBuffer.write(byArray, n, n2);
                }
                byArray = this.dataBuffer.toByteArray();
                n = 0;
                n2 = byArray.length;
            }
            int n6 = 0;
            if (this.encrypt) {
                n6 = this.token.p11.C_Encrypt(this.session.id(), 0L, byArray, n, n2, 0L, byArray2, n3, n4);
                bl = false;
            } else {
                if (n2 == 0) {
                    int n7 = 0;
                    return n7;
                }
                n6 = this.token.p11.C_Decrypt(this.session.id(), 0L, byArray, n, n2, 0L, byArray2, n3, n4);
                bl = false;
            }
            int n8 = n6;
            return n8;
        }
        catch (PKCS11Exception pKCS11Exception) {
            bl = false;
            this.handleException(pKCS11Exception);
            throw new ProviderException("doFinal() failed", pKCS11Exception);
        }
        finally {
            if (this.encrypt) {
                this.lastEncKey = this.p11Key;
                this.lastEncIv = this.iv;
                this.requireReinit = true;
            }
            this.reset(bl);
        }
    }

    private int implDoFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n;
        int n2;
        int n3 = byteBuffer2.remaining();
        if (n3 < (n2 = this.doFinalLength(n = byteBuffer.remaining()))) {
            throw new ShortBufferException();
        }
        boolean bl = true;
        try {
            this.ensureInitialized();
            long l = 0L;
            byte[] byArray = null;
            int n4 = 0;
            if (this.dataBuffer.size() > 0) {
                if (n > 0) {
                    byte[] byArray2 = new byte[n];
                    byteBuffer.get(byArray2);
                    this.dataBuffer.write(byArray2, 0, byArray2.length);
                }
                byArray = this.dataBuffer.toByteArray();
                n4 = 0;
                n = byArray.length;
            } else if (byteBuffer instanceof DirectBuffer) {
                l = ((DirectBuffer)((Object)byteBuffer)).address();
                n4 = byteBuffer.position();
            } else if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                n4 = byteBuffer.position() + byteBuffer.arrayOffset();
            } else {
                byArray = new byte[n];
                byteBuffer.get(byArray);
            }
            long l2 = 0L;
            byte[] byArray3 = null;
            int n5 = 0;
            if (byteBuffer2 instanceof DirectBuffer) {
                l2 = ((DirectBuffer)((Object)byteBuffer2)).address();
                n5 = byteBuffer2.position();
            } else if (byteBuffer2.hasArray()) {
                byArray3 = byteBuffer2.array();
                n5 = byteBuffer2.position() + byteBuffer2.arrayOffset();
            } else {
                byArray3 = new byte[n3];
            }
            int n6 = 0;
            if (this.encrypt) {
                n6 = this.token.p11.C_Encrypt(this.session.id(), l, byArray, n4, n, l2, byArray3, n5, n3);
                bl = false;
            } else {
                if (n == 0) {
                    int n7 = 0;
                    return n7;
                }
                n6 = this.token.p11.C_Decrypt(this.session.id(), l, byArray, n4, n, l2, byArray3, n5, n3);
                bl = false;
            }
            byteBuffer2.position(byteBuffer2.position() + n6);
            int n8 = n6;
            return n8;
        }
        catch (PKCS11Exception pKCS11Exception) {
            bl = false;
            this.handleException(pKCS11Exception);
            throw new ProviderException("doFinal() failed", pKCS11Exception);
        }
        finally {
            if (this.encrypt) {
                this.lastEncKey = this.p11Key;
                this.lastEncIv = this.iv;
                this.requireReinit = true;
            }
            this.reset(bl);
        }
    }

    private void handleException(PKCS11Exception pKCS11Exception) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        long l = pKCS11Exception.getErrorCode();
        if (l == 336L) {
            throw (ShortBufferException)new ShortBufferException().initCause(pKCS11Exception);
        }
        if (l == 33L || l == 65L) {
            throw (IllegalBlockSizeException)new IllegalBlockSizeException(pKCS11Exception.toString()).initCause(pKCS11Exception);
        }
        if (l == 64L) {
            throw (BadPaddingException)new BadPaddingException(pKCS11Exception.toString()).initCause(pKCS11Exception);
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        throw new UnsupportedOperationException("engineWrap()");
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException("engineUnwrap()");
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n = P11SecretKeyFactory.convertKey(this.token, key, ALGO).length();
        return n;
    }
}

