/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.ScrollPane;
import java.io.File;
import java.io.FileInputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;

public class Core
extends JApplet {
    Font myFont = new Font("Times New Roman", 0, 20);
    JTextArea txtExercise;
    String text = "Humpty Dumpty sat on a wall\nHumpty Dumpty had a great fall\nAll the Kings horses and all the Kings men\nCouldn't put Humpty together again";
    PyObject exManager;
    PythonInterpreter pyi;
    PyObject exMaker;
    PyObject ex;
    JLabel lblInfo = new JLabel();
    private JLabel lblScore = new JLabel();
    private MyMenuBar myMenuBar;
    private JPanel panButtons = new JPanel();
    private AnswerListener answerListener = new AnswerListener(this);

    public Core() throws HeadlessException {
        Container container = this.getContentPane();
        container.setLayout(null);
        this.txtExercise = new JTextArea();
        this.txtExercise.setFont(this.myFont);
        this.txtExercise.setLineWrap(true);
        this.txtExercise.setWrapStyleWord(true);
        this.txtExercise.addKeyListener(this.answerListener);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setBounds(0, 0, 600, 350);
        scrollPane.add(this.txtExercise);
        container.add(scrollPane);
        this.panButtons.setBounds(0, 350, 600, 50);
        container.add(this.panButtons);
        this.lblScore.setBounds(0, 400, 600, 50);
        container.add(this.lblScore);
        this.myMenuBar = new MyMenuBar(this);
        this.setJMenuBar(this.myMenuBar);
    }

    public void init() {
        this.pyi = new PythonInterpreter();
        this.pyi.exec("import sys");
        this.pyi.exec("sys.path.append('ExerciseMaker/Lib')");
        this.pyi.exec("sys.path.append('TextSetter/Lib')");
        try {
            PyObject pyObject;
            FileInputStream fileInputStream;
            String string;
            String string2;
            int n;
            File file = new File("ExerciseMaker");
            String[] stringArray = file.list();
            this.addLine("Loading ExerciseMaker Plugins...");
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n];
                string = string2.substring(string2.length() - 2);
                if (string.compareToIgnoreCase("py") != 0) continue;
                this.addLine("Loading " + string2 + " ...");
                fileInputStream = new FileInputStream("ExerciseMaker/" + string2);
                this.pyi.execfile(fileInputStream);
                pyObject = this.pyi.get("exm");
                this.myMenuBar.addExMaker(pyObject);
            }
            file = new File("TextSetter");
            stringArray = file.list();
            this.addLine("Loading TextSetter Plugins...");
            for (n = 0; n < stringArray.length; ++n) {
                string2 = stringArray[n];
                string = string2.substring(string2.length() - 2);
                if (string.compareToIgnoreCase("py") != 0) continue;
                this.addLine("Loading " + string2 + " ...");
                fileInputStream = new FileInputStream("TextSetter/" + string2);
                this.pyi.execfile(fileInputStream);
                pyObject = this.pyi.get("ts");
                this.myMenuBar.addTextSetter(pyObject);
            }
            this.exMaker = null;
            this.addLine("Plugins Loaded.");
            this.addLine("");
            this.addLine("To Start:");
            this.addLine("  Choose ExerciseMaker, Set some English text, and Start Exercise");
            this.startTimer();
        }
        catch (Exception exception) {
            this.txtExercise.setText("can't load plugins error");
            exception.printStackTrace();
        }
    }

    public void addLine(String string) {
        this.txtExercise.setText(this.txtExercise.getText() + string + "\n");
    }

    public void makeAnswerButton() {
        this.panButtons.removeAll();
        PyList pyList = (PyList)this.exMaker.__findattr__("answerList");
        for (int i = 0; i < pyList.__len__(); ++i) {
            String string = pyList.__getitem__(i).toString();
            JButton jButton = new JButton(string);
            jButton.setFont(this.myFont);
            this.panButtons.add(jButton);
            jButton.addActionListener(this.answerListener);
        }
        this.panButtons.add(this.lblInfo);
    }

    public void makeExercise() {
        if (this.exMaker != null) {
            this.exManager = this.exMaker.__findattr__("makeExercise").__call__(new PyString(this.text));
            this.updateExercise();
        } else {
            this.addLine("Choose ExerciseMaker please.");
        }
    }

    public void updateExercise() {
        this.txtExercise.setText(this.exManager.__str__().toString());
    }

    public void updateScore() {
        if (this.exManager != null) {
            this.lblScore.setText(this.exManager.__getattr__("calcScore").__call__().toString());
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Container container = jFrame.getContentPane();
        Core core = new Core();
        container.add(core);
        jFrame.addWindowListener(new ExitWhenClose());
        jFrame.setBounds(200, 200, 600, 500);
        jFrame.setVisible(true);
        core.init();
    }

    void startTimer() {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                Core.this.updateScore();
            }
        };
        new Timer().schedule(timerTask, 0L, 100L);
    }
}

