# -*- coding: cp932 -*-

True=1
False=0 # JythonTrue/FalseȂ̖YĂ

class Exercise:
    next=None

class Question(Exercise):
    solved=False
    focused=False
    caption=""
    answer=""
    isQuestion=True
    def __init__(self, caption, answer):
        self.caption=caption
        self.answer=answer

    def __str__(self):
        if self.solved:
            text=self.caption
        else:
            if self.focused:
                text="[___]"
            else:
                text="_____"

        if self.next:
            return text+str(self.next)
        else:
            return text

class ExerciseContext(Exercise):
    isQuestion=False
    def __init__(self, caption):
        self.caption=caption
    def __str__(self):
        if self.next:
            return self.caption+str(self.next)
        else:
            return self.caption

from time import time
class ExerciseManager:
    def __init__(self, exercise, numQuestion, answerList):
        self.exercise=exercise
        self.numQuestion=numQuestion
        self.answerList=answerList
        
        self.finished=False
        self.focus=exercise
        self.findNextQuestion()

        self.startTime=time()
        self.good=0
        self.bad=0
        self.numTrial=0
    def findNextQuestion(self):
        pos=self.focus
        while True:
            if pos.isQuestion and not(pos.solved):
                self.focus=pos
                pos.focused=True
                return pos
            elif pos.next:
                pos=pos.next
            else:
                self.finished=True
                self.endTime=time()
                return None
    def checkAnswer_key(self, key):
        key=key.upper()
        keymap={"J":0, "K":1, "L":2, ";":3}
        index=keymap[key]
        return self.checkAnswer(self.answerList[index])
    def checkAnswer(self, answer):
        if self.finished:
            return "Finished"
        self.numTrial+=1
        if self.focus.answer==answer:
            self.focus.solved=True
            self.good+=1
            self.findNextQuestion()
            if self.finished:
                return "Finished"
            return "Good"
        else:
            self.bad+=1
            return "Bad"
    def calcScore(self):
        if self.finished:
            passedTime = self.endTime-self.startTime
        else:
            passedTime = time()-self.startTime
        result = "oߎ: %.1f   "%passedTime
        if self.numTrial>0:
            result +=": %.1f%%   "%(100.0*self.good/self.numTrial)
        if self.numQuestion>0:
            result +="B: %d/%d   "%(self.good, self.numQuestion)
        if self.numTrial>0:
            # 11̐1_AKɑē_҂Ȃ悤
            # _ɓꍇ̓_0_ɂȂ悤ɕ␳
            numAns=float(len(self.answerList))
            score = (float(self.good) - float(self.numTrial)/numAns) 
            score *= (numAns -1) / numAns * 60 / passedTime
            result +="XRA: %.3f   "%(score)
            

        return result
    def __str__(self):
        return str(self.exercise)

class IExerciseMaker:
    name="pĖ쐬NX"
    head=None
    tail=None
    def reset(self):
        self.head=None
        self.tail=None
        self.numQuestion=0
    def makeExercise(self, str):
        self.reset()
        self.parse(str)
        return ExerciseManager(self.head, self.numQuestion, self.answerList)
##    def feedExercise(self, exercise):
##        while exercise!=None:
##            if exercise.__class__.__name__=="Question":
##                self.append(exercise)
##            else:
##                self.parse(exercise.caption)
##            exercise=exercise.next
    def append(self, exercise):
        if self.tail!=None:
            self.tail.next = exercise
            self.tail = exercise
        else:
            self.head = exercise
            self.tail = exercise
    def parse(str):
        raise NotImplementedError
