package sample;

import elazyrest.core.annotation.RestMethod;
import elazyrest.core.annotation.RestParam;
import elazyrest.core.annotation.SimpleXml;

/**
 * Hello Worldサンプル
 * とりあえず作ってみる！
 * 
 * １．POJOクラスを作成
 * ２．WEB公開用のアノテーションを定義する
 * SimpleXml, RestMethod, RestParam
 * ３．ブラウザでアクセスしてみる
 * 以上
 * 
 * 
 * @author kaz
 *
 */
@SimpleXml/* WEBに公開するかどうかを定義するアノテーション */
public class HelloWorld {
	/**
	 * Hello Worldサンプル
	 * URL例: http://elazyrest/app?method=HelloWorld.helloWorld
	 * ドメインを差し替えてください
	 * 
	 * @return
	 */
	@RestMethod({"GET", "POST"})/* 許可するメソッドを設定するアノテーション */
	public String helloWorld() {
		// フレームワークで用意されたResponse作成クラスを利用
		return "userid";
	}

	/** 
	 * パラメータが存在する場合のサンプル
	 * URL例: http://localhost:8080/lazyrest?method=HelloWorld.helloWorld2&name=mario
	 * 
	 * @param name
	 * @return
	 */
	@RestMethod({"GET", "POST"})/* 許可するメソッドを設定するアノテーション */
	public String helloWorld2(
			/* リクエストパラメータ名を設定するアノテーション */
			@RestParam(name="name") String name
			) {

		// フレームワークで用意されたResponse作成クラスを利用
		return "Hello " +name;
	}

	/** 
	 * パラメータを必須にする
	 * URL例: http://localhost:8080/lazyrest?method=HelloWorld.helloWorld3&name=mario
	 * 
	 * @param name
	 * @return
	 */
	@RestMethod({"GET", "POST"})/* 許可するメソッドを設定するアノテーション */
	public String helloWorld3(
			/* リクエストパラメータ名を設定するアノテーション */
			//required=trueで必須
			@RestParam(name="name", required=true) String name
			) {

		// フレームワークで用意されたResponse作成クラスを利用
		return "Hello " +name;
	}
	
	/** 
	 * 最大文字数チェック
	 * URL例: http://localhost:8080/lazyrest?method=HelloWorld.helloWorld4&name=mario
	 * 
	 * @param name
	 * @return
	 */
	@RestMethod({"GET", "POST"})/* 許可するメソッドを設定するアノテーション */
	public String helloWorld4(
			/* リクエストパラメータ名を設定するアノテーション */
			//maxLength=2で、最大文字数2までチェック
			@RestParam(name="name", maxLength=2) String name
			) {

		// フレームワークで用意されたResponse作成クラスを利用
		return "Hello " +name;
	}

	/** 
	 * 正規表現チェック
	 * URL例: http://ドメイン/api?method=HelloWorld.helloWorld4&name=mario
	 * 
	 * @param name
	 * @return
	 */
	@RestMethod({"GET", "POST"})/* 許可するメソッドを設定するアノテーション */
	public String helloWorld6(
			/* リクエストパラメータ名を設定するアノテーション */
			//pattern="[a-z]+"で、正規表現チェック
			@RestParam(name="name", pattern="[a-z]+") String name,
			@RestParam(name="name2", pattern="[a-z]+") String name2
			) {
		

		// フレームワークで用意されたResponse作成クラスを利用
		return "Hello " +name;
	}

	/** 
	 * 正規表現チェック
	 * URL例: http://ドメイン/api?method=HelloWorld.helloWorld4&name=mario
	 * 
	 * @param name
	 * @return
	 */
	@RestMethod({"GET", "POST"})/* 許可するメソッドを設定するアノテーション */
	public String helloWorld5(
			/* リクエストパラメータ名を設定するアノテーション */
			//pattern="[a-z]+"で、正規表現チェック
			@RestParam(name="name", pattern="[a-z]+") String name
			) {

		// フレームワークで用意されたResponse作成クラスを利用
		return "Hello " +name;
	}

	/**
	 * 小説表紙イメージ設定
	 * @param bookId
	 * @param image
	 * @return
	 */
	@RestMethod({"POST"})
	public String binaryTest(
			@RestParam(name="image", binary=true) byte[] image,
			@RestParam(name="name", required=true) String name
			) {
		System.err.print(name);
		return name;
	}
}
