package sample;

import java.util.Date;
import java.util.List;

import elazyrest.core.annotation.RestMethod;
import elazyrest.core.annotation.SimpleXml;
import elazyrest.core.util.DateUtil;
import elazyrest.core.xml.rss.Channel;
import elazyrest.core.xml.rss.Item;
import elazyrest.core.xml.rss.Rss;


/**
 * RSS出力サンプル
 * 
 * １．POJOクラスを作成
 * ３．WEB公開用のアノテーションを定義する
 * SimpleXml, RestMethod, RestParam
 * ３．ブラウザでアクセスしてみる
 * 以上
 * 
 * 
 * @author kaz
 *
 */
@SimpleXml/* WEBに公開するかどうかを定義するアノテーション */
public class HelloRSS {

	/**
	 * HelloRSSサンプル
	 * URL例: http://localhost:8080/lazyrest?method=HelloRSS.hello
	 * 
	 * @return
	 */
	@RestMethod({"GET", "POST"}) /* 許可するメソッドを設定するアノテーション */
	public Rss hellox() {

		// フレームワークで用意されているRSSクラスを利用
		// 拡張する場合は、gen/xml/を参照
		
		// RSS作成(JAXB利用)
		Rss rss = new Rss();
		
		// Channel
		Channel channel = new Channel();
		channel.setTitle("タイトル");
		channel.setLink("http://elazyrest.net");
		channel.setDescription("概要");
		channel.setPubDate(DateUtil.rfc822(new Date()));
		rss.setChannel(channel);

		// Item
		List<Item> itemList = channel.getItems();
		
		for (int i = 0; i < 10; i++) {
			Item item = new Item();
			item.setTitle("アイテム" +i);
			item.setAuthor("test@test.com");
			item.setDescription("アイテム概要");
			item.setPubDate(DateUtil.rfc822(new Date()));
			item.setLink("http://elazyrest.net");
			
			itemList.add(item);
		}
		return rss;
	}
}
