package elazyrest.core.provider;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * @author kaz
 *
 */
@SuppressWarnings("unchecked")
public class ThreadLocalProvider {
	private static ThreadLocalProvider _instance = new ThreadLocalProvider();
	
	private static Log log = LogFactory.getLog(ThreadLocalProvider.class);

	private Map<Class<?>, ThreadLocal> instances = new HashMap<Class<?>, ThreadLocal>();
	
	public static Object get(Class<?> cl) {
		return _instance.getInstance(cl);
	}
	
	public static boolean contains(Class<?> cl) {
		if (_instance.instances.containsKey(cl)) {
			ThreadLocal local =  _instance.instances.get(cl);
			Object obj = local.get();
			if (obj != null) {
				return true;
			}
		}
		return false;
	}
	
	public static void set(Class cl, Object instance) {
		_instance.setInstance(cl, instance);
	}
	
	public void setInstance(Class cl, Object instance) {
		ThreadLocal tLocal;

		synchronized (instances) {
			// ThradLocalꍇ
			if (instances.containsKey(cl)) {
				tLocal = instances.get(cl);
			}
			// ThradLocalȂꍇ
			else {
				tLocal = new ThreadLocal();
			}
			tLocal.set(instance);
			instances.put(cl, tLocal);
		}
	}
	
	protected Object getInstance(Class<?> cl) {
		try {
			Object instance = null;

			ThreadLocal tLocal;
			synchronized (instances) {
				// ThradLocalȂꍇ
				if (!instances.containsKey(cl)) {
					tLocal = new ThreadLocal();
					instances.put(cl, tLocal);
				}
				else {
					tLocal = instances.get(cl);
					instance = tLocal.get();
				}
				if (instance == null) {
					instance = cl.newInstance();
				}
				tLocal.set(instance);
			}

			return instance;
		}
		catch (InstantiationException e) {
			log.error(e.getMessage(), e);
			//e.printStackTrace();
			throw new RuntimeException(e);
		}
		catch (IllegalAccessException e) {
			log.error(e.getMessage(), e);
			//e.printStackTrace();
			throw new RuntimeException(e);
		}
	}
	
	public static void clear() {
		synchronized (_instance.instances) {
			_instance.instances.clear();
		}
	}
}
