/*
 * Decompiled with CFR 0.152.
 */
package generator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class SchemaBindingGen {
    private String template = null;
    private String schema = null;
    private String dest = null;
    private String packageName = null;

    public static void main(String[] args) {
        SchemaBindingGen self = new SchemaBindingGen();
        try {
            if (args.length < 3) {
                System.err.println("-s=schema -d=dest -t=template");
                return;
            }
            int i = 0;
            while (i < args.length) {
                String[] param = args[i].split("=");
                if (param[0].equals("-s")) {
                    self.schema = param[1];
                } else if (param[0].equals("-d")) {
                    self.dest = param[1];
                } else if (param[0].equals("-t")) {
                    self.template = param[1];
                } else if (param[0].equals("-p")) {
                    self.packageName = param[1];
                }
                ++i;
            }
            if (self.packageName == null) {
                self.packageName = self.schema;
            }
            self.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generate() {
        File tempFile = new File(this.template);
        try {
            String s;
            String tempStr = "";
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempFile), "utf-8"));
            while ((s = br.readLine()) != null) {
                tempStr = String.valueOf(tempStr) + s;
                tempStr = String.valueOf(tempStr) + "\n";
            }
            br.close();
            tempStr = tempStr.replaceAll("\\{schema\\}", this.schema);
            tempStr = tempStr.replaceAll("\\{package\\}", this.packageName);
            FileOutputStream fos = new FileOutputStream(this.dest);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            bw.write(tempStr.toString());
            bw.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

