/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.tools.appstats.StatsProtos;
import com.google.appengine.tools.appstats.StatsUtil;
import com.google.appengine.tools.appstats.TemplateTool;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Renderer {
    private final TemplateTool templateTool;

    public Renderer() {
        this(false);
    }

    Renderer(boolean strict) {
        this.templateTool = new TemplateTool(new TemplateTool.Option[]{strict ? TemplateTool.Option.STRICT : TemplateTool.Option.NON_STRICT}){
            private final String prefix = "/apphosting/ext/appstats/templates/";
            {
                this.prefix = "/apphosting/ext/appstats/templates/";
            }

            @Override
            protected CharSequence loadTemplateSource(String name) throws IOException {
                return super.loadTemplateSource("/apphosting/ext/appstats/templates/" + name);
            }

            @Override
            public void format(Map<String, ?> parameters, Writer out, String templateName, String ... parents) throws IOException, ParseException {
                HashMap extendedParams = new HashMap(parameters);
                HashMap<String, String> env = new HashMap<String, String>();
                extendedParams.put("env", env);
                env.put("APPLICATION_ID", Renderer.this.getAppId());
                env.put("CURRENT_VERSION_ID", Renderer.this.getCurrentVersionId());
                super.format(extendedParams, out, templateName, parents);
            }
        };
    }

    String getAppId() {
        return ApiProxy.getCurrentEnvironment().getAppId();
    }

    String getCurrentVersionId() {
        return ApiProxy.getCurrentEnvironment().getVersionId();
    }

    public void renderSummaries(Writer out, List<StatsProtos.RequestStatProto> summaries) throws IOException {
        try {
            this.templateTool.format(StatsUtil.createSummaryStats(summaries), out, "main.html", new String[0]);
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void renderDetails(Writer out, StatsProtos.RequestStatProto detailedStats) throws IOException {
        try {
            this.templateTool.format(StatsUtil.createDetailedStats(detailedStats), out, "details.html", new String[0]);
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }
}

