/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.tools.appstats.Recorder;
import com.google.appengine.tools.appstats.StatsProtos;
import com.google.apphosting.api.ApiProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MemcacheWriter
implements Recorder.RecordWriter {
    private static final int FIRST_FIELD_NUMBER_FOR_DETAILS = 100;
    private static final String KEY_PREFIX = "__appstats__";
    private static final String KEY_TEMPLATE = ":%06d";
    private static final String PART_SUFFIX = ":part";
    private static final String FULL_SUFFIX = ":full";
    private static final int KEY_DISTANCE = 100;
    private static final int KEY_MODULUS = 1000;
    private static final int EXPIRATION_SECONDS = 129600;
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final Recorder.Clock clock;
    private final String keyInCache;
    private final MemcacheService memcache;
    private final Options options;

    private static String makeKeyPrefix(long timestamp) {
        return String.format("__appstats__:%06d", timestamp / 100L % 1000L * 100L);
    }

    public MemcacheWriter(Recorder.Clock clock, MemcacheService service, Options options) {
        this.clock = clock;
        this.keyInCache = this.getClass().getName() + ".CACHED_STATS";
        this.memcache = service;
        if (service == null) {
            throw new NullPointerException("Memcache service not found");
        }
        this.options = options == null ? new Options() : options.clone();
    }

    @Override
    public final void begin(ApiProxy.Delegate<?> wrappedDelegate, ApiProxy.Environment environment, HttpServletRequest request) {
        long preNow = this.clock.currentTimeMillis();
        StatsProtos.RequestStatProto.Builder builder = StatsProtos.RequestStatProto.newBuilder();
        builder.setStartTimestampMilliseconds(this.clock.currentTimeMillis());
        builder.setHttpMethod(request.getMethod());
        builder.setHttpPath(request.getRequestURI());
        String queryUnescaped = request.getQueryString();
        builder.setHttpQuery(queryUnescaped == null ? "" : queryUnescaped);
        builder.setIsAdmin(environment.isAdmin());
        if (environment.getEmail() != null) {
            builder.setUserEmail(environment.getEmail());
        }
        builder.setOverheadWalltimeMilliseconds(this.clock.currentTimeMillis() - preNow);
        environment.getAttributes().put(this.keyInCache, builder);
    }

    @Override
    public final Long commit(ApiProxy.Delegate<?> wrappedDelegate, ApiProxy.Environment environment, Integer responseCode) {
        StatsProtos.RequestStatProto.Builder builder = (StatsProtos.RequestStatProto.Builder)((Object)environment.getAttributes().get(this.keyInCache));
        if (builder == null) {
            return null;
        }
        builder.setDurationMilliseconds(this.clock.currentTimeMillis() - builder.getStartTimestampMilliseconds());
        if (responseCode != null) {
            builder.setHttpStatus(responseCode);
        } else {
            builder.clearHttpStatus();
        }
        HashMap<String, StatsProtos.AggregateRpcStatsProto.Builder> aggregates = new HashMap<String, StatsProtos.AggregateRpcStatsProto.Builder>();
        for (StatsProtos.IndividualRpcStatsProto stat : builder.getIndividualStatsList()) {
            String key = stat.getServiceCallName();
            if (!aggregates.containsKey(key)) {
                aggregates.put(key, StatsProtos.AggregateRpcStatsProto.newBuilder().setServiceCallName(stat.getServiceCallName()).setTotalAmountOfCalls(0L));
            }
            StatsProtos.AggregateRpcStatsProto.Builder aggregate = (StatsProtos.AggregateRpcStatsProto.Builder)((Object)aggregates.get(key));
            aggregate.setTotalAmountOfCalls(aggregate.getTotalAmountOfCalls() + 1L);
        }
        for (StatsProtos.AggregateRpcStatsProto.Builder aggregate : aggregates.values()) {
            builder.addRpcStats(aggregate.build());
        }
        environment.getAttributes().remove(this.keyInCache);
        return this.persist(builder.build());
    }

    @Override
    public final void write(ApiProxy.Delegate<?> wrappedDelegate, ApiProxy.Environment environment, StatsProtos.IndividualRpcStatsProto.Builder record, long overheadWalltimeMillis, boolean correctStartOffset) {
        if (record == null) {
            throw new NullPointerException("Record must not be null");
        }
        if (environment == null) {
            throw new NullPointerException("Environment must not be null");
        }
        StatsProtos.RequestStatProto.Builder builder = (StatsProtos.RequestStatProto.Builder)((Object)environment.getAttributes().get(this.keyInCache));
        if (builder != null) {
            if (correctStartOffset) {
                record.setStartOffsetMilliseconds(Math.max(0L, record.getStartOffsetMilliseconds() - builder.getStartTimestampMilliseconds()));
            }
            builder.addIndividualStats(record);
            builder.setOverheadWalltimeMilliseconds(builder.getOverheadWalltimeMilliseconds() + overheadWalltimeMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StatsProtos.RequestStatProto> getSummaries() {
        String oldNamespace = this.memcache.getNamespace();
        this.memcache.setNamespace(this.options.statsNamespace);
        try {
            ArrayList<String> keys = new ArrayList<String>(1000);
            for (int i = 0; i < 1000; ++i) {
                keys.add(MemcacheWriter.makeKeyPrefix(i * 100) + PART_SUFFIX);
            }
            ArrayList<StatsProtos.RequestStatProto> result = new ArrayList<StatsProtos.RequestStatProto>();
            for (Map.Entry entry : this.memcache.getAll(keys).entrySet()) {
                try {
                    result.add(((StatsProtos.RequestStatProto.Builder)StatsProtos.RequestStatProto.newBuilder().mergeFrom((byte[])entry.getValue())).build());
                }
                catch (InvalidProtocolBufferException e) {
                    this.log.warning("Memcache store for request stats is partially corrupted for key " + entry.getKey());
                    this.memcache.delete(entry.getKey());
                }
            }
            ArrayList<StatsProtos.RequestStatProto> arrayList = result;
            return arrayList;
        }
        finally {
            this.memcache.setNamespace(oldNamespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatsProtos.RequestStatProto getFull(long timestamp) {
        String oldNamespace = this.memcache.getNamespace();
        this.memcache.setNamespace(this.options.statsNamespace);
        String key = MemcacheWriter.makeKeyPrefix(timestamp) + FULL_SUFFIX;
        try {
            byte[] rawData = (byte[])this.memcache.get((Object)key);
            StatsProtos.RequestStatProto requestStatProto = rawData == null ? null : ((StatsProtos.RequestStatProto.Builder)StatsProtos.RequestStatProto.newBuilder().mergeFrom(rawData)).build();
            return requestStatProto;
        }
        catch (InvalidProtocolBufferException e) {
            this.log.warning("Memcache store for request stats is partially corrupted for key " + key);
            this.memcache.delete((Object)key);
            StatsProtos.RequestStatProto requestStatProto = null;
            return requestStatProto;
        }
        finally {
            this.memcache.setNamespace(oldNamespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long persist(StatsProtos.RequestStatProto stats) {
        String oldNamespace = this.memcache.getNamespace();
        this.memcache.setNamespace(this.options.statsNamespace);
        StatsProtos.RequestStatProto.Builder summary = StatsProtos.RequestStatProto.newBuilder().mergeFrom(stats);
        for (Descriptors.FieldDescriptor field : StatsProtos.RequestStatProto.getDescriptor().getFields()) {
            if (field.getNumber() <= 100) continue;
            summary.clearField(field);
        }
        try {
            HashMap<String, byte[]> values = new HashMap<String, byte[]>();
            String prefix = MemcacheWriter.makeKeyPrefix(stats.getStartTimestampMilliseconds());
            values.put(prefix + PART_SUFFIX, summary.build().toByteArray());
            values.put(prefix + FULL_SUFFIX, stats.toByteArray());
            this.memcache.putAll(values, Expiration.byDeltaSeconds((int)129600));
        }
        finally {
            this.memcache.setNamespace(oldNamespace);
        }
        return stats.getStartTimestampMilliseconds();
    }

    public static final class Options
    implements Cloneable {
        private String statsNamespace = "__appstats__";

        public String getStatsNamespace() {
            return this.statsNamespace;
        }

        public void setStatsNamespace(String statsNamespace) {
            this.statsNamespace = statsNamespace;
        }

        protected Options clone() {
            try {
                return (Options)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)"Cannot clone java.lang.Object");
            }
        }
    }
}

