/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.tools.appstats.MemcacheWriter;
import com.google.appengine.tools.appstats.Recorder;
import com.google.appengine.tools.appstats.Renderer;
import com.google.appengine.tools.appstats.StatsProtos;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AppstatsServlet
extends HttpServlet {
    private static final String PREFIX = "/apphosting/ext/appstats/static/";
    private static final Map<String, String> CONTENT_TYPES;
    private final MemcacheWriter memcache;
    private final Renderer renderer;
    Recorder.Clock clock = new Recorder.Clock();

    AppstatsServlet(MemcacheWriter writer, Renderer renderer) {
        this.memcache = writer;
        this.renderer = renderer;
    }

    public AppstatsServlet() {
        this(new MemcacheWriter(new Recorder.Clock(), MemcacheServiceFactory.getMemcacheService(), new MemcacheWriter.Options()), new Renderer());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String servletPath = req.getServletPath();
        if (servletPath.endsWith("/")) {
            servletPath = servletPath.substring(0, servletPath.length() - 1);
        }
        String path = req.getRequestURI();
        if ((path = path.substring(path.toUpperCase().indexOf(servletPath.toUpperCase()) + servletPath.length())).indexOf("/static/") >= 0) {
            this.serveStaticContent(req, resp);
        } else if (path.equals("/details")) {
            StatsProtos.RequestStatProto data;
            try {
                long asTimeStamp = Long.parseLong(req.getParameter("time"));
                data = this.memcache.getFull(asTimeStamp);
            }
            catch (NumberFormatException e) {
                data = null;
            }
            if (data == null) {
                resp.sendError(404);
                return;
            }
            this.renderer.renderDetails(resp.getWriter(), data);
        } else if (path.equals("/stats")) {
            this.renderer.renderSummaries(resp.getWriter(), this.memcache.getSummaries());
        } else {
            resp.sendRedirect("stats");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serveStaticContent(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String ext;
        String resource = req.getRequestURI();
        resource = PREFIX + resource.substring(resource.lastIndexOf(47) + 1);
        URL byName = AppstatsServlet.class.getResource(resource);
        if (byName == null) {
            resp.sendError(404);
        }
        if (resource.lastIndexOf(46) < 0) {
            resp.sendError(404);
        }
        if (!CONTENT_TYPES.containsKey(ext = resource.substring(resource.toLowerCase().lastIndexOf(46) + 1))) {
            resp.sendError(404);
        }
        resp.addHeader("Content-type", CONTENT_TYPES.get(ext));
        resp.addHeader("Cache-Control", "public, max-age=expiry");
        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        resp.addHeader("Expires", httpDateFormat.format(new Date(this.clock.currentTimeMillis() + 3600000L)));
        ServletOutputStream out = resp.getOutputStream();
        InputStream in = byName.openStream();
        try {
            byte[] b = new byte[256];
            int len = in.read(b);
            while (len > 0) {
                out.write(b, 0, len);
                len = in.read(b);
            }
        }
        finally {
            try {
                in.close();
            }
            finally {
                out.close();
            }
        }
    }

    static {
        HashMap<String, String> contentTypes = new HashMap<String, String>();
        contentTypes.put("css", "text/css");
        contentTypes.put("js", "application/javascript");
        contentTypes.put("gif", "image/gif");
        CONTENT_TYPES = Collections.unmodifiableMap(contentTypes);
    }
}

