/*
 * Decompiled with CFR 0.152.
 */
package elazyrest.i18n;

import elazyrest.i18n.XmlResourceBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ResourceBundleEx {
    public static final ResourceBundle getBundle(String str) {
        return ResourceBundleEx.getBundle(str, Locale.getDefault());
    }

    public static final ResourceBundle getBundle(String str, Locale loc) {
        String dir;
        String rname;
        String con = loc.getCountry();
        String lang = loc.getLanguage();
        String valiant = loc.getVariant();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(rname = new String(String.valueOf(dir = str.replaceAll("\\.", "/")) + "_" + lang + "_" + con + "_" + valiant + ".xml"));
        if (url != null) {
            return new XmlResourceBundle(url, loc);
        }
        rname = new String(String.valueOf(dir) + "_" + lang + "_" + con + ".xml");
        url = cl.getResource(rname);
        if (url != null) {
            return new XmlResourceBundle(url, loc);
        }
        rname = new String(String.valueOf(dir) + "_" + lang + ".xml");
        url = cl.getResource(rname);
        if (url != null) {
            return new XmlResourceBundle(url, loc);
        }
        rname = new String(String.valueOf(dir) + ".xml");
        url = cl.getResource(rname);
        if (url != null) {
            return new XmlResourceBundle(url, loc);
        }
        if (!loc.equals(Locale.getDefault())) {
            return ResourceBundleEx.getBundle(str, Locale.getDefault());
        }
        return ResourceBundle.getBundle(str, loc);
    }

    public static final ResourceBundle getBundle(String str, String strLoc) {
        String[] locs = strLoc.split("_");
        Locale loc = null;
        if (locs != null) {
            switch (locs.length) {
                case 1: {
                    loc = new Locale(locs[0]);
                    break;
                }
                case 2: {
                    loc = new Locale(locs[0], locs[1]);
                    break;
                }
                case 3: {
                    loc = new Locale(locs[0], locs[1], locs[2]);
                }
            }
        } else {
            loc = Locale.getDefault();
        }
        return ResourceBundleEx.getBundle(str, loc);
    }

    public static final ResourceBundle getBundle(String str, Locale loc, String dir) {
        String con = loc.getCountry();
        String lang = loc.getLanguage();
        String valiant = loc.getVariant();
        try {
            String rname = new String(String.valueOf(dir) + File.separator + str + "_" + lang + "_" + con + "_" + valiant + ".xml");
            File rfile = new File(rname);
            if (rfile != null && rfile.exists()) {
                return new XmlResourceBundle(rname, loc);
            }
            rname = new String(String.valueOf(dir) + File.separator + str + "_" + lang + "_" + con + ".xml");
            rfile = new File(rname);
            if (rfile != null && rfile.exists()) {
                return new XmlResourceBundle(rname, loc);
            }
            rname = new String(String.valueOf(dir) + File.separator + str + "_" + lang + ".xml");
            rfile = new File(rname);
            if (rfile != null && rfile.exists()) {
                return new XmlResourceBundle(rname, loc);
            }
            rname = new String(String.valueOf(dir) + File.separator + str + ".xml");
            rfile = new File(rname);
            if (rfile != null && rfile.exists()) {
                return new XmlResourceBundle(rname, loc);
            }
            rname = new String(String.valueOf(dir) + File.separator + str + "_" + lang + "_" + con + "_" + valiant + ".properties");
            rfile = new File(rname);
            if (rfile != null && rfile.exists()) {
                return new PropertyResourceBundle(new FileInputStream(rfile));
            }
            rname = new String(String.valueOf(dir) + File.separator + str + "_" + lang + "_" + con + ".properties");
            rfile = new File(rname);
            if (rfile != null && rfile.exists()) {
                return new PropertyResourceBundle(new FileInputStream(rfile));
            }
            rname = new String(String.valueOf(dir) + File.separator + str + "_" + lang + ".properties");
            rfile = new File(rname);
            if (rfile != null && rfile.exists()) {
                return new PropertyResourceBundle(new FileInputStream(rfile));
            }
            rname = new String(String.valueOf(dir) + File.separator + str + ".properties");
            rfile = new File(rname);
            if (rfile != null && rfile.exists()) {
                return new PropertyResourceBundle(new FileInputStream(rfile));
            }
            if (!loc.equals(Locale.getDefault())) {
                return ResourceBundleEx.getBundle(str, Locale.getDefault(), dir);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return ResourceBundle.getBundle(str, loc);
    }

    public static final ResourceBundle getBundle(String str, String strLoc, String dir) {
        String[] locs = strLoc.split("_");
        Locale loc = null;
        if (locs != null) {
            switch (locs.length) {
                case 1: {
                    loc = new Locale(locs[0]);
                    break;
                }
                case 2: {
                    loc = new Locale(locs[0], locs[1]);
                    break;
                }
                case 3: {
                    loc = new Locale(locs[0], locs[1], locs[2]);
                }
            }
        } else {
            loc = Locale.getDefault();
        }
        return ResourceBundleEx.getBundle(str, loc, dir);
    }
}

