/*
 * Created on 2003/05/25
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.j69.eewiki.plugin;

import java.util.Locale;

import org.apache.struts.action.ActionForm;
import org.apache.struts.util.MessageResources;
import org.j69.eewiki.wiki.Wiki;

/**
 * @author sally
 * プラグインコマンドのためのインターフェース
 */
public interface WikiPluginImp {

	/**
	 * プラグイン識別子のset/get
	 **/ 
	public int getRowid();
	public void setRowid(int rowid);

	public String getPid();
	public void setPid(String pid);

	public String getContextPath();
	public void setContextPath(String contextPath);

	public Locale getLocale();
	public void setLocale(Locale locale);

	public MessageResources getMessageResources();
	public void setMessageResources(MessageResources message);
	
	/**
	 * Wikiデータ作成中でのプラグインコマンドの実行
	 * @param pageData Wikiページデータ
	 * @param options コマンドに対するパラメータ
	 * @param request HttpServletRequest
	 * @return コマンドが作成するHTML文
	 **/ 
	public String execute(String pageData, String[] optinos);

	/**
	 * コンテンツのSubmitボタンから呼ばれるプラグインコマンドの実行
	 * これは、org.j69.eewiki.action.PluginSubmitActionから呼ばれる
	 * @param Wiki
	 **/ 
	public Wiki submit(Wiki wiki, ActionForm form);

}
