/*
 * Created on 2003/06/25
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.j69.eewiki.plugin;

import java.nio.charset.CharacterCodingException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

import org.apache.struts.util.MessageResources;
import org.j69.eewiki.wiki.WikiFile;
import org.j69.eewiki.wiki.WikiList;

/**
 * @author sally
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class PluginRecent extends WikiPlugin {

	/* (non-Javadoc)
	 * @see org.j69.eewiki.plugin.WikiPluginImp#execute(java.lang.String, java.lang.String[], javax.servlet.http.HttpServletRequest)
	 */
	public String execute(
		String pageData,
		String[] optinos) {

		//定義情報の取得
		//最大履歴表示数(設定済みの)
		int constMax = Integer.parseInt(config_.getConfig("define.new.maxrows"));
		int setMax = constMax;
		//最大履歴表示数（パラメータ）
		if (optinos != null) {
			setMax = Integer.parseInt(optinos[0]);	
			//設定済みの最大数よりは、大きくさせない
			if (setMax > constMax)
				setMax = constMax;
		}
			
		//Wikiデータの起点でディレクトリ
		String base_ = config_.getConfig("define.wiki.basedir");
		base_ = base_ + config_.getConfig("define.dir.data");
		
		//View.doのコンテキストパス
		String viewPath = super.getContextPath() + "/Viewpage.do";

		//メッセージ
		MessageResources msg = super.getMessageResources();
		
		//WikiListの作成
		WikiList wikilist = new WikiList(base_);
		Vector datas = wikilist.getWikiFiles(null, "date");
	
		//HTML文の作成
		String htmlOut = "<h5 class=\"side_label\">" + msg.getMessage(super.getLocale(), "caption.recent.title", Integer.toString(setMax))  + "</h5><span class=\"small\">";
		String dateStr = "";
		for(Iterator it = datas.iterator(); it.hasNext();) {
			if (setMax-- < 1)
				break;
			try {
				WikiFile wikifile = (WikiFile)it.next();
				//異なる日付の場合、日付を変更してHTMLに出力
				//ここでは、日付は西暦表示YYYY-MM-DDだけなのでLocaleはenでOK
				if (!dateStr.equals(wikifile.getLastmodDateAsString(new Locale("en")))) {
					dateStr = wikifile.getLastmodDateAsString(new Locale("en"));
					htmlOut = htmlOut + "<b>" + dateStr + "</b>";
				}
				//タイトル名とリンク先の出力
				htmlOut = htmlOut + "<ul class=\"recent_list\"><li><a href=" + viewPath + "?pid=" + wikifile.getLinkname()  + ">" 
							  + wikifile.getTitlename() + "</a></li></ul>";
			} catch (CharacterCodingException e) {
				// TODO Auto-generated catch block
				e.getMessage();
			}
		}
		htmlOut = htmlOut + "</span>";	
		return htmlOut;
	}

}
