/*
 * Created on 2003/06/25
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.j69.eewiki.plugin;

import org.j69.eewiki.util.StringUtil;
import org.j69.eewiki.wiki.transformer.BasicDataLine;
import org.j69.eewiki.wiki.transformer.DataLine;

/**
 * @author sally
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class PluginContents extends WikiPlugin {

	/* (non-Javadoc)
	 * @see org.j69.eewiki.plugin.WikiPluginImp#execute(java.lang.String, java.lang.String[], javax.servlet.http.HttpServletRequest)
	 */
	public String execute(
		String pageData,
		String[] optinos) {

		final StringBuffer buf = new StringBuffer();
		StringBuffer buffer = new StringBuffer();
		String[] datas = pageData.split("\n");
		for (int i = 0; i < datas.length; i++) {
			if(fastIndex(datas[i], "***")) {
				String name = "postion_" + i;
				buffer.append("---" + makeShortCutAnchorTag(name, datas[i].substring(3)) + "\n");
				datas[i] = datas[i] + makeAnchorNameTag(name);
			} else if(fastIndex(datas[i], "**")) {
				String name = "postion_" + i;
				buffer.append("--" + makeShortCutAnchorTag(name, datas[i].substring(2)) + "\n");
				datas[i] = datas[i] + makeAnchorNameTag(name);
			} else if (fastIndex(datas[i], "*")) {
				String name = "postion_" + i;
				buffer.append("-" + makeShortCutAnchorTag(name, datas[i].substring(1)) + "\n");
				datas[i] = datas[i] + makeAnchorNameTag(name);
			}
		}
		
		//ULDataLineにてUL整形
		DataLine dataLine = new BasicDataLine(), newLine;
		dataLine.init("");
		String[] contents = StringUtil.split(buffer.toString(), "\n");
		for (int i = 0 ; i < contents.length; i++) {
			try {
				newLine = getDataLine(contents[i]);
				buf.append(dataLine.closeTag(newLine));
				buf.append(newLine.openTag(dataLine));
				dataLine = newLine;
				buf.append(dataLine.get(i));
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.getMessage();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.getMessage();
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.getMessage();
			}
		}
		return buf.toString();
	}

	/**
	 * Method removeArray.
	 * @param datas
	 * @param i
	 * @return String[]
	 */
	private String[] removeArray(String[] src, int pos) {
		String[] dest = new String[src.length - 1];
		for (int i = 0, index = 0; i < src.length; i++) {
			if(i != pos) {
				dest[index] = src[i];
				index++;
			}
		}
		return dest;
	}

	/**
	 * Method makeShortCutAnchorTag.
	 * @param name
	 * @param string
	 * @return String
	 */
	private String makeShortCutAnchorTag(String name, String text) {
		return "<a href=#" + name + ">" + text + "</a>";
	}

	/**
	 * Method makeAnchorNameTag.
	 * @param name
	 * @return String
	 */
	private String makeAnchorNameTag(String name) {
		return "<a name=" + name + "> </a>";
	}

	/**
	 * 文字列中の先頭にキーワードがあるかどうか
	 * 
	 * @param str 対象文字列
	 * @param keyword キーワード
	 * @return true キーワードあり、false キーワードなし
	 **/ 
	private static boolean fastIndex(String str, String keyword) {
		int index = str.indexOf(keyword);
		return ( index == 0 ? true : false );
	}

	/**
	 * DataLine クラス作成.
	 *
	 * @param dataLine クラス名
	 * @return DataLine クラス
	 **/
	private DataLine createDataLine(String dataLine)
		throws InstantiationException,
				IllegalAccessException,
				ClassNotFoundException {
		return (DataLine) ((Class.forName(dataLine)).newInstance());
	}

	/**
	 * ULDataLine 取得
	 **/
	private DataLine getDataLine(String data)
		throws InstantiationException,
				IllegalAccessException,
				ClassNotFoundException {

		//タグをクローズさせるため必要
		if (data.equals(null) || data.equals("")) {
			//通常データ
			DataLine dataLine = new BasicDataLine();
			dataLine.init(data);
			return dataLine;
		}
		DataLine dataLine = createDataLine("org.j69.eewiki.wiki.transformer.ULDataLine");
		dataLine.init(data);
		return dataLine;
	}
}
