/*
 * This code is based on an example provided by Richard Stanford, 
 * a tutorial reader.
 */

package org.j69.eewiki.jtree;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;

public class DynamicTreeDemo extends JPanel {
	private int newNodeSuffix = 1;

	public DynamicTreeDemo(JFrame frame) {
		//create the components
		final DynamicTree treePanel = new DynamicTree();
		populateTree(treePanel);

		JButton addButton = new JButton("Add");
		addButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				treePanel.addObject("New Node " + newNodeSuffix++);
			}
		});

		JButton removeButton = new JButton("Remove");
		removeButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				treePanel.removeCurrentNode();
			}
		});

		JButton clearButton = new JButton("Clear");
		clearButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				treePanel.clear();
			}
		});

		//Lay everything out.
		setLayout(new BorderLayout());
		treePanel.setPreferredSize(new Dimension(300, 150));
		add(treePanel, BorderLayout.CENTER);

		JPanel panel = new JPanel();
		panel.setLayout(new GridLayout(0,1));
		panel.add(addButton);
		panel.add(removeButton);
		panel.add(clearButton);
		add(panel, BorderLayout.EAST);
	}

	public void populateTree(DynamicTree treePanel) {
		String p1Name = new String("Parent 1");
		String p2Name = new String("Parent 2");
		String c1Name = new String("Child 1");
		String c2Name = new String("Child 2");

		DefaultMutableTreeNode p1, p2;

		p1 = treePanel.addObject(null, p1Name);
		p2 = treePanel.addObject(null, p2Name);

		treePanel.addObject(p1, c1Name);
		treePanel.addObject(p1, c2Name);

		treePanel.addObject(p2, c1Name);
		treePanel.addObject(p2, c2Name);
	}

	public static void main(String[] args) {
		JFrame frame = new JFrame("DynamicTreeDemo");

		Container contentPane = frame.getContentPane();
		contentPane.setLayout(new GridLayout(1,1));
		contentPane.add(new DynamicTreeDemo(frame));

		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});

		frame.pack();
		frame.setVisible(true);
	}

	public static JFrame getJFrame(JFrame frame) {

		Container contentPane = frame.getContentPane();
		contentPane.setLayout(new GridLayout(1,1));
		contentPane.add(new DynamicTreeDemo(frame));

		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});

		frame.pack();
		frame.setVisible(true);
		return frame;
	}

}
