/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.expr.Predicate;
import org.jaxen.function.BooleanFunction;

class PredicateSet {
    private List predicates = Collections.EMPTY_LIST;

    public void addPredicate(Predicate predicate) {
        if (this.predicates == Collections.EMPTY_LIST) {
            this.predicates = new ArrayList();
        }
        this.predicates.add(predicate);
    }

    protected boolean evaluateAsBoolean(List contextNodeSet, ContextSupport support) throws JaxenException {
        this.evaluatePredicates(contextNodeSet, support);
        return contextNodeSet.isEmpty() ^ true;
    }

    protected void evaluatePredicates(List contextNodeSet, ContextSupport support) throws JaxenException {
        ArrayList newNodeSet = new ArrayList();
        List predicates = this.getPredicates();
        Iterator predIter = predicates.iterator();
        Predicate eachPred = null;
        Object contextNode = null;
        int contextSize = 0;
        Object predResult = null;
        Context predContext = new Context(support);
        while (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            contextSize = contextNodeSet.size();
            int i = 0;
            while (i < contextSize) {
                contextNode = contextNodeSet.get(i);
                ArrayList<Object> list = new ArrayList<Object>(1);
                list.add(contextNode);
                predContext.setNodeSet(list);
                predContext.setPosition(i + 1);
                predContext.setSize(contextSize);
                predResult = eachPred.evaluate(predContext);
                if (predResult instanceof Number) {
                    int proximity = ((Number)predResult).intValue();
                    if (proximity == i + 1) {
                        newNodeSet.add(contextNode);
                    }
                } else {
                    Boolean includes = BooleanFunction.evaluate(predResult);
                    if (includes.booleanValue()) {
                        newNodeSet.add(contextNode);
                    }
                }
                ++i;
            }
            contextNodeSet.clear();
            contextNodeSet.addAll(newNodeSet);
            newNodeSet.clear();
        }
    }

    public List getPredicates() {
        return this.predicates;
    }

    public String getText() {
        StringBuffer buf = new StringBuffer();
        Iterator predIter = this.predicates.iterator();
        Predicate eachPred = null;
        while (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            buf.append(eachPred.getText());
        }
        return buf.toString();
    }

    public void simplify() {
        Iterator predIter = this.predicates.iterator();
        Predicate eachPred = null;
        while (predIter.hasNext()) {
            eachPred = (Predicate)predIter.next();
            eachPred.simplify();
        }
    }
}

