/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.ruru.park.ando.ee2e.xmledit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class XMLDoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;

    public void doubleClicked(ITextViewer part) {
        int pos = part.getSelectedRange().x;
        if (pos < 0) {
            return;
        }
        this.fText = part;
        if (!this.selectComment(pos)) {
            this.selectWord(pos);
        }
    }

    protected boolean selectComment(int caretPos) {
        IDocument doc = this.fText.getDocument();
        try {
            int pos = caretPos;
            int c = 32;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (c == 92) {
                    pos -= 2;
                    continue;
                }
                if (c == 13 || c == 34) break;
                --pos;
            }
            if (c != 34) {
                return false;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            c = 32;
            while (pos < length) {
                c = doc.getChar(pos);
                if (c == 13 || c == 34) break;
                ++pos;
            }
            if (c != 34) {
                return false;
            }
            int endPos = pos;
            int offset = startPos + 1;
            int len = endPos - offset;
            this.fText.setSelectedRange(offset, len);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected boolean selectWord(int caretPos) {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos = caretPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            int endPos = pos;
            this.selectRange(startPos, endPos);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void selectRange(int startPos, int stopPos) {
        int offset = startPos + 1;
        int length = stopPos - offset;
        this.fText.setSelectedRange(offset, length);
    }
}

