/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.ruru.park.ando.ee2e.scratch;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import jp.ne.ruru.park.ando.ee2e.EE2EPlugin;
import jp.ne.ruru.park.ando.ee2e.scratch.EE2EFileJumpAction;
import jp.ne.ruru.park.ando.ee2e.scratch.EE2EFileSystemJumpAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class EE2EScratchView
extends ViewPart {
    private Text text;

    public void setFocus() {
        this.text.setFocus();
    }

    public String getSelectionText() {
        String selection = this.text.getSelectionText();
        return selection;
    }

    public void createPartControl(Composite parent) {
        ImageDescriptor image;
        this.setTitle(this.getScratchTitle());
        this.text = new Text(parent, 770);
        Action clearAction = new Action(EE2EPlugin.getResourceString("message.delete")){

            public void run() {
                EE2EScratchView.this.deleteAll();
            }
        };
        try {
            URL prefix = new URL(EE2EPlugin.getDefault().getDescriptor().getInstallURL(), "icons/");
            image = ImageDescriptor.createFromURL((URL)new URL(prefix, "ee2eerase.gif"));
        }
        catch (MalformedURLException malformedURLException) {
            image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_WARN_TSK");
        }
        clearAction.setImageDescriptor(image);
        Action fileJump = new Action(EE2EPlugin.getResourceString("message.editor")){

            public void run() {
                EE2EFileJumpAction action = new EE2EFileJumpAction();
                action.init((IViewPart)EE2EScratchView.this);
                action.run((IAction)this);
            }
        };
        try {
            URL prefix = new URL(EE2EPlugin.getDefault().getDescriptor().getInstallURL(), "icons/");
            image = ImageDescriptor.createFromURL((URL)new URL(prefix, "ee2e.gif"));
        }
        catch (MalformedURLException malformedURLException) {
            image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
        }
        fileJump.setImageDescriptor(image);
        fileJump.setToolTipText(EE2EPlugin.getResourceString("action.filejump.tooltip"));
        Action fileSystemJump = new Action(EE2EPlugin.getResourceString("message.system")){

            public void run() {
                EE2EFileSystemJumpAction action = new EE2EFileSystemJumpAction();
                action.init((IViewPart)EE2EScratchView.this);
                action.run((IAction)this);
            }
        };
        try {
            URL prefix = new URL(EE2EPlugin.getDefault().getDescriptor().getInstallURL(), "icons/");
            image = ImageDescriptor.createFromURL((URL)new URL(prefix, "ee2esystem.gif"));
        }
        catch (MalformedURLException malformedURLException) {
            image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_TASK_TSK");
        }
        fileSystemJump.setImageDescriptor(image);
        fileSystemJump.setToolTipText(EE2EPlugin.getResourceString("action.filejump.system.tooltip"));
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager manager = bars.getMenuManager();
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)fileJump);
        manager.add((IAction)fileJump);
        toolBarManager.add((IAction)fileSystemJump);
        manager.add((IAction)fileSystemJump);
        toolBarManager.add((IAction)clearAction);
        manager.add((IAction)clearAction);
    }

    protected File getParent() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        if (workbenchPage == null) {
            return null;
        }
        IEditorPart editorPart = workbenchPage.getActiveEditor();
        if (editorPart == null) {
            return null;
        }
        IEditorInput editorInput = editorPart.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        if (!(editorInput instanceof IFileEditorInput)) {
            return null;
        }
        IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
        IFile file = fileEditorInput.getFile();
        if (file == null) {
            return null;
        }
        IPath path = file.getLocation();
        if (path == null) {
            return null;
        }
        return path.toFile();
    }

    protected String getScratchTitle() {
        return "*scratch*";
    }

    public void append(String string) {
        this.text.append(string);
    }

    public void deleteAll() {
        this.text.setText("");
    }

    public void setOffset(int start, int end) {
        if (start < end) {
            this.text.setSelection(start, end);
        } else {
            this.text.setSelection(start);
        }
    }

    protected Text getText() {
        return this.text;
    }
}

