/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.ruru.park.ando.ee2e.scratch;

import java.io.File;
import jp.ne.ruru.park.ando.ee2e.EE2EDebug;
import jp.ne.ruru.park.ando.ee2e.EE2EPlugin;
import jp.ne.ruru.park.ando.ee2e.scratch.EE2EScratchView;
import jp.ne.ruru.park.ando.ee2e.typeset.EE2EReasonedFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.internal.ui.views.console.ConsoleView;
import org.eclipse.debug.internal.ui.views.console.ConsoleViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class EE2EConsoleAction
implements IViewActionDelegate {
    private static final String DEFALT_EDITOR = "org.eclipse.jdt.ui.DefaultTextEditor";
    private IViewPart view;
    private EE2EReasonedFile reasonedFile = new EE2EReasonedFile();

    public void init(IViewPart view) {
        this.view = view;
    }

    public void run(IAction action) {
        block7: {
            try {
                if (this.view instanceof ConsoleView) {
                    this.runConsole((ConsoleView)this.view);
                    break block7;
                }
                if (this.view instanceof EE2EScratchView) {
                    this.runScratch((EE2EScratchView)this.view);
                    break block7;
                }
                throw new PartInitException(String.valueOf(this.view.toString()) + " not understand!");
            }
            catch (PartInitException e) {
                EE2EPlugin plugin = EE2EPlugin.getDefault();
                if (plugin == null) {
                    EE2EDebug.printf(1, "EE2EPlugin not found!");
                    return;
                }
                IWorkbench bentch = plugin.getWorkbench();
                if (bentch == null) {
                    EE2EDebug.printf(1, "IWorkbench not found!");
                    return;
                }
                IWorkbenchWindow window = bentch.getActiveWorkbenchWindow();
                if (window == null) {
                    EE2EDebug.printf(1, "IWorkbenchWindow not found!");
                    return;
                }
                DialogUtil.openError((Shell)window.getShell(), (String)WorkbenchMessages.getString((String)"OpenWithMenu.dialogTitle"), (String)e.getMessage(), (PartInitException)e);
            }
        }
    }

    protected void runConsole(ConsoleView consoleView) throws PartInitException {
        Viewer viewer = consoleView.getViewer();
        if (!(viewer instanceof ConsoleViewer)) {
            throw new PartInitException("ConsoleViewer not found!");
        }
        ConsoleViewer consoleViewer = (ConsoleViewer)viewer;
        ISelection selection = consoleViewer.getSelection();
        if (!(selection instanceof TextSelection)) {
            throw new PartInitException("TextSelection not found!");
        }
        TextSelection textSelection = (TextSelection)selection;
        String selected = textSelection.getText();
        if (selected == null || textSelection.getLength() <= 0) {
            int offset = textSelection.getOffset();
            IDocument document = consoleViewer.getDocument();
            try {
                IRegion region = document.getLineInformationOfOffset(offset);
                selected = document.get(region.getOffset(), region.getLength());
            }
            catch (BadLocationException e) {
                throw new PartInitException(e.getMessage());
            }
            if (selected == null) {
                throw new PartInitException("Rigion not found!");
            }
        }
        File parent = null;
        this.actionStart(selected, parent);
    }

    protected void runScratch(EE2EScratchView scratchView) throws PartInitException {
        String selected = scratchView.getSelectionText();
        if (selected == null || selected.equals("")) {
            throw new PartInitException("Region not found!");
        }
        File parent = scratchView.getParent();
        this.actionStart(selected, parent);
    }

    protected abstract void actionStart(String var1, File var2) throws PartInitException;

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected void openEditor(IFile anserFile, boolean flag) throws PartInitException {
        if (anserFile == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (!flag) {
            page.openSystemEditor(anserFile);
            return;
        }
        EditorRegistry registry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descripter = registry.getDefaultEditor(anserFile);
        String targetId = descripter == null ? DEFALT_EDITOR : descripter.getId();
        IEditorPart editorPart = page.openEditor(anserFile, targetId);
        this.gotoLine(editorPart);
    }

    public void gotoLine(IEditorPart editorPart) throws PartInitException {
        if (this.reasonedFile.getLineNumber() <= 0) {
            EE2EDebug.printf(1, "not number");
            return;
        }
        if (!(editorPart instanceof AbstractTextEditor)) {
            EE2EDebug.printf(1, "not AbstractTextEditor!!");
            return;
        }
        AbstractTextEditor editor = (AbstractTextEditor)editorPart;
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)editor.getEditorInput());
        try {
            int lineNumber = this.reasonedFile.getLineNumber();
            int start = document.getLineOffset(lineNumber - 1);
            editor.selectAndReveal(start, 0);
            IWorkbenchWindow window = EE2EPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            page.activate((IWorkbenchPart)editor);
        }
        catch (BadLocationException e) {
            throw new PartInitException("BadLocationException e=" + e.getMessage());
        }
    }

    protected EE2EReasonedFile getReasonedFile() {
        return this.reasonedFile;
    }
}

