/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.ruru.park.ando.ee2e.run;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jp.ne.ruru.park.ando.ee2e.EE2EDebug;
import jp.ne.ruru.park.ando.ee2e.EE2EPlugin;
import jp.ne.ruru.park.ando.ee2e.cf.EE2ECF;
import jp.ne.ruru.park.ando.ee2e.cf.EE2EGetFactory;
import jp.ne.ruru.park.ando.ee2e.editors.EE2EToolkit;
import jp.ne.ruru.park.ando.ee2e.relax.EE2REe2e;
import jp.ne.ruru.park.ando.ee2e.relax.EE2RProcessList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class EE2EMainTab
extends AbstractLaunchConfigurationTab {
    private Label titleLabel;
    private Text parentText;
    private Text fileText;
    private Text[] argumentText;
    private String[] argumentString;
    public static final int ARGUMENT_MAX = 24;
    private Combo combo;
    private Button fWorkingDirBrowseButton;
    private String parentString;
    private String fileString;
    private List comboList;
    public static final String FILE = "jp.ne.ruru.park.ando.ee2e.FILE";
    public static final String ARGUMENT = "jp.ne.ruru.park.ando.ee2e.ARGUMENT";
    public static final String PARENT = "jp.ne.ruru.park.ando.ee2e.PARENT";
    public VerifyListener changeListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            EE2EMainTab.this.updateLaunchConfigurationDialog();
        }
    };
    private EE2RProcessList nextProcess;

    public String getFileName() {
        EE2EDebug.printf(3, "EE2EMainTab#getFileName start");
        return this.fileText.getText();
    }

    protected Text[] getArgumentText() {
        return this.argumentText;
    }

    protected Text getFileText() {
        return this.fileText;
    }

    protected Text getParentText() {
        return this.parentText;
    }

    public void createControl(Composite parent) {
        EE2EDebug.printf(3, "EE2EMainTab#createControl start");
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 1;
        gridLayout.makeColumnsEqualWidth = true;
        comp.setLayout((Layout)gridLayout);
        this.titleLabel = new Label(comp, 16384);
        this.titleLabel.setLayoutData((Object)this.getGridData(1));
        this.combo = new Combo(comp, 8);
        this.combo.setLayoutData((Object)this.getGridData(3));
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                EE2EMainTab.this.handleComboSelected();
            }
        });
        Label label = new Label(comp, 16384);
        label.setLayoutData((Object)this.getGridData(1));
        label.setText(EE2EPlugin.getResourceString("run.main.parent"));
        this.parentText = new Text(comp, 4);
        this.parentText.setLayoutData((Object)this.getGridData(3));
        this.parentText.addVerifyListener(this.changeListener);
        label = new Label(comp, 16384);
        label.setLayoutData((Object)this.getGridData(3));
        this.fWorkingDirBrowseButton = this.createPushButton(comp, EE2EPlugin.getResourceString("run.main.folder"), null);
        this.fWorkingDirBrowseButton.setLayoutData((Object)this.getGridData(1));
        this.fWorkingDirBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                EE2EMainTab.this.handleParentDirBrowseButtonSelected();
            }
        });
        label = new Label(comp, 16384);
        label.setLayoutData((Object)this.getGridData(1));
        label.setText(this.getParentLabelName());
        this.fileText = new Text(comp, 4);
        this.fileText.setLayoutData((Object)this.getGridData(3));
        this.fileText.addVerifyListener(this.changeListener);
        this.fWorkingDirBrowseButton = this.createPushButton(comp, EE2EPlugin.getResourceString("run.main.file"), null);
        this.fWorkingDirBrowseButton.setLayoutData((Object)this.getGridData(1));
        this.fWorkingDirBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                EE2EMainTab.this.handleWorkingFileBrowseButtonSelected();
            }
        });
        this.fWorkingDirBrowseButton = this.createPushButton(comp, EE2EPlugin.getResourceString("run.main.save"), null);
        this.fWorkingDirBrowseButton.setLayoutData((Object)this.getGridData(1));
        this.fWorkingDirBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                EE2EMainTab.this.handleWorkingSaveBrowseButtonSelected();
            }
        });
        this.fWorkingDirBrowseButton = this.createPushButton(comp, EE2EPlugin.getResourceString("run.main.load"), null);
        this.fWorkingDirBrowseButton.setLayoutData((Object)this.getGridData(1));
        this.fWorkingDirBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                EE2EMainTab.this.handleWorkingLoadBrowseButtonSelected();
            }
        });
        this.fWorkingDirBrowseButton = this.createPushButton(comp, EE2EPlugin.getResourceString("run.main.base"), null);
        this.fWorkingDirBrowseButton.setLayoutData((Object)this.getGridData(1));
        this.fWorkingDirBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                EE2EMainTab.this.handleWorkingBaseBrowseButtonSelected();
            }
        });
        label = new Label(comp, 16384);
        label.setText(EE2EPlugin.getResourceString("run.main.argument"));
        label.setLayoutData((Object)this.getGridData(4));
        this.argumentText = new Text[24];
        int i = 0;
        while (i < this.argumentText.length) {
            this.argumentText[i] = new Text(comp, 4);
            this.argumentText[i].setLayoutData((Object)this.getGridData(2));
            this.argumentText[i].addVerifyListener(this.changeListener);
            ++i;
        }
        this.setInitializeData();
    }

    public String getParentLabelName() {
        return EE2EPlugin.getResourceString("run.main.exe");
    }

    public GridData getGridData(int span) {
        GridData grid1 = new GridData();
        grid1.horizontalAlignment = 4;
        grid1.horizontalSpan = span;
        return grid1;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        EE2EDebug.printf(3, "EE2EMainTab#setDefaults start");
        try {
            String target;
            if (this.parentText != null && this.parentText.getText() != null && !(target = configuration.getAttribute(PARENT, "")).equals(this.parentText.getText())) {
                configuration.setAttribute(PARENT, this.parentText.getText());
            }
            if (this.fileText != null && this.fileText.getText() != null && !(target = configuration.getAttribute(FILE, "")).equals(this.fileText.getText())) {
                configuration.setAttribute(FILE, this.fileText.getText());
            }
            if (this.argumentText != null) {
                int i = 0;
                while (i < this.argumentText.length) {
                    String text;
                    String target2 = configuration.getAttribute(ARGUMENT + i, "");
                    if (!target2.equals(text = this.argumentText[i].getText())) {
                        configuration.setAttribute(ARGUMENT + i, text);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            EE2EDebug.printf(1, "CoreException e=" + e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        EE2EDebug.printf(3, "EE2EMainTab#performApply start");
        this.setDefaults(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        EE2EDebug.printf(3, "EE2EMainTab#initializeFrom start");
        try {
            EE2ECF eE2ECF = this.getEE2ECF();
            this.comboList = new LinkedList();
            String titleString = EE2EPlugin.getResourceString("run.main.combo");
            if (eE2ECF != null) {
                titleString = String.valueOf(titleString) + "/" + eE2ECF.getFactoryName() + "-mode";
                EE2REe2e ee2e = EE2EToolkit.get().getEe2e(eE2ECF.getFactoryName());
                int i = 0;
                while (i < ee2e.getProcessListCount()) {
                    EE2RProcessList process = ee2e.getProcessList(i);
                    if (process.getIsJava() == this.checkJava() && (process.getIsUnix() && this.isUnix() || !process.getIsUnix() && !this.isUnix())) {
                        this.comboList.add(process.getProcessName());
                    }
                    ++i;
                }
            }
            this.titleLabel.setText(titleString);
            String parent = this.getChangeString("%M");
            String file = this.getChangeString("%K");
            this.parentString = configuration.getAttribute(PARENT, parent);
            this.fileString = configuration.getAttribute(FILE, file);
            this.argumentString = new String[24];
            int i = 0;
            while (i < 24) {
                this.argumentString[i] = configuration.getAttribute(ARGUMENT + i, "");
                ++i;
            }
        }
        catch (CoreException e) {
            EE2EDebug.printf(1, "SinitializeFrom e=" + e.getMessage());
        }
        this.setInitializeData();
    }

    protected boolean checkJava() {
        return false;
    }

    protected boolean isUnix() {
        return File.separatorChar == '/';
    }

    public void setInitializeData() {
        EE2EDebug.printf(3, "EE2EMainTab#setInitializeData start");
        if (this.combo != null && this.comboList != null) {
            Iterator ite = this.comboList.iterator();
            this.nextProcess = null;
            this.combo.removeAll();
            while (ite.hasNext()) {
                String str = (String)ite.next();
                this.combo.add(str);
            }
        }
        if (this.fileText != null && this.fileString != null) {
            this.fileText.setText(this.fileString);
        }
        if (this.parentText != null && this.parentString != null) {
            this.parentText.setText(this.parentString);
        }
        if (this.argumentText != null && this.argumentString != null) {
            int i = 0;
            while (i < 24) {
                this.argumentText[i].setText(this.argumentString[i]);
                ++i;
            }
        }
    }

    public String getName() {
        return EE2EPlugin.getResourceString("run.main");
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }

    protected void handleParentDirBrowseButtonSelected() {
        String selectedDirectory;
        File path;
        EE2EDebug.printf(3, "EE2EMainTab#handleParentDirBrowseButtonSelected start");
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        String currentWorkingDir = this.fileText.getText();
        if (!currentWorkingDir.trim().equals("") && (path = new File(currentWorkingDir)).exists()) {
            dialog.setFilterPath(currentWorkingDir);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.parentText.setText(selectedDirectory);
        }
    }

    protected void handleWorkingFileBrowseButtonSelected() {
        String selectedDirectory;
        File path;
        EE2EDebug.printf(3, "EE2EMainTab#handleWorkingFileBrowseButtonSelected start");
        FileDialog dialog = new FileDialog(this.getShell());
        String currentWorkingDir = this.fileText.getText();
        if (!currentWorkingDir.trim().equals("") && (path = new File(currentWorkingDir)).exists()) {
            dialog.setFilterPath(currentWorkingDir);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.fileText.setText(selectedDirectory);
        }
    }

    protected void handleWorkingSaveBrowseButtonSelected() {
        EE2EDebug.printf(3, "EE2EMainTab#handleWorkingSaveBrowseButtonSelected start");
        if (this.nextProcess != null && this.fileText != null && this.fileText.getText() != null) {
            IPreferenceStore store = EE2EPlugin.getDefault().getPreferenceStore();
            String key = "program_base." + this.nextProcess.getFileType();
            String target = this.fileText.getText();
            store.setValue(key, target);
            EE2EDebug.printf(3, "Load / key=" + key + " result=" + target);
        }
    }

    protected void handleWorkingLoadBrowseButtonSelected() {
        EE2EDebug.printf(3, "EE2EMainTab#handleWorkingLoadBrowseButtonSelected start");
        if (this.nextProcess != null && this.fileText != null) {
            IPreferenceStore store = EE2EPlugin.getDefault().getPreferenceStore();
            String key = "program_base." + this.nextProcess.getFileType();
            String target = store.getString(key);
            EE2EDebug.printf(3, "Load / key=" + key + " result=" + target);
            this.fileText.setText(target);
        } else {
            this.handleWorkingFileBrowseButtonSelected();
        }
    }

    protected void handleWorkingBaseBrowseButtonSelected() {
        EE2EDebug.printf(3, "EE2EMainTab#handleWorkingBaseBrowseButtonSelected start");
        if (this.nextProcess == null) {
            this.handleWorkingFileBrowseButtonSelected();
            return;
        }
        this.fileText.setText(this.getChangeString(this.nextProcess.getFile()));
    }

    protected void handleComboSelected() {
        EE2EDebug.printf(3, "EE2EMainTab#handleComboSelected start");
        EE2ECF eE2ECF = this.getEE2ECF();
        if (eE2ECF == null) {
            return;
        }
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e(eE2ECF.getFactoryName());
        if (ee2e == null) {
            return;
        }
        EE2RProcessList process = null;
        int i = 0;
        while (i < ee2e.getProcessListCount()) {
            process = ee2e.getProcessList(i);
            if (!(process.getIsJava() != this.checkJava() || process.getIsUnix() && !this.isUnix() || !process.getIsUnix() && this.isUnix() || !process.getProcessName().equals(this.combo.getText()))) {
                this.nextProcess = process;
                this.doComboAction();
                return;
            }
            ++i;
        }
    }

    protected void doComboAction() {
        EE2EDebug.printf(3, "EE2EMainTab#doComboAction start");
        if (this.nextProcess == null) {
            return;
        }
        if (this.nextProcess != null) {
            String key = "program_base." + this.nextProcess.getFileType();
            IPreferenceStore store = EE2EPlugin.getDefault().getPreferenceStore();
            String target = store.getString(key);
            if (target == null || target.equals("")) {
                target = this.getChangeString(this.nextProcess.getFile());
            }
            EE2EDebug.printf(3, "Load / key=" + key + " result=" + target);
            this.fileText.setText(target);
        }
        int i = 0;
        while (i < this.argumentText.length) {
            if (i < this.nextProcess.getProcessCount()) {
                this.argumentText[i].setText(this.getChangeString(this.nextProcess.getProcess(i).getArgument()));
            } else {
                this.argumentText[i].setText("");
            }
            ++i;
        }
        this.parentText.setText(this.getChangeString(this.nextProcess.getFolder()));
    }

    public EE2ECF getEE2ECF() {
        EE2EDebug.printf(3, "EE2EMainTab#getEE2ECF start");
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart part = page.getActiveEditor();
        if (part == null) {
            return null;
        }
        IEditorInput input = part.getEditorInput();
        if (input == null) {
            return null;
        }
        String fileName = part.getEditorInput().getName();
        EE2ECF factory = EE2EGetFactory.get().getFactory(fileName);
        if (factory == null) {
            return null;
        }
        return factory;
    }

    public String getChangeString(String request) {
        if (request == null || request.length() < 1) {
            return "";
        }
        StringBuffer answerBuffer = new StringBuffer();
        int i = 0;
        while (i < request.length()) {
            char ch = request.charAt(i);
            if (ch == '%' && i < request.length() - 1) {
                answerBuffer.append(this.nextBehavior(request.charAt(i + 1)));
                ++i;
            } else {
                answerBuffer.append(ch);
            }
            ++i;
        }
        return answerBuffer.toString();
    }

    protected String nextBehavior(char target) {
        IEditorInput input;
        IWorkspace iWorkSpase = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = null;
        if (iWorkSpase != null) {
            iWorkspaceRoot = iWorkSpase.getRoot();
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart part = page.getActiveEditor();
        IFile file = null;
        if (part != null && (input = part.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            file = fileInput.getFile();
        }
        IPreferenceStore store = EE2EPlugin.getDefault().getPreferenceStore();
        Date date = new Date();
        switch (target) {
            case '%': {
                return "%";
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return "%" + target;
            }
            case 'g': {
                return this.getFileName();
            }
            case 'G': {
                if (this.getFileName() == null) {
                    return "";
                }
                String parent = new File(this.getFileName()).getParent();
                if (parent == null) {
                    return "";
                }
                return parent;
            }
            case 'h': {
                if (file == null) {
                    return "";
                }
                return file.getFileExtension();
            }
            case 'H': {
                if (file == null) {
                    return "";
                }
                return file.getFullPath().removeFileExtension().toString();
            }
            case 'i': {
                if (file == null) {
                    return "";
                }
                String name = file.getName();
                int dotLoc = name.indexOf(46);
                if (dotLoc < 0) {
                    return name;
                }
                return name.substring(0, dotLoc);
            }
            case 'I': {
                if (file == null) {
                    return "";
                }
                return file.getName();
            }
            case 'j': {
                if (file == null) {
                    return "";
                }
                return file.getFullPath().toString();
            }
            case 'J': {
                if (file == null) {
                    return "";
                }
                return file.getLocation().toString();
            }
            case 'k': {
                if (file == null) {
                    return "";
                }
                return file.getFullPath().toFile().toString();
            }
            case 'K': {
                if (file == null) {
                    return "";
                }
                return file.getLocation().toFile().toString();
            }
            case 'l': {
                if (file == null) {
                    return "";
                }
                return file.getParent().getFullPath().toString();
            }
            case 'L': {
                if (file == null) {
                    return "";
                }
                return file.getParent().getLocation().toString();
            }
            case 'm': {
                if (file == null) {
                    return "";
                }
                return file.getParent().getFullPath().toFile().toString();
            }
            case 'M': {
                if (file == null) {
                    return "";
                }
                return file.getParent().getLocation().toFile().toString();
            }
            case 'n': {
                return "" + store.getInt("preference.debuglevel");
            }
            case 'p': {
                return store.getString("preference.urljump.host");
            }
            case 'P': {
                return store.getString("preference.urljump.number");
            }
            case 'q': {
                if (iWorkspaceRoot == null) {
                    return "";
                }
                return iWorkspaceRoot.getLocation().toFile().toString();
            }
            case 'Q': {
                if (iWorkspaceRoot == null) {
                    return "";
                }
                if (file == null) {
                    return "";
                }
                String[] segments = file.getParent().getFullPath().segments();
                if (segments.length > 0) {
                    return String.valueOf(iWorkspaceRoot.getLocation().toFile().toString()) + File.separator + segments[0];
                }
                return iWorkspaceRoot.getLocation().toFile().toString();
            }
            case 'w': {
                EE2ECF ee2e = this.getEE2ECF();
                if (ee2e == null) {
                    return "";
                }
                return ee2e.getFactoryName();
            }
            case 'x': {
                SimpleDateFormat format = new SimpleDateFormat("yyyy");
                return format.format(date);
            }
            case 'X': {
                SimpleDateFormat format = new SimpleDateFormat("MM");
                return format.format(date);
            }
            case 'y': {
                SimpleDateFormat format = new SimpleDateFormat("dd");
                return format.format(date);
            }
            case 'Y': {
                SimpleDateFormat format = new SimpleDateFormat("HH");
                return format.format(date);
            }
            case 'Z': {
                SimpleDateFormat format = new SimpleDateFormat("mm");
                return format.format(date);
            }
            case 'z': {
                SimpleDateFormat format = new SimpleDateFormat("ss");
                return format.format(date);
            }
        }
        return "" + target;
    }
}

