/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.ruru.park.ando.ee2e.relax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.ne.ruru.park.ando.ee2e.relax.EE2RStructure;
import jp.ne.ruru.park.ando.ee2e.relax.RStack;
import jp.ne.ruru.park.ando.ee2e.relax.UJAXP;
import jp.ne.ruru.park.ando.ee2e.relax.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EE2RIteration
implements Serializable {
    private String opener_;
    private String closer_;
    private String require_;
    private List structure_ = new ArrayList();

    public EE2RIteration() {
    }

    public EE2RIteration(RStack stack) {
        this.setup(stack);
    }

    public EE2RIteration(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public EE2RIteration(Element element) {
        this.setup(element);
    }

    public EE2RIteration(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public EE2RIteration(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public EE2RIteration(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public EE2RIteration(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public EE2RIteration(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public EE2RIteration(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.opener_ = URelaxer.getAttributePropertyAsString(element, "opener");
        this.closer_ = URelaxer.getAttributePropertyAsString(element, "closer");
        this.require_ = URelaxer.getAttributePropertyAsString(element, "require");
        this.structure_.clear();
        while (!stack.isEmptyElement()) {
            if (!EE2RStructure.isMatch(stack)) break;
            this.addStructure(new EE2RStructure(stack));
        }
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("iteration");
        if (this.opener_ != null) {
            URelaxer.setAttributePropertyByString(element, "opener", this.opener_);
        }
        if (this.closer_ != null) {
            URelaxer.setAttributePropertyByString(element, "closer", this.closer_);
        }
        if (this.require_ != null) {
            URelaxer.setAttributePropertyByString(element, "require", this.require_);
        }
        int size = this.structure_.size();
        int i = 0;
        while (i < size) {
            EE2RStructure value = (EE2RStructure)this.structure_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(uri));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(url));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(in));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(is));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(reader));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getOpener() {
        return this.opener_;
    }

    public final void setOpener(String opener) {
        this.opener_ = opener;
    }

    public final String getCloser() {
        return this.closer_;
    }

    public final void setCloser(String closer) {
        this.closer_ = closer;
    }

    public final String getRequire() {
        return this.require_;
    }

    public final void setRequire(String require) {
        this.require_ = require;
    }

    public final EE2RStructure[] getStructure() {
        EE2RStructure[] array = new EE2RStructure[this.structure_.size()];
        return this.structure_.toArray(array);
    }

    public final void setStructure(EE2RStructure[] structure) {
        this.structure_.clear();
        this.structure_.addAll(Arrays.asList(structure));
    }

    public final void setStructure(EE2RStructure structure) {
        this.structure_.clear();
        this.structure_.add(structure);
    }

    public final void addStructure(EE2RStructure structure) {
        this.structure_.add(structure);
    }

    public final int getStructureCount() {
        return this.structure_.size();
    }

    public final EE2RStructure getStructure(int index) {
        return (EE2RStructure)this.structure_.get(index);
    }

    public final void setStructure(int index, EE2RStructure structure) {
        this.structure_.set(index, structure);
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<iteration");
        if (this.opener_ != null) {
            buffer.append(" opener=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getOpener()));
            buffer.append("\"");
        }
        if (this.closer_ != null) {
            buffer.append(" closer=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getCloser()));
            buffer.append("\"");
        }
        if (this.require_ != null) {
            buffer.append(" require=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getRequire()));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.structure_.size();
        int i = 0;
        while (i < size) {
            EE2RStructure value = (EE2RStructure)this.structure_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</iteration>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<iteration");
        if (this.opener_ != null) {
            buffer.print(" opener=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getOpener()));
            buffer.print("\"");
        }
        if (this.closer_ != null) {
            buffer.print(" closer=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getCloser()));
            buffer.print("\"");
        }
        if (this.require_ != null) {
            buffer.print(" require=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getRequire()));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.structure_.size();
        int i = 0;
        while (i < size) {
            EE2RStructure value = (EE2RStructure)this.structure_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</iteration>");
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "iteration")) {
            return false;
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (!EE2RStructure.isMatchHungry(target)) break;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return EE2RIteration.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (EE2RIteration.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

