/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.ruru.park.ando.ee2e.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public final class EE2ELispBase {
    private static EE2ELispBase instance;

    private EE2ELispBase() {
    }

    public static EE2ELispBase get() {
        if (instance == null) {
            instance = new EE2ELispBase();
        }
        return instance;
    }

    public int beginningOfLine(int offset, IDocument document) throws BadLocationException {
        if (offset <= 0) {
            return 0;
        }
        if ((offset = this.findCharsBackward(offset - 1, "\r\n", document)) <= 0) {
            return 0;
        }
        if (document.getLength() <= ++offset) {
            offset = document.getLength() - 1;
        }
        return offset;
    }

    public int endOfLine(int offset, IDocument document) throws BadLocationException {
        offset = this.findCharsForward(offset, "\r\n", document);
        if (document.getLength() < offset) {
            offset = document.getLength();
        }
        if (--offset < 0) {
            offset = 0;
        }
        return offset;
    }

    public int findCharsBackward(int offset, String ans, IDocument document) throws BadLocationException {
        if (document.getLength() <= offset) {
            offset = document.getLength() - 1;
        }
        while (offset > 0) {
            char dChar = document.getChar(offset);
            int i = 0;
            while (i < ans.length()) {
                if (dChar == ans.charAt(i)) {
                    return offset;
                }
                ++i;
            }
            --offset;
        }
        return offset;
    }

    public int findCharsForward(int offset, String ans, IDocument document) throws BadLocationException {
        return this.findCharsForward(offset, ans, document, document.getLength());
    }

    public int findCharsForward(int offset, String ans, IDocument document, int limmit) throws BadLocationException {
        while (offset < limmit) {
            char dChar = document.getChar(offset);
            int i = 0;
            while (i < ans.length()) {
                if (dChar == ans.charAt(i)) {
                    return offset;
                }
                ++i;
            }
            ++offset;
        }
        return offset;
    }

    public int skipCharsBackward(int offset, String ans, IDocument document) throws BadLocationException {
        return this.skipCharsBackward(offset, ans, document, 0);
    }

    public int skipCharsBackward(int offset, String ans, IDocument document, int limit) throws BadLocationException {
        while (limit < offset) {
            char dChar = document.getChar(offset);
            int i = 0;
            while (i < ans.length()) {
                if (dChar == ans.charAt(i)) break;
                ++i;
            }
            if (ans.length() <= i) break;
            --offset;
        }
        return offset;
    }

    public int skipCharsForward(int offset, String ans, IDocument document) throws BadLocationException {
        return this.skipCharsForward(offset, ans, document, document.getLength());
    }

    public int skipCharsForward(int offset, String ans, IDocument document, int limmit) throws BadLocationException {
        while (offset < limmit) {
            char dChar = document.getChar(offset);
            int i = 0;
            while (i < ans.length()) {
                if (dChar == ans.charAt(i)) break;
                ++i;
            }
            if (ans.length() <= i) break;
            ++offset;
        }
        return offset - 1;
    }

    protected void indentTo(int offset, int size, IDocument document) throws BadLocationException {
        int begin;
        if (size < 0) {
            size = 0;
        }
        int realSize = 0;
        int len = 0;
        boolean tabNotUsedFlag = true;
        int i = begin = this.beginningOfLine(offset, document);
        while (i < document.getLength()) {
            if (document.getChar(i) == ' ') {
                ++realSize;
                ++len;
            } else {
                if (document.getChar(i) != '\t') break;
                ++realSize;
                len += 4;
                tabNotUsedFlag = false;
            }
            ++i;
        }
        if (size == len && tabNotUsedFlag) {
            return;
        }
        StringBuffer buff = new StringBuffer();
        int i2 = 0;
        while (i2 < size) {
            buff.append(' ');
            ++i2;
        }
        document.replace(begin, realSize, buff.toString());
    }

    public int indentLen(int offset, IDocument document) throws BadLocationException {
        int begin = this.beginningOfLine(offset, document);
        int len = 0;
        int i = begin;
        while (i < document.getLength()) {
            if (document.getChar(i) == ' ') {
                ++len;
            } else {
                if (document.getChar(i) != '\t') break;
                len += 4;
            }
            ++i;
        }
        return len;
    }

    protected boolean lookingAt(int argumentOffset, String target, IDocument document) throws BadLocationException {
        int offset = argumentOffset;
        int i = 0;
        while (i < target.length()) {
            char documentChar;
            if (document.getLength() <= offset + i) {
                return false;
            }
            char targetChar = target.charAt(i);
            if (targetChar != (documentChar = document.getChar(offset + i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

