/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.ruru.park.ando.ee2e.editors;

import jp.ne.ruru.park.ando.ee2e.EE2EDebug;
import jp.ne.ruru.park.ando.ee2e.EE2EPlugin;
import jp.ne.ruru.park.ando.ee2e.display.EE2EMiniBufferView;
import jp.ne.ruru.park.ando.ee2e.editors.EE2EIndentBehavior;
import jp.ne.ruru.park.ando.ee2e.editors.EE2ELispBase;
import jp.ne.ruru.park.ando.ee2e.editors.EE2EMenuBehavior;
import jp.ne.ruru.park.ando.ee2e.editors.EE2EToolkit;
import jp.ne.ruru.park.ando.ee2e.relax.EE2RIteration;
import jp.ne.ruru.park.ando.ee2e.relax.EE2RIterationList;
import jp.ne.ruru.park.ando.ee2e.relax.EE2RStructureList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EE2EInsertIterator
implements EE2EMenuBehavior {
    public static final String ITERATOR_LIST_TYPE_XML = "xml";
    private EE2RIterationList iterationList;
    private EE2EIndentBehavior indentBehavior;

    public EE2EInsertIterator(EE2RIterationList iterationList, EE2EIndentBehavior indentBehavior) {
        this.iterationList = iterationList;
        this.indentBehavior = indentBehavior;
    }

    public String getText() {
        return String.valueOf(EE2EPlugin.getResourceString("action.complete.iteration")) + "(&i)";
    }

    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.complete.iteration.tooltip");
    }

    public void doBehavior(AbstractTextEditor editor, IDocument document, ITextSelection textSelection) throws BadLocationException {
        EE2EDebug.printf(3, "EE2EInsertIterator#doBehavior");
        int pos = this.getIterationNumber(document, textSelection.getOffset());
        if (pos < 0) {
            EE2EDebug.printf(4, "not found");
            return;
        }
        EE2RStructureList structureList = new EE2RStructureList();
        structureList.setStructure(this.iterationList.getIteration(pos).getStructure());
        structureList.setDefault("");
        try {
            EE2EToolkit.get().doStructure(structureList, null, null, this.indentBehavior, editor, document, textSelection);
        }
        catch (BadLocationException e) {
            EE2EDebug.printf(1, "BadLocationException!!" + e.getMessage());
            EE2EMiniBufferView.removeEE2EDisplayCompletion();
            return;
        }
    }

    public int getIterationNumber(IDocument document, int offset) throws BadLocationException {
        String data;
        EE2EDebug.printf(3, "EE2EInsertIterator#getIterationNumber");
        if (this.iterationList.getType() == null || !this.iterationList.getType().equals(ITERATOR_LIST_TYPE_XML)) {
            EE2EDebug.printf(1, "type error");
            return -1;
        }
        int nextOffset = offset;
        int pos = 0;
        while (true) {
            int backOffset;
            char nextChar;
            --nextOffset;
            nextOffset = EE2ELispBase.get().findCharsBackward(nextOffset, "<", document);
            if (nextOffset < 0 || document.getChar(nextOffset) != '<') {
                int i = 0;
                while (i < this.iterationList.getIterationCount()) {
                    EE2RIteration iteration = this.iterationList.getIteration(i);
                    if (iteration.getOpener() != null && iteration.getOpener().equals("")) {
                        return i;
                    }
                    ++i;
                }
            }
            if ((nextChar = document.getChar(nextOffset + 1)) == '/') {
                ++pos;
                continue;
            }
            if (nextChar == '?' || nextChar == '@' || nextChar == '!' || nextChar == '[' || nextChar == '%' || (nextChar = document.getChar((backOffset = EE2ELispBase.get().findCharsForward(nextOffset, ">", document)) - 1)) == '/' || --pos >= 0) continue;
            int len = EE2ELispBase.get().findCharsForward(nextOffset + 1, ">< \t\r\n/\"'", document);
            data = document.get(nextOffset + 1, len - (nextOffset + 1));
            if (data != null) break;
            EE2EDebug.printf(10, "data==null (skip)");
        }
        int i = 0;
        while (i < this.iterationList.getIterationCount()) {
            EE2RIteration iteration = this.iterationList.getIteration(i);
            if (iteration.getOpener() != null && !iteration.getOpener().equals("") && iteration.getOpener().equals(data)) {
                return i;
            }
            ++i;
        }
        EE2EDebug.printf(10, "data is not hit! data=" + data);
        return -1;
    }
}

