/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.ruru.park.ando.ee2e.editors;

import jp.ne.ruru.park.ando.ee2e.EE2EPlugin;
import jp.ne.ruru.park.ando.ee2e.editors.EE2EIndentBehavior;
import jp.ne.ruru.park.ando.ee2e.editors.EE2ELispBase;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class EE2EIndentJava
extends EE2EIndentBehavior {
    private int indentLen;

    public EE2EIndentJava(int indentLen) {
        this.indentLen = indentLen;
    }

    protected void doIndent(int argumentOffset, IDocument document) throws BadLocationException {
        int baseLineOffset;
        int firstOffset;
        int offset = EE2ELispBase.get().beginningOfLine(argumentOffset, document);
        if (this.doSharpSheck(offset, document)) {
            EE2ELispBase.get().indentTo(offset, 0, document);
            return;
        }
        int ans = this.checkDocument(offset, document);
        if (ans >= 0) {
            int len = ans;
            if (!this.isMyLineDocument(offset, document)) {
                EE2ELispBase.get().indentTo(offset, len, document);
            }
            EE2ELispBase.get().indentTo(offset, len + 1, document);
            return;
        }
        if (this.isRedundantCircle() && (ans = this.checkCercle(offset, document)) >= 0) {
            int len = ans;
            EE2ELispBase.get().indentTo(offset, len, document);
            return;
        }
        int oneBefore = this.getPrependChar(offset - 1, document, 0);
        if (oneBefore <= 0) {
            EE2ELispBase.get().indentTo(offset, 0, document);
            return;
        }
        int len = 0;
        char targetChar = document.getChar(oneBefore);
        if (targetChar != ';' && targetChar != '}') {
            len += this.indentLen;
        }
        int lastOffset = EE2ELispBase.get().endOfLine(offset, document);
        if ((lastOffset = this.getPrependChar(lastOffset + 1, document, offset)) >= 0 && (targetChar = document.getChar(lastOffset)) == ':') {
            len -= this.indentLen;
        }
        if ((firstOffset = EE2ELispBase.get().skipCharsForward(offset, " \t", document) + 1) < document.getLength() && ((targetChar = document.getChar(firstOffset)) == '}' || targetChar == ']' || targetChar == ')')) {
            len -= this.indentLen;
        }
        if ((len += (baseLineOffset = this.getBaseLineOffset(oneBefore, document))) < 0) {
            len = 0;
        }
        EE2ELispBase.get().indentTo(offset, len, document);
    }

    protected int getBaseLineOffset(int offset, IDocument document) throws BadLocationException {
        int baseLineOffset = EE2ELispBase.get().beginningOfLine(offset, document);
        int oneBefore = offset;
        boolean flag = false;
        while (baseLineOffset >= 0) {
            char targetChar;
            if ((oneBefore = this.getPrependChar(oneBefore - 1, document, 0)) < 0) break;
            if (!(flag || (targetChar = document.getChar(oneBefore)) != ';' && targetChar != ':' && targetChar != '{' && targetChar != '}')) {
                flag = true;
            }
            if (flag && this.isNotInTheCircle(baseLineOffset, offset, document)) break;
            baseLineOffset = oneBefore;
            oneBefore = EE2ELispBase.get().beginningOfLine(oneBefore, document);
        }
        return EE2ELispBase.get().indentLen(baseLineOffset, document);
    }

    protected boolean isNotInTheCircle(int oneBefore, int end, IDocument document) throws BadLocationException {
        int start = EE2ELispBase.get().beginningOfLine(oneBefore, document);
        int pos = 0;
        boolean toriger = false;
        int offset = start;
        while (offset <= end) {
            if (this.isQuoteTorigerCountCheck(offset, document)) {
                toriger = !toriger;
            }
            if (!toriger) {
                char targetChar = document.getChar(offset);
                if (targetChar == ')' || targetChar == ']') {
                    ++pos;
                } else if (targetChar == '(' || targetChar == '[') {
                    --pos;
                }
            }
            ++offset;
        }
        return pos <= 0;
    }

    protected int checkDocument(int offset, IDocument document) throws BadLocationException {
        if (offset < 2) {
            return -1;
        }
        int i = offset - 2;
        while (1 <= i) {
            char ch1 = document.getChar(i - 1);
            char ch2 = document.getChar(i);
            if (ch1 == '*' && ch2 == '/') {
                return -1;
            }
            if (ch1 == '/' && ch2 == '*') {
                int ans = EE2ELispBase.get().indentLen(i, document);
                return ans;
            }
            --i;
        }
        return -1;
    }

    protected boolean isMyLineDocument(int offset, IDocument document) throws BadLocationException {
        int start = EE2ELispBase.get().beginningOfLine(offset, document);
        int next = EE2ELispBase.get().skipCharsForward(start, " \t", document);
        if (document.getLength() <= ++next) {
            return false;
        }
        char ch = document.getChar(next);
        return ch == '*';
    }

    private boolean doSharpSheck(int offset, IDocument document) throws BadLocationException {
        int next = EE2ELispBase.get().skipCharsForward(offset, " \t\r\n", document);
        if (document.getLength() <= ++next) {
            return false;
        }
        char target = document.getChar(next);
        return target == '#';
    }

    private int doCommentSkipOffset(int offset, IDocument document) throws BadLocationException {
        int before = offset - 1;
        if (document.getLength() <= offset) {
            return offset;
        }
        int nowOffset = before;
        while (nowOffset >= 0) {
            char ch1 = document.getChar(nowOffset);
            char ch2 = document.getChar(nowOffset + 1);
            if (ch1 == '*' && ch2 == '/') {
                return offset;
            }
            if (ch1 == '/' && ch2 == '*') {
                return nowOffset;
            }
            --nowOffset;
        }
        return offset;
    }

    protected int getPrependChar(int offset, IDocument document, int min) throws BadLocationException {
        int oneBefore = offset;
        int target = -1;
        boolean commentTriger = false;
        while (min < oneBefore && target < 0) {
            oneBefore = this.doCommentSkipOffset(oneBefore, document);
            if (document.getLength() <= oneBefore) {
                return document.getLength() - 1;
            }
            boolean toriger = false;
            int commentOffset = EE2ELispBase.get().beginningOfLine(oneBefore, document);
            while (commentOffset < oneBefore + 1) {
                char ch = document.getChar(commentOffset);
                if (ch == '#') {
                    toriger = true;
                }
                if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n') break;
                ++commentOffset;
            }
            if (toriger) {
                oneBefore = EE2ELispBase.get().beginningOfLine(oneBefore, document);
                --oneBefore;
                continue;
            }
            toriger = false;
            boolean charTriger = false;
            int begin = EE2ELispBase.get().beginningOfLine(oneBefore, document);
            int commentOffset2 = oneBefore;
            while (begin <= commentOffset2) {
                if (this.isQuoteTorigerCountCheck(commentOffset2, document)) {
                    boolean bl = toriger = !toriger;
                }
                if (!toriger) {
                    char ch = document.getChar(commentOffset2);
                    char ch2 = '\u0000';
                    if (commentOffset2 + 1 < document.getLength()) {
                        ch2 = document.getChar(commentOffset2 + 1);
                    }
                    if (ch == '/' && ch2 == '*') {
                        commentTriger = false;
                    } else if (!commentTriger) {
                        if (ch == '*' && ch2 == '/') {
                            if (target - 1 == commentOffset2) {
                                target = -1;
                                charTriger = false;
                            }
                            commentTriger = true;
                        } else if (ch == '/' && ch2 == '/') {
                            target = -1;
                            charTriger = false;
                        } else if (!charTriger && ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n' && ch != '\\') {
                            target = commentOffset2;
                            charTriger = true;
                        }
                    }
                }
                --commentOffset2;
            }
            if (target >= 0) break;
            oneBefore = EE2ELispBase.get().beginningOfLine(oneBefore, document);
            --oneBefore;
        }
        return target;
    }

    protected int checkCercle(int argOffset, IDocument document) throws BadLocationException {
        int ans = -1;
        int pos = 0;
        boolean toriger = false;
        int offset = argOffset;
        while (offset >= 0) {
            if (this.isQuoteTorigerCountCheck(offset, document)) {
                toriger = !toriger;
            }
            if (!toriger) {
                char ch = document.getChar(offset);
                if (ch == '{' || ch == '}') break;
                if (ch == ')' || ch == ']') {
                    ++pos;
                } else if ((ch == '(' || ch == '[') && --pos < 0) {
                    int start = EE2ELispBase.get().beginningOfLine(offset, document);
                    ans = offset - start + 1;
                    break;
                }
            }
            --offset;
        }
        return ans;
    }

    protected boolean isRedundantCircle() {
        IPreferenceStore store = EE2EPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("preference.compact");
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isQuoteTorigerCountCheck(int offset, IDocument document) throws BadLocationException {
        ans = this.isQuoteToriger(offset, document);
        lineOffset = EE2ELispBase.get().beginningOfLine(offset, document);
        endLineOffset = EE2ELispBase.get().endOfLine(lineOffset, document);
        count = 0;
        if (ans) ** GOTO lbl10
        return ans;
lbl-1000:
        // 1 sources

        {
            if (this.isQuoteToriger(lineOffset, document)) {
                ++count;
            }
            ++lineOffset;
lbl10:
            // 2 sources

            ** while (lineOffset < endLineOffset)
        }
lbl11:
        // 1 sources

        return count % 2 == 0;
    }

    protected boolean isQuoteToriger(int offset, IDocument document) throws BadLocationException {
        boolean ans;
        if (offset < 0 || document.getLength() <= offset) {
            return false;
        }
        char ch = document.getChar(offset);
        boolean bl = ans = ch == '\'' || ch == '\"';
        if (!ans) {
            return false;
        }
        int count = 0;
        --offset;
        while (offset >= 0) {
            ch = document.getChar(offset);
            if (ch != '\\') break;
            ++count;
            --offset;
        }
        return count % 2 == 0;
    }
}

