/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.ruru.park.ando.ee2e.editors;

import jp.ne.ruru.park.ando.ee2e.EE2EDebug;
import jp.ne.ruru.park.ando.ee2e.editors.EE2EMenuBehavior;
import jp.ne.ruru.park.ando.ee2e.editors.EE2EToolkit;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EE2EAction
extends Action {
    private AbstractTextEditor editor;
    private EE2EMenuBehavior behavior;

    public void run() {
        EE2EDebug.printf(10, "EE2EAction:run()");
        IDocument document = EE2EToolkit.get().getEditorToDocument(this.editor);
        if (document == null) {
            EE2EDebug.printf(3, "not document!!");
            return;
        }
        ISelection selection = this.editor.getSelectionProvider().getSelection();
        if (selection == null) {
            EE2EDebug.printf(3, "not selection!!");
            return;
        }
        if (!(selection instanceof ITextSelection)) {
            EE2EDebug.printf(3, "not instanceof ITextSelection!!");
            return;
        }
        if (this.behavior == null) {
            EE2EDebug.printf(3, "tab destroyer not found!!");
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        try {
            this.behavior.doBehavior(this.editor, document, textSelection);
        }
        catch (BadLocationException x) {
            EE2EDebug.printf(3, "BadLocationException!! " + x.getMessage());
        }
        EE2EDebug.printf(10, "EE2EAction:run() end");
    }

    public void setEE2EMenuBehavior(AbstractTextEditor editor, EE2EMenuBehavior eE2ETabDestroyer) {
        this.editor = editor;
        this.behavior = eE2ETabDestroyer;
        if (this.behavior == null) {
            if (this.getText() == null || this.getText().equals("")) {
                this.setText("-----------");
            }
            if (this.getToolTipText() == null || this.getToolTipText().equals("")) {
                this.setToolTipText("-----------");
            }
            return;
        }
        if (this.behavior.getText() != null) {
            this.setText(this.behavior.getText());
        } else if (this.getText() == null || this.getText().equals("")) {
            this.setText("-----------");
        }
        if (this.behavior.getToolTipText() != null) {
            this.setToolTipText(this.behavior.getToolTipText());
        } else if (this.getToolTipText() == null || this.getToolTipText().equals("")) {
            this.setToolTipText("-----------");
        }
    }

    public boolean isEnabled() {
        if (this.editor == null || this.behavior == null) {
            return false;
        }
        return super.isEnabled();
    }
}

