/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE MP3FRAUNHOFERWRITER SOURCE CODE.        *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE MP3FRAUNHOFERWRITER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha  *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#ifndef _MP3FraunhoferWriter_h_
#define _MP3FraunhoferWriter_h_

// ------------------------------------------------------------------------------------------------------------------------
class CMP3FraunhoferWriter : public CBaseFilter, public IFileSinkFilter
{
   friend class CInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CMP3FraunhoferWriter(LPUNKNOWN,HRESULT *);
   ~CMP3FraunhoferWriter();

   // CBaseFilteȑz\bh
   virtual CBasePin *GetPin(int n);
   virtual int GetPinCount();

   // CBaseFilter̃I[o[Ch
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);
   STDMETHODIMP Pause();
   STDMETHODIMP Stop();

   // IFileSinkFilter̃I[o[Ch
   STDMETHODIMP SetFileName(LPCOLESTR, const AM_MEDIA_TYPE *);
   STDMETHODIMP GetCurFile(LPOLESTR *, AM_MEDIA_TYPE *);

   // IMP3FraunhoferInterface
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP CheckBitrate(int);
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, int);
   STDMETHODIMP GetBitrate(int *);
   STDMETHODIMP SetBitrate(int);

private:

   // [Uϐ
   CCritSec m_Lock;
   CCritSec m_ReceiveLock;
   CInputPin *m_pInputPin;
   CPosPassThru *m_pPosition;
   WCHAR m_awFileName[MAX_PATH];
};
// ------------------------------------------------------------------------------------------------------------------------

#endif _MP3FraunhoferWriter_h_
