<?php
/*
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:     function
 * Name:     d3comment_tree
 * Version:  0.1.2
 * Date:     April 13, 2009
 * Author:   naao
 * Purpose:  Shows comment trees in a external link id
 * Input:    
 * 
 * Examples: <{d3comment_tree forum_dirname=$mydirname forum_id=$forum.id topic_id=$topic.id 
 		external_link_id=$topic.external_link_id order="ASC" 
 		postorder=$postorder use_name=$mod_config.use_name item="tree"}>
 *
 * (write in 1 line)
 */
function smarty_function_d3comment_tree($params, &$smarty)
{
	// transitional from 'dirname' -> 'forum_dirname'
	$params['forum_dirname'] = @$params['forum_dirname'] . @$params['dirname'] ;
	$forum_dirname = ! empty( $params['forum_dirname'] ) ? $params['forum_dirname'] : 'd3forum' ;
	$forum_id = ! empty( $params['forum_id'] ) ? intval( $params['forum_id'] ) : 1 ;
	$topic_id = ! empty( $params['topic_id'] ) ? intval( $params['topic_id'] ) : 0 ;
	$external_link_id = ! empty( $params['external_link_id'] ) ? intval( $params['external_link_id'] ) : 1 ;
	$limit = ! empty( $params['limit'] ) ? intval( $params['limit'] ) : 100 ;
	$_order = strtolower(@$params['order']) == 'asc' ? 'ASC' : (strtolower(@$params['order']) == 'desc' ? 'DESC' : '') ;
	$postorder = ! empty( $params['postorder'] ) ? intval( $params['postorder'] ) : 0 ;
	$use_name = ! empty( $params['use_name'] ) ? intval( $params['use_name'] ) : 0 ;
	$item = ! empty( $params['item'] ) ? $params['item'] : 'tree' ;

	if ( $_order != '') {
			$disp_order = $_order ;
			$whr_order = "post_time DESC";
	} else {
		switch ($postorder) {
			case 0:
				$whr_order = "t.topic_id ASC,p.order_in_tree,p.post_id";
				break;
			case 2:
				$disp_order = 'ASC' ;
				$whr_order = "post_time DESC";
				break;		
			case 3:
				$whr_order = "post_time DESC";
				break;
			default:
		}
	}
	
	if( ! preg_match( '/^[0-9a-zA-Z_-]+$/' , $forum_dirname ) || $forum_id <= 0 || $external_link_id <= 0 ) {
		echo "<p>d3comment_tree function does not set properly.</p>" ;
	} else {

		$db =& Database::getInstance() ;
		$myts =& MyTextSanitizer::getInstance() ;

		// main query
		$sql = "SELECT p.*,t.topic_locked,t.topic_id,t.forum_id 
			FROM ".$db->prefix($forum_dirname."_posts")." p 
			LEFT JOIN ".$db->prefix($forum_dirname."_topics")." t ON p.topic_id=t.topic_id 
			WHERE t.forum_id='".$forum_id."' AND (topic_external_link_id='".addslashes($external_link_id)."' 
			OR t.topic_id='".addslashes($topic_id)."') ORDER BY ".$whr_order." LIMIT ".$limit ;

		if( ! $trs = $db->query( $sql ) ) die( _MD_D3FORUM_ERR_SQL.__LINE__ ) ;
		$user_handler =& xoops_gethandler( 'user' ) ;
		
		$topics_count = 0;
		$topic_last_id = 0;
		while( $post_row = $db->fetchArray( $trs ) ) {

			// get this poster's object
			$poster_obj =& $user_handler->get( intval( $post_row['uid'] ) ) ;
			if( is_object( $poster_obj ) ) {
				if ( $use_name ==1 ) {
					$poster_uname4disp = $poster_obj->getVar( 'name' ) ;
				} else {
					$poster_uname4disp = $poster_obj->getVar( 'uname' ) ;
				}
			} else {
				$poster_uname4disp = "" ;
			}

			$poster_uname4disp = $poster_uname4disp ? $poster_uname4disp : $myts->makeTboxData4Show( $post_row['guest_name'] ) ;
			// posts array
			$posts[] = array(
				'id' => intval( $post_row['post_id'] ) ,
				'subject' => $myts->makeTboxData4Show( $post_row['subject'] , $post_row['number_entity'] , $post_row['special_entity'] ) ,
				'post_time_formatted' => formatTimestamp( $post_row['post_time'] , 'm' ) ,
				'poster_uid' => intval( $post_row['uid'] ) ,
				'poster_uname' => $poster_uname4disp ,
				'icon' => intval( $post_row['icon'] ) ,
				'depth_in_tree' => intval( $post_row['depth_in_tree'] ) ,
				'order_in_tree' => intval( $post_row['order_in_tree'] ) ,
				'topic_id' => intval( $post_row['topic_id'] ) ,
				'ul_in' => '<ul><li>' ,
				'ul_out' => '</li></ul>' ,
			) ;
			if (intval( $post_row['topic_id'] ) != $topic_last_id) {
				$topics_count ++ ;
				$topic_last_id = intval( $post_row['topic_id'] );
			}
		}
		
		// reverse array if order is "ASC"
		if (($disp_order == 'ASC') && ($posts)) {$posts = array_reverse($posts);}
		
		$assign_name = @$params['item'] . @$params['assign'] ;
		$smarty->assign( $assign_name , $posts ) ;
		$smarty->assign( $assign_name."_tp_count" , $topics_count ) ;
	}
}
?>
