#!/usr/bin/perl
=head1 NAME

ファイル出力サンプル

=head2 概要

test.css,test.htmlをtest.pdfに変換します。

=cut
use strict;
use lib '../code';
use CTI::DriverManager;

my $uri = 'ctip://localhost:8099/';
my $session = CTI::DriverManager::get_session($uri,
	user => 'user', password => 'kappa');

$session->set_output_as_file('test.pdf');
$session->set_message_func (sub {
	my ($code, $message, @args) = @_;
	print STDERR "$message\n";
});

$session->property("output.pdf.compression", "none");

$session->start_resource(*STDOUT, 'file:/test.css');
open(RFP, '<test.css');
while (<RFP>) {print};
close(RFP);
$session->end_resource(*STDOUT);

$session->start_main(*STDOUT, 'file:/test.html');
open(MFP, '<test.html');
while (<MFP>) {print};
close(MFP);
$session->end_main(*STDOUT);

$session->close();

print "Location: test.pdf\n\n";
