#!/usr/bin/perl
=head1 NAME

コンテンツ変換サンプル

=head2 概要

start_mainとend_mainの間の出力結果をPDFに変換します。

=cut
use strict;
use lib '../code';
use CTI::DriverManager;

my $uri = 'ctip://localhost:8099/';
my $session = CTI::DriverManager::get_session($uri,
	user => 'user', password => 'kappa');
	
$session->set_output_as_handle(*STDOUT, 1);

# リソースの送信
$session->start_resource(*STDOUT, 'skin.css');
print << 'EOF';
  p {
  	background-color: Gray;
  }
EOF
$session->end_resource(*STDOUT);

# 本体の送信
$session->start_main(*STDOUT, 'test.html', 'text/html', 'UTF-8');
print << 'EOF';
<html>
  <head>
    <title>テストドキュメント</title>
    <link rel="StyleSheet" type="text/css" href="skin.css">
  </head>
  <body>
    <p>こんにちは</p>
  </body>
</html>
EOF
$session->end_main(*STDOUT);

# セッションを閉じる
$session->close();
