#!/usr/bin/perl
=head1 NAME

クライアント側リソース変換サンプル

=head2 概要

test.css,test.htmlを変換します。

=cut
use strict;
use lib '../code';
use CTI::DriverManager;

my $uri = 'ctip://localhost:8099/';
my $session = CTI::DriverManager::get_session($uri,
	user => 'user', password => 'kappa');
	
$session->set_output_as_handle(*STDOUT, 1);

$session->property('output.pdf.compression', 'ascii');

$session->set_resolver_func(sub {
	my ($uri, $open) = @_;
	if (-e $uri) {
	  my $fp = $open->();
	  open(my $rfp, "<$uri");
	  while (<$rfp>) {print $fp $_};
	  close($rfp);
	}
	return undef;
});

$session->start_main(*STDOUT, 'test.html');
open(my $fp, '<test.html');
while (<$fp>) {print};
close($fp);
$session->end_main(*STDOUT);

$session->close();
